<?php
/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
if(ZIBANMA_SYS_LINK != 'zibanma_com'){
	die('access deny');
}
class ZibanmaDatabase extends ZibanmaMysql{
	private static $_database;
	private static $table;
	
	private function __construct(){
		$this->db_host = ZIBANMA_DB_HOST;
		$this->db_user = ZIBANMA_DB_USER;
		$this->db_password = ZIBANMA_DB_PASSWORD;
		$this->db_selectdb = ZIBANMA_DB_SELECTDB;
		$this->db_prefix = ZIBANMA_DB_PREFIX;
		$this->db_port = ZIBANMA_DB_PORT;
		$this->connect();
	}
	
	public static function get_instance($table=null){
		if(!(self::$_database instanceof self)){
			self::$_database = new self();
		}
		self::$table = self::$_database->get_prefix().$table;
		return self::$_database;
	}
	
	/**
	 * @param array $insert
	 * @return int
	 */
	public function insert($insert){
		$field = array();
		$value = array();
		if(is_array($insert)){
			foreach ($insert as $key=>$val){
				$field[] = '`'.$key.'`';
				$value[] = '\''.str_replace('\'', '\\\'', $val).'\'';
			}
		}
		$status = $this->execute("insert into ".self::$table." (".implode(',', $field).") values (".implode(',', $value).");");
		return $status ? $this->getLastInsertId() : 0;
	}
	
	/**
	 * @param array $update
	 * return boolean
	 */
	public function update($update){
		$set = array();
		$where = array();
		if($update['set']){
			foreach ($update['set'] as $key=>$val){
				$set[] = '`'.$key.'`'.'='.'\''.str_replace('\'', '\\\'', $val).'\'';
			}
		}
		if($update['where']){
			foreach ($update['where'] as $key=>$val){
				$where[] = '`'.$val[0].'`'.$val[1].'\''.str_replace('\'', '\\\'', $val[2]).'\'';
			}
		}
		$this->execute("update ".self::$table." set ".implode(',', $set).' where 1=1 and '.implode(' and ', $where).";");
	}
	
	public function select($select){}
	
	public function delete($delete){}
	
}
?>