<?php
/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
if(ZIBANMA_SYS_LINK != 'zibanma_com'){
	die('access deny');
}
class ZibanmaCommon{
	
	public function show_message($message){
		return "<script type=\"text/javascript\">alert('{$message}');</script>";
	}
	
	public function show_message_url($message, $url){
		return "<script type=\"text/javascript\">alert('{$message}');window.location.href='{$url}';</script>";
	}
	
	public function show_url($url){
		return "<script type=\"text/javascript\">window.location.href='{$url}';</script>";
	}
	
	/**
	 * 获取伪静态路径
	 */
	public function get_rewriter_url($url){
		return ZIBANMA_CONFIG_REWRITER == 1 ? '/'.$url.'/' : '/?'.$url;
	}
	
	/**
	 * 获取伪静态路径
	 * @param array $arr
	 */
	public function get_rewriter_url_arr($arr){
		return ZIBANMA_CONFIG_REWRITER == 1 ? '/'.implode('-', $arr).'/' : '/?'.implode('-', $arr);
	}
	
	/**
	 * json转义
	 */
	public function json_convert($json){
		return str_replace('\\', '\\\\', $json);
	}
	
	public function json_convert_str($str){
		return str_replace('\"', '"', $str);
	}
	
	/**
	 * json生成
	 */
	public function json_create($arr){
		return "(".json_encode($arr).")";
	}
	
	/**
	 * 过滤脚本
	 */
	public function filter_script($str){
		$conf = array(
			'script' => '[script]',
			'iframe' => '[iframe]',
		);
		foreach ($conf as $k=>$v){
			$str = str_replace($str, $k, $v);
		}
		return $str;
	}
	
}
?>