; (function($) {
	$.fn.extend({
		iFadeSlide: function(options) {
			var iset = {
				field: $('div#slide img'),
				icocon: $('div.ico'),
				hoverCls: 'high',
				curIndex: 0,
				outTime: 200,
				inTime: 300,
				interval: 3000
			};
			options = options || {};
			$.extend(iset, options);
			var ulcon = "<ul>";
			iset.field.each(function(i) {
				ulcon = ulcon + '<span>' + (i + 1) + '</span>'
			});
			ulcon += '</ul>';
			iset.icocon.append(ulcon);
			var ico = iset.icocon.find('span');
			var size = iset.field.size();
			var index = 0;
			var clearFun = null;
			var fadeFun = function(obj) {
				index = ico.index(obj);
				iset.field.filter(':visible').fadeOut(iset.outTime,
				function() {
					iset.field.eq(index).fadeIn(iset.inTime)
				});
				$(obj).addClass(iset.hoverCls).siblings().removeClass(iset.hoverCls)
			};
			var changeFun = function() {
				index++;
				if (index == size) {
					index = 0
				};
				ico.eq(index).trigger('mouseleave')
			};
			var scrollFun = function() {
				clearFun = setInterval(function() {
					changeFun()
				},
				iset.interval)
			};
			var stopFun = function() {
				clearInterval(clearFun)
			};
			scrollFun();
			ico.hover(function() {
				stopFun();
				fadeFun(this)
			},
			function() {
				fadeFun(this)
			}).eq(iset.curIndex).mouseleave();
			iset.field.hover(function() {
				stopFun()
			},
			function() {
				scrollFun()
			})
		}
	})
})(jQuery);