<?php
/*
	[Destoon B2B System] Copyright (c) 2008-2010 Destoon.COM
	This is NOT a freeware, use is subject to license.txt
*/
if (! defined ( 'APP_PATH' ) || ! defined ( 'I_PATH' )) {
	exit ( 'Access Denied' );
}

function ldmail($mail_to, $mail_subject, $mail_body, $mail_from = '', $mail_sign = true) {
	$sysConfig = syDB ( 'sysconfig' )->findAll ();
	$configs = array ();
	foreach ( $sysConfig as $v ) {
		$configs [$v ['code']] = $v ['value'];
	}
	global $iConfig;
	if ($configs ['mail_type'] == 'close')
		return false;
	$sendmail_from = $mail_from ? $mail_from : $configs ['mail_sender'];
	$mail_from = "=?" . strtolower ( $configs['charset'] ) . "?B?" . base64_encode ( $configs ['mail_name'] ? $configs ['mail_name'] :$iConfig['ext']['site_name'] ) . "?= <" . $sendmail_from . ">";
	$mail_subject = stripslashes ( $mail_subject );
	$mail_subject = str_replace ( "\r", '', str_replace ( "\n", '', $mail_subject ) );
	$mail_subject = "=?" . strtolower ( $configs['charset'] ) . "?B?" . base64_encode ( $mail_subject ) . "?=";
	if ($configs ['mail_sign'] && $mail_sign)
		$mail_body .= $configs ['mail_sign'];
	$mail_body = stripslashes ( $mail_body );
	$mail_body = chunk_split ( base64_encode ( str_replace ( "\r\n.", " \r\n..", str_replace ( "\n", "\r\n", str_replace ( "\r", "\n", str_replace ( "\r\n", "\n", str_replace ( "\n\r", "\r", $mail_body ) ) ) ) ) ) );
	$mail_dlmt = $configs ['mail_delimiter'] == 1 ? "\r\n" : ($configs ['mail_delimiter'] == 2 ? "\n" : "\r");
	$headers = '';
	$headers .= "From: $mail_from" . $mail_dlmt;
	$headers .= "X-Priority: 3" . $mail_dlmt;
	$headers .= "X-Mailer: Destoon" . $mail_dlmt;
	$headers .= "MIME-Version: 1.0" . $mail_dlmt;
	$headers .= "Content-type: text/html; charset=" . $configs['charset'] . $mail_dlmt;
	$headers .= "Content-Transfer-Encoding: base64" . $mail_dlmt;
	if ($configs ['mail_type'] == 'smtp') {
		$host = $configs ['smtp_host'] . ':' . $configs ['smtp_port'] . ' ';
		if (! $fp = fsockopen ( $configs ['smtp_host'], $configs ['smtp_port'], $errno, $errstr, 30 )) {
			$errmsg = $host . 'can not connect to the SMTP server';
			if (defined ( 'TESTMAIL' ))
				dalert ( 'Error:' . trim ( $errmsg ) );
			log_write ( $errmsg, 'smtp' );
			return false;
		}
		stream_set_blocking ( $fp, true );
		$RE = fgets ( $fp, 512 );
		if (substr ( $RE, 0, 3 ) != '220') {
			$errmsg = $host . $RE;
			if (defined ( 'TESTMAIL' ))
				dalert ( 'Error:' . trim ( $errmsg ) );
			log_write ( $errmsg, 'smtp' );
			return false;
		}
		fputs ( $fp, ($configs ['smtp_auth'] ? 'EHLO' : 'HELO') . " Destoon\r\n" );
		$RE = fgets ( $fp, 512 );
		if (substr ( $RE, 0, 3 ) != 220 && substr ( $RE, 0, 3 ) != 250) {
			$errmsg = $host . 'HELO/EHLO - ' . $RE;
			if (defined ( 'TESTMAIL' ))
				dalert ( 'Error:' . trim ( $errmsg ) );
			log_write ( $errmsg, 'smtp' );
			return false;
		}
		while ( 1 ) {
			if (substr ( $RE, 3, 1 ) != '-' || empty ( $RE ))
				break;
			$RE = fgets ( $fp, 512 );
		}
		
		if ($configs ['smtp_auth']) {
			fputs ( $fp, "AUTH LOGIN\r\n" );
			$RE = fgets ( $fp, 512 );
			if (substr ( $RE, 0, 3 ) != 334) {
				$errmsg = $host . 'AUTH LOGIN - ' . $RE;
				if (defined ( 'TESTMAIL' ))
					dalert ( 'Error:' . trim ( $errmsg ) );
				log_write ( $errmsg, 'smtp' );
				return false;
			}
			fputs ( $fp, base64_encode ( $configs ['smtp_user'] ) . "\r\n" );
			$RE = fgets ( $fp, 512 );
			if (substr ( $RE, 0, 3 ) != 334) {
				$errmsg = $host . 'USERNAME - ' . $RE;
				if (defined ( 'TESTMAIL' ))
					dalert ( 'Error:' . trim ( $errmsg ) );
				log_write ( $errmsg, 'smtp' );
				return false;
			}
			fputs ( $fp, base64_encode ( $configs ['smtp_pass'] ) . "\r\n" );
			$RE = fgets ( $fp, 512 );
			if (substr ( $RE, 0, 3 ) != 235) {
				$errmsg = $host . 'PASSWORD - ' . $RE;
				if (defined ( 'TESTMAIL' ))
					dalert ( 'Error:' . trim ( $errmsg ) );
				log_write ( $errmsg, 'smtp' );
				return false;
			}
			$mail_from = $configs ['smtp_user'];
		} else {
			$mail_from = $configs ['mail_sender'];
		}
		fputs ( $fp, "MAIL FROM: <" . preg_replace ( "/.*\<(.+?)\>.*/", "\\1", $mail_from ) . ">\r\n" );
		$RE = fgets ( $fp, 512 );
		if (substr ( $RE, 0, 3 ) != 250) {
			fputs ( $fp, "MAIL FROM: <" . preg_replace ( "/.*\<(.+?)\>.*/", "\\1", $mail_from ) . ">\r\n" );
			$RE = fgets ( $fp, 512 );
			if (substr ( $RE, 0, 3 ) != 250) {
				$errmsg = $host . 'MAIL FROM - ' . $RE;
				if (defined ( 'TESTMAIL' ))
					dalert ( 'Error:' . trim ( $errmsg ) );
				log_write ( $errmsg, 'smtp' );
				return false;
			}
		}
		foreach ( explode ( ',', $mail_to ) as $touser ) {
			$touser = trim ( $touser );
			if ($touser) {
				fputs ( $fp, "RCPT TO: <" . preg_replace ( "/.*\<(.+?)\>.*/", "\\1", $touser ) . ">\r\n" );
				$RE = fgets ( $fp, 512 );
				if (substr ( $RE, 0, 3 ) != 250) {
					fputs ( $fp, "RCPT TO: <" . preg_replace ( "/.*\<(.+?)\>.*/", "\\1", $touser ) . ">\r\n" );
					$RE = fgets ( $fp, 512 );
					$errmsg = $host . 'RCPT TO - ' . $RE;
					if (defined ( 'TESTMAIL' ))
						dalert ( 'Error:' . trim ( $errmsg ) );
					log_write ( $errmsg, 'smtp' );
					return false;
				}
			}
		}
		fputs ( $fp, "DATA\r\n" );
		$RE = fgets ( $fp, 512 );
		if (substr ( $RE, 0, 3 ) != 354) {
			$errmsg = $host . 'DATA - ' . $RE;
			if (defined ( 'TESTMAIL' ))
				dalert ( 'Error:' . trim ( $errmsg ) );
			log_write ( $errmsg, 'smtp' );
			return false;
		}
		list ( $msec, $sec ) = explode ( ' ', microtime () );
		$headers .= "Message-ID: <" . date ( 'YmdHis', $sec ) . "." . ($msec * 1000000) . "." . substr ( $mail_from, strpos ( $mail_from, '@' ) ) . ">" . $mail_dlmt;
		fputs ( $fp, "Date: " . date ( 'r' ) . "\r\n" );
		fputs ( $fp, "To: " . $mail_to . "\r\n" );
		fputs ( $fp, "Subject: " . $mail_subject . "\r\n" );
		fputs ( $fp, $headers . "\r\n" );
		fputs ( $fp, "\r\n\r\n" );
		fputs ( $fp, "$mail_body\r\n.\r\n" );
		$RE = fgets ( $fp, 512 );
		if (substr ( $RE, 0, 3 ) != 250) {
			$errmsg = $host . 'END - ' . $RE;
			if (defined ( 'TESTMAIL' ))
				dalert ( 'Error:' . trim ( $errmsg ) );
			log_write ( $errmsg, 'smtp' );
			return false;
		}
		fputs ( $fp, "QUIT\r\n" );
		return true;
	} else {
		if ($configs ['mail_type'] != 'mail') {
			ini_set ( 'SMTP', $configs ['smtp_host'] );
			ini_set ( 'smtp_port', $configs ['smtp_port'] );
			ini_set ( 'sendmail_from', $sendmail_from );
		}
		return @mail ( $mail_to, $mail_subject, $mail_body, $headers );
	}
}