$(function(){
	// 字符最小长度验证（一个中文字符长度为2）
	jQuery.validator.addMethod("stringMinLength", function(value, element, param) {
	 var length = value.length;
	 for ( var i = 0; i < value.length; i++) {
	  if (value.charCodeAt(i) > 127) {length++;}
	 }
	 return this.optional(element) || (length >= param);
	}, $.validator.format("长度不能小于{0}!"));
	
	// 字符最大长度验证（一个中文字符长度为2）
	jQuery.validator.addMethod("stringMaxLength", function(value, element, param) {
	 var length = value.length;
	 for ( var i = 0; i < value.length; i++) {
	  if (value.charCodeAt(i) > 127) {length++;}
	 }
	 return this.optional(element) || (length <= param);
	}, $.validator.format("长度不能大于{0}!"));
	
	// 字符验证
	jQuery.validator.addMethod("string", function(value, element) {
	 return this.optional(element) || /^[\u0391-\uFFE5\w]+$/.test(value);
	}, "不允许包含特殊符号!");
	
	// 手机号码验证
	jQuery.validator.addMethod("mobile", function(value, element) {
	 var length = value.length;
	 return this.optional(element) || (length == 11 && /^(((13[0-9]{1})|(15[0-9]{1}))+\d{8})$/.test(value));
	}, "手机号码格式错误!");
	
	// 电话号码验证
	jQuery.validator.addMethod("phone", function(value, element) {
	 var tel = /^(\d{3,4}-?)?\d{7,9}$/g;
	 return this.optional(element) || (tel.test(value));
	}, "电话号码格式错误!");
	
	// 邮政编码验证
	jQuery.validator.addMethod("zipCode", function(value, element) {
	 var tel = /^[0-9]{6}$/;
	 return this.optional(element) || (tel.test(value));
	}, "邮政编码格式错误!");
	
	// 必须以特定字符串开头验证
	jQuery.validator.addMethod("begin", function(value, element, param) {
	 var begin = new RegExp("^" + param);
	 return this.optional(element) || (begin.test(value));
	}, $.validator.format("必须以 {0} 开头!"));
	
	// 验证值小数位数不能超过两位
	jQuery.validator.addMethod("decimal", function(value, element) {
	 var decimal = /^-?\d+(\.\d{1,2})?$/;
	 return this.optional(element) || (decimal.test(value));
	}, $.validator.format("小数位数不能超过两位!"));

});
