<?php
/**
 *  index.php
 *
 * @copyright			(C) 2005-2010 NewsTeng Inc.
 * @license				This is NOT a freeware, use is subject to license terms
 * @lastmodify			2010-12-16
   $Id: index.php 8 2011-01-29 02:36:15Z xuchao $
 */
defined ( 'IN_XTCMS' ) or exit ( 'No permission resources.' );
$session_storage = 'session_' . base::load_config ( 'system', 'session_storage' );
base::load_sys_class ( $session_storage );
if (! isset ( $_SESSION )) session_start ();
base::load_app_class ( 'content', 'content', 0 );
base::load_sys_class ( 'form', '', 0 );
class index extends content {
	private $config;

	public function __construct() {
		parent::__construct ();
		$this->config = base::load_config ( 'system' );
		$this->site_name = $this->settings ['site_name'];
	}

	/*
	 * 首页
	 */
	public function init() {
		$page_size = $this->settings ['index_page_size'];
		$lovearr = $this->db->listinfo ( '', 'lid DESC', 1, $page_size );
		base::load_sys_class ( 'format', '', 0 );
		foreach ( $lovearr as $key => $v ) {
			$lovearr [$key] ['postdate'] = format::date ( $v ['postdate'], 1 );
		}
		$seo = seo ();
		include template ( 'index' );
	}
	/*
	 * 发布
	 */
	public function add() {
		if (isset ( $_POST ['dosubmit'] )) {
			$code = isset ( $_POST ['code'] ) && trim ( $_POST ['code'] ) ? trim ( $_POST ['code'] ) : showmessage ( L ( 'input_code' ), HTTP_REFERER );
			if ($_SESSION ['code'] != strtolower ( $code )) {
				showmessage ( L ( 'code_error' ), HTTP_REFERER );
			}
			$ip = ip ();
			// 发布次数
			$this->times_db = base::load_model ( 'times_model' );
			$rtime = $this->times_db->get_one ( array ('ip' => $ip ) );
			if ($rtime ['times'] > 4) {
				$minute = 60 - floor ( (SYS_TIME - $rtime ['logintime']) / 60 );
				if ($minute < 1) {
					$this->times_db->delete ( array ('ip' => $ip ) );
				} else {
					showmessage ( L ( 'wait_1_hour', array ('minute' => $minute ) ) );
				}
			}
			if (! $this->check_content ( $_POST ['content'] )) showmessage ( L ( 'illegal_denystr' ), HTTP_REFERER );
			$info = array ();
			$info ['content'] = xt_stripslashes ( $_POST ['content'] );
			$info ['send'] = $_POST ['send'];
			$info ['pick'] = $_POST ['pick'];
			$info ['icon'] = $_POST ['icon'];
			$info ['face'] = $_POST ['face'];
			$info ['postdate'] = SYS_TIME;
			$info ['postip'] = ip ();
			$this->push_yun ( $info );
			$lid = $this->db->insert ( $info, 1, 1 );
			if ($lid) {
				if ($rtime && $rtime ['times'] < 5) {
					$times = 5 - intval ( $rtime ['times'] );
					$this->times_db->update ( array ('times' => '+=1' ), array ('ip' => $ip ) );
				} else {
					$this->times_db->insert ( array ('ip' => $ip,'logintime' => SYS_TIME,'times' => 1 ) );
					$times = 5;
				}
				showmessage ( L ( 'operation_success' ), HTTP_REFERER );
			}
		} else {
			$seo = seo ();
			include template ( 'add' );
		}
	}
	/*
	 * 字条列表
	 */
	public function getlist() {
		$page = isset ( $_GET ['page'] ) && intval ( $_GET ['page'] ) ? intval ( $_GET ['page'] ) : 1;
		$list = $this->db->listinfo ( '', 'lid DESC', $page, $this->settings ['page_size'] );
		base::load_sys_class ( 'format', '', 0 );
		foreach ( $list as $key => $v ) {
			$list [$key] ['postdate'] = format::date ( $v ['postdate'], 1 );
		}
		$pages = $this->db->pages;
		$seo = seo ();
		include template ( 'list' );
	}
	public function show() {
		$page_size = $this->settings ['index_page_size'];
		$lid = isset ( $_GET ['id'] ) && intval ( $_GET ['id'] ) ? intval ( $_GET ['id'] ) : showmessage ( L ( 'illegal_parameters' ), HTTP_REFERER );
		$lovearr = $this->db->listinfo ( "lid <='$lid'", 'lid DESC', 1, $page_size );
		base::load_sys_class ( 'format', '', 0 );
		foreach ( $lovearr as $key => $v ) {
			$lovearr [$key] ['postdate'] = format::date ( $v ['postdate'], 1 );
		}
		$seo = seo ();
		include template ( 'index' );
	}
	/*
	 * JS调用
	 */
	public function js() {
		$page_size = $this->settings ['js_size'];
		$lovearr = $this->db->listinfo ( '', 'lid DESC', 1, $page_size );
		base::load_sys_class ( 'format', '', 0 );
		foreach ( $lovearr as $key => $v ) {
			$lovearr [$key] ['content'] = str_cut ( $v ['content'], $this->settings ['js_content_length'] );
			$lovearr [$key] ['postdate'] = format::date ( $v ['postdate'], 1 );
		}
		include template ( 'js' );
	}
	/*
	 * 非法关键词判断
	 */
	private function check_content($content) {
		$denyestr = $this->settings ['denyestr'];
		if (is_array ( $denyestr )) {
			$denyestr = implode ( "|", $denyestr );
			$pattern = '/^(' . str_replace ( array ('\\*',' ',"\|" ), array ('.*','','|' ), preg_quote ( $denyestr, '/' ) ) . ')$/i';
			if (preg_match ( $pattern, $content )) {
				return false;
			} else {
				return true;
			}
		}
	}
	function push_yun($data) {
		if (stristr ( APP_PATH, '127.' )) return false;
		if (stristr ( APP_PATH, 'local' )) return false;
		$http = base::load_sys_class ( 'http' );
		$http->post ( 'http://www.tintsoft.com/index.php?app=love&controller=push', $data );
		if ($http->is_ok ()) return true;
	}
}