<?php

/**
 *--------------------------------------
 * upgrade
 *--------------------------------------
 * @project		: upgrade
 * @author		: cblee
 * @created		: 2013-12-27
 * @copyright	: (c)2013 AsThis
 *--------------------------------------
 */

class IndexCtrlr extends Ctrlr {
	public function __construct() {
		parent::__construct();
		$_C = require_cache(CONFIG_FILE);
		C('DB', $_C['DB']);
	}

	public function index() {
		check_lock();

		if(!isset($_GET[C('VAR.LANG')])) {
			$this->step0();
		}
		else {
			$step = isset($_POST['step']) ? $_POST['step'] : 1;
			switch ($step) {
				case '1':
					$this->step1();
					break;
				case '2':
					$this->step2();
					break;
				case '3':
					$this->step3();
					break;
				case '4':
					$this->step4();
					break;
				default:
					$this->step1();
					break;
			}
		}
	}

	/* choose language */
	private function step0() {
		$_LANGSET = get_langset();
		$selectHight = count($_LANGSET) > 5 ? count($_LANGSET) : 5;
		$hal = strtolower(substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 5));
		$this->assign('selectHight', $selectHight);
		$this->assign('hal', $hal);
		$this->assign('_LANGSET', $_LANGSET);
		$this->display('index');
	}

	/* show introduce */
	private function step1() {
		$this->display('step1');
	}

	/* check environment */
	private function step2() {
		$checkNextStep = true;

		/* check system */
		$systemItems = C('CHECK_ITEMS.SYSTEM');
		if(!empty($systemItems)) {
			check_system($systemItems, $checkNextStep);
			foreach($systemItems as $k => $v) {
				$systemItems[L($k)]['r'] = L($v['r']);
				$systemItems[L($k)]['b'] = L($v['b']);
				$systemItems[L($k)]['c'] = L($v['c']);
				if(1 == $v['s']) {
					$systemItems[L($k)]['c_c'] = 'class="y"';
				}
				else {
					$systemItems[L($k)]['c_c'] = 'class="n"';
				}
				unset($systemItems[$k]);
			}
		}

		/* check dir and file */
		$dirFileItems = C('CHECK_ITEMS.DIR_FILE');
		if(!empty($dirFileItems)) {
			check_dirfile($dirFileItems, $checkNextStep);
			foreach($dirFileItems as $k => $v) {
				$dirFileItems[L($k)]['type'] = L($v['type']);
				$dirFileItems[L($k)]['c'] = L($v['c']);
				$dirFileItems[L($k)]['path'] = $v['path'];
				if(1 == $v['s']) {
					$dirFileItems[L($k)]['c_c'] = 'class="y"';
				}
				else {
					$dirFileItems[L($k)]['c_c'] = 'class="n"';
				}
				unset($dirFileItems[$k]);
			}
		}

		/* check php config */
		$phpConfigItems = C('CHECK_ITEMS.PHP_CONFIG');
		if(!empty($phpConfigItems)) {
			check_php_config($phpConfigItems, $checkNextStep);
			foreach($phpConfigItems as $k => $v) {
				if(1 == $v['s']) {
					$phpConfigItems[$k]['c_c'] = 'class="y"';
				}
				else {
					$phpConfigItems[$k]['c_c'] = 'class="n"';
				}
			}
		}

		/* check extension */
		$extensionItems = C('CHECK_ITEMS.EXTENSION');
		if(!empty($extensionItems)) {
			check_extension($extensionItems, $checkNextStep);
			foreach($extensionItems as $k => $v) {
				if(1 == $v['s']) {
					$extensionItems[$k]['c_c'] = 'class="y"';
					$extensionItems[$k]['s'] = L('SUPPORT');
				}
				else {
					$extensionItems[$k]['c_c'] = 'class="n"';
					$extensionItems[$k]['s'] = L('NONSUPPORT');
				}
			}
		}

		/* check function */
		$functionItems = C('CHECK_ITEMS.FUNCTION');
		if(!empty($functionItems)) {
			check_function($functionItems, $checkNextStep);
			foreach($functionItems as $k => $v) {
				if(1 == $v['s']) {
					$functionItems[$k]['c_c'] = 'class="y"';
					$functionItems[$k]['s'] = L('SUPPORT');
				}
				else {
					$functionItems[$k]['c_c'] = 'class="n"';
					$functionItems[$k]['s'] = L('NONSUPPORT');
				}
			}
		}

		$this->assign('checkNextStep', $checkNextStep);
		$this->assign('systemItems', $systemItems);
		$this->assign('dirFileItems', $dirFileItems);
		$this->assign('phpConfigItems', $phpConfigItems);
		$this->assign('extensionItems', $extensionItems);
		$this->assign('functionItems', $functionItems);
		$this->display('step2');
	}

	/* write data */
	private function step3() {
		$sql = file_get_contents(SQL_FILE);
		$sql = str_replace(
			array(
				'{-time-}',
				'{-ip-}',
				'{-site_url-}'
			),
			array(
				time(),
				AServer::get_ip(),
				SITE_URL
			),
			$sql);
		@file_put_contents(DATA_PATH . D_S . '~data.sql', $sql);

		$this->display('step3');

		/* 运行SQL */
		run_sql(DATA_PATH . D_S . '~data.sql');

		/* 替换数据 */
		//$rowNum = M('ArchiveAddonArticle')->count();
		//$pagesize = 10;
		//$totalPage = ceil($rowNum / $pagesize);
		//for($i = 0; $i <= $totalPage; $i++) {
		//	$article = M('ArchiveAddonArticle')->limit($i * $pagesize . ',' . $pagesize)->select();
		//	foreach($article as $k => $v) {
		//		M('ArchiveAddonArticle')->update(array(
		//			'archive_id' => $v['archive_id'],
		//			'a_a_content' => str_replace('#uwa_paging#', '<p>#uwa_paging#</p>', $v['a_a_content']),
		//		));
		//	}
		//	$m = L('REPLACE_DATA');
		//	if($i = $totalPage) {
		//		$m = L('UPGRADE_SUCCESS');
		//	}
		//	$b = round($i / $totalPage * 100, 0);
		//	show_progress($m, $b);
		//}

		/* 更新版本号 */
		$define = file_get_contents(DEFINE_FILE);
		$define = preg_replace('/define\(\'SOFT_VERSION\', \'(.*)\'\);/i', 'define(\'SOFT_VERSION\', \'' . SOFT_VERSION_TO . '\');', $define);
		@file_put_contents(DEFINE_FILE, $define);

		/* 更新配置文件 */
		$_C = include(CONFIG_FILE);
		$_C['LANG']['DETECT'] = false;
		save_config_file(CONFIG_FILE, $_C);

		/* 删除临时文件 */
		@unlink(DATA_PATH . D_S . '~data.sql');
		$runtimeFile = dirname(APP_PATH) . D_S . 'runtime' . D_S . '~runtime.php';
		@unlink($runtimeFile);
	}

	/* lock installation */
	private function step4() {
		lock();
		$this->display('step4');
	}

}
?>