<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8" />
<title></title>
<link rel="stylesheet" type="text/css" href="{-:*__THEME__-}admin/css/c.css" />
<link rel="stylesheet" type="text/css" href="{-:*__THEME__-}admin/css/mf.css" />
</head>
<body>
<form id="formEdit" action="" method="post">
<dl class="atab">
	<dt><strong>{-:@SITE-}</strong><strong>{-:@CORE-}</strong><strong>{-:@PERFORMANCE-}</strong><strong>{-:@UPLOAD-}</strong><strong>{-:@IMAGE-}</strong><strong>{-:@MEMBER-}</strong><strong>{-:@INTERACTION-}</strong></dt>
	<dd>
		<div class="tabCntnt"><!--SITE-->
			<table class="formTable">
				<tr>
					<td class="inputTitle">{-:@SITE_NAME-} [site/name]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['site']['name']-}" name="site[name]" maxlength="255" size="50">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@SITE_NAME_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_HOST-} [site/host]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['site']['host']-}" name="site[host]" maxlength="255" size="50">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@SITE_HOST_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_LOGO-} [site/logo]</td>
					<td rowspan="2" class="inputArea">
						<img id="site_logo_preview" src="{-:$_O['site']['logo']-}" />
					</td>
				</tr>
				<tr>
					<td class="inputArea">
						<input id="site_logo" class="required i" type="text" value="{-:$_O['site']['logo']-}" name="site[logo]" maxlength="255" size="50">
						<input id="site_logo_uploader" to="#site_logo" preview="#site_logo_preview" btntext="{-:@UPLOAD-}" typeset='image' class="uploader" type="file" />
						<span id="site_logo_finder" to="#site_logo" preview="#site_logo_preview" typeset='image' class="btn_l finder">{-:@BROWSE_SERVER-}</span>
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_LANGUAGE-} [site/language]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<select name="site[language]">
						{-foreach:$_LANGSET,$lang-}
							<option value="{-:$lang['alias']-}"{-if:$lang['alias']==$_O['site']['language']-} selected="selected"{-:/if-}>{-:$lang['name']-}</option>
						{-:/foreach-}
						</select>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@SITE_LANGUAGE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@LANG_DETECT-} [site/lang_detect]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="site[lang_detect]"{-if:0==$_O['site']['lang_detect']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="site[lang_detect]"{-if:1==$_O['site']['lang_detect']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						{-:@LANG_DETECT_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_THEME-} [site/theme]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<select name="site[theme]">
						{-foreach:$_TPL,$tpl-}
							<option value="{-:$tpl['alias']-}"{-if:$tpl['alias']==$_O['site']['theme']-} selected="selected"{-:/if-}>{-:$tpl['name']-}</option>
						{-:/foreach-}
						</select>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@SITE_THEME_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@TPL_PROTECTION-} [site/tpl_protection]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="site[tpl_protection]"{-if:0==$_O['site']['tpl_protection']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="site[tpl_protection]"{-if:1==$_O['site']['tpl_protection']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						{-:@TPL_PROTECTION_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_KEYWORDS-} [site/keywords]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="i" name="site[keywords]" style="width:360px;height:40px;">{-:$_O['site']['keywords']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_KEYWORDS_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_DESCRIPTION-} [site/description]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="i" name="site[description]" style="width:360px;height:60px;">{-:$_O['site']['description']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_DESCRIPTION_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_COPYRIGHT-} [site/copyright]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="editor_simple" name="site[copyright]">{-:$_O['site']['copyright']|htmlspecialchars~@me-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_COPYRIGHT_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_STAT_CODE-} [site/stat_code]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="i" name="site[stat_code]" style="width:360px;height:60px;">{-:$_O['site']['stat_code']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_STAT_CODE_TIP-}
					</td>
				</tr>
			</table>
		</div><!--/.tabCntnt-->
		<div class="tabCntnt"><!--CORE-->
			<table class="formTable">
				<tr>
					<td class="inputTitle">{-:@HOST_PREFIX_SWITCH-} [core/host_prefix_switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="core[host_prefix_switch]"{-if:0==$_O['core']['host_prefix_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="core[host_prefix_switch]"{-if:1==$_O['core']['host_prefix_switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@HOST_PREFIX_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@REWRITE_SWITCH-} [core/rewrite_switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="core[rewrite_switch]"{-if:0==$_O['core']['rewrite_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="core[rewrite_switch]"{-if:1==$_O['core']['rewrite_switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@REWRITE_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@HTML_SWITCH-} [core/html_switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="core[html_switch]"{-if:0==$_O['core']['html_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="core[html_switch]"{-if:1==$_O['core']['html_switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@HTML_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@FORCED_HTML-} [core/forced_html]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="core[forced_html]"{-if:0==$_O['core']['forced_html']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="core[forced_html]"{-if:1==$_O['core']['forced_html']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@FORCED_HTML_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@GZIP_SWITCH-} [core/gzip_switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="core[gzip_switch]"{-if:0==$_O['core']['gzip_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="core[gzip_switch]"{-if:1==$_O['core']['gzip_switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@GZIP_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@CACHE_EXPIRE-} [core/cache_expire]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['core']['cache_expire']-}" name="core[cache_expire]" maxlength="20" size="10">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@CACHE_EXPIRE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@HTML_EXPIRE_INDEX-} [core/html_expire_index]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['core']['html_expire_index']-}" name="core[html_expire_index]" maxlength="20" size="10">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@HTML_EXPIRE_INDEX_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@HTML_EXPIRE_LIST-} [core/html_expire_list]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['core']['html_expire_list']-}" name="core[html_expire_list]" maxlength="20" size="10">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@HTML_EXPIRE_LIST_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@HTML_EXPIRE_ARCHIVE-} [core/html_expire_archive]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['core']['html_expire_archive']-}" name="core[html_expire_archive]" maxlength="20" size="10">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@HTML_EXPIRE_ARCHIVE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@HTML_PATH-} [core/html_path]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['core']['html_path']-}" name="core[html_path]" maxlength="255" size="50" />
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@HTML_PATH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@COOKIE_PREFIX-} [core/cookie_prefix]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['core']['cookie_prefix']-}" name="core[cookie_prefix]" maxlength="96" size="20">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@COOKIE_PREFIX_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@COOKIE_EXPIRE-} [core/cookie_expire]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['core']['cookie_expire']-}" name="core[cookie_expire]" maxlength="20" size="10">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@COOKIE_EXPIRE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@COOKIE_KEY-} [core/cookie_key]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['core']['cookie_key']-}" name="core[cookie_key]" maxlength="96" size="20">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@COOKIE_KEY_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@DEBUG_SWITCH-} [core/debug_switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="core[debug_switch]"{-if:0==$_O['core']['debug_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="core[debug_switch]"{-if:1==$_O['core']['debug_switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@DEBUG_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@DEBUG_STAT-} [core/debug_stat]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="core[debug_stat]"{-if:0==$_O['core']['debug_stat']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="core[debug_stat]"{-if:1==$_O['core']['debug_stat']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@DEBUG_STAT_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@DEBUG_PAGE_TRACE-} [core/debug_switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="core[debug_page_trace]"{-if:0==$_O['core']['debug_page_trace']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="core[debug_page_trace]"{-if:1==$_O['core']['debug_page_trace']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@DEBUG_PAGE_TRACE_TIP-}
					</td>
				</tr>
			</table>
		</div><!--/.tabCntnt-->
		<div class="tabCntnt"><!--PERFORMANCE-->
			<table class="formTable">
				<tr>
					<td class="inputTitle">{-:@CACHE_TYPE-} [performance/cache_type]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="File" name="performance[cache_type]"{-if:'File'==$_O['performance']['cache_type']-} checked="checked"{-:/if-}> {-:@FILE_CACHE-}</label>
						<label><input type="radio" value="Memcache" name="performance[cache_type]"{-if:'Memcache'==$_O['performance']['cache_type']-} checked="checked"{-:/if-}> {-:@MEMCACHE-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@CACHE_TYPE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@MEMCACHE_HOST-} [performance/memcache_host]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['performance']['memcache_host']-}" name="performance[memcache_host]" maxlength="50" size="20">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@MEMCACHE_HOST_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@MEMCACHE_PORT-} [performance/memcache_port]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['performance']['memcache_port']-}" name="performance[memcache_port]" maxlength="5" size="5">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@MEMCACHE_PORT_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SPHINX_SWITCH-} [performance/sphinx_switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="performance[sphinx_switch]"{-if:0==$_O['performance']['sphinx_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="performance[sphinx_switch]"{-if:1==$_O['performance']['sphinx_switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@SPHINX_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SPHINX_HOST-} [performance/sphinx_host]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['performance']['sphinx_host']-}" name="performance[sphinx_host]" maxlength="50" size="20">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@SPHINX_HOST_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SPHINX_PORT-} [performance/sphinx_port]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['performance']['sphinx_port']-}" name="performance[sphinx_port]" maxlength="5" size="5">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@SPHINX_PORT_TIP-}
					</td>
				</tr>
			</table>
		</div><!--/.tabCntnt-->
		<div class="tabCntnt"><!--UPLOAD-->
			<table class="formTable">
				<tr>
					<td class="inputTitle">{-:@UPLOAD_SWITCH-} [upload/switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="upload[switch]"{-if:0==$_O['upload']['switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="upload[switch]"{-if:1==$_O['upload']['switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@UPLOAD_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@UPLOAD_IMGTYPE-} [upload/imgtype]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['upload']['imgtype']-}" name="upload[imgtype]" maxlength="255" size="50" />
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@UPLOAD_IMGTYPE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@UPLOAD_FILETYPE-} [upload/filetype]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['upload']['filetype']-}" name="upload[filetype]" maxlength="255" size="50" />
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@UPLOAD_FILETYPE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@UPLOAD_DIR-} [upload/dir]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['upload']['dir']-}" name="upload[dir]" maxlength="255" size="50" />
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@UPLOAD_DIR_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@UPLOAD_SUB_DIR-} [upload/sub_dir]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="i" type="text" value="{-:$_O['upload']['sub_dir']-}" name="upload[sub_dir]" maxlength="255" size="50" />
					</td>
					<td class="inputTip">
						{-:@UPLOAD_SUB_DIR_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@UPLOAD_MAXSIZE-} [upload/maxsize]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['upload']['maxsize']-}" name="upload[maxsize]" maxlength="255" size="50" />
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@UPLOAD_MAXSIZE_TIP-}
					</td>
				</tr>
			</table>
		</div><!--/.tabCntnt-->
		<div class="tabCntnt"><!--IMAGE-->
			<table class="formTable">
				<tr>
					<td class="inputTitle">{-:@THUMB_PREFIX-} [image/thumb_prefix]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['image']['thumb_prefix']-}" name="image[thumb_prefix]" maxlength="96" size="20">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@THUMB_PREFIX_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@THUMB_WIDTH-} [image/thumb_width]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['image']['thumb_width']-}" name="image[thumb_width]" maxlength="20" size="10">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@THUMB_WIDTH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@THUMB_HEIGHT-} [image/thumb_height]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['image']['thumb_height']-}" name="image[thumb_height]" maxlength="20" size="10">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@THUMB_HEIGHT_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@THUMB_PROPORTIONAL-} [image/thumb_proportional]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="image[thumb_proportional]"{-if:0==$_O['image']['thumb_proportional']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="image[thumb_proportional]"{-if:1==$_O['image']['thumb_proportional']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@THUMB_PROPORTIONAL_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@WATERMARK-} [image/watermark]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="image[watermark]"{-if:0==$_O['image']['watermark']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="image[watermark]"{-if:1==$_O['image']['watermark']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@WATERMARK_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@WATERMARK_IMAGE-} [image/watermark_image]
						<span class="fc_gry"><span class="fc_r">*</span> {-:@WATERMARK_IMAGE_TIP-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input id="watermark_image" class="required i" type="text" value="{-:$_O['image']['watermark_image']-}" name="image[watermark_image]" maxlength="255" size="50">
						<input id="watermark_image_uploader" to="#watermark_image" preview="#watermark_image_preview" btntext="{-:@UPLOAD-}" typeset='image' class="uploader" type="file" />
					</td>
					<td class="inputTip">
						<img id="watermark_image_preview" src="{-:$_O['image']['watermark_image']-}" />
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@WATERMARK_POSITION-} [image/watermark_position]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<table class="listTable" style="width:280px">
							<tr>
								<td colspan="3">
						<label><input type="radio" value="0" {-if:0==$_O['image']['watermark_position']-} checked="checked"{-:/if-} name="image[watermark_position]"> {-:@RANDOM-}</label>
								</td>
							</tr>
							<tr>
								<td>
						<label><input type="radio" value="1" {-if:1==$_O['image']['watermark_position']-} checked="checked"{-:/if-} name="image[watermark_position]"> {-:@TOP_LEFT-}</label>
								</td>
								<td>
						<label><input type="radio" value="2" {-if:2==$_O['image']['watermark_position']-} checked="checked"{-:/if-} name="image[watermark_position]"> {-:@TOP_CENTER-}</label>
								</td>
								<td>
						<label><input type="radio" value="3" {-if:3==$_O['image']['watermark_position']-} checked="checked"{-:/if-} name="image[watermark_position]"> {-:@TOP_RIGHT-}</label>
								</td>
							</tr>
							<tr>
								<td>
						<label><input type="radio" value="4" {-if:4==$_O['image']['watermark_position']-} checked="checked"{-:/if-} name="image[watermark_position]"> {-:@MIDDLE_LEFT-}</label>
								</td>
								<td>
						<label><input type="radio" value="5" {-if:5==$_O['image']['watermark_position']-} checked="checked"{-:/if-} name="image[watermark_position]"> {-:@MIDDLE_CENTER-}</label>
								</td>
								<td>
						<label><input type="radio" value="6" {-if:6==$_O['image']['watermark_position']-} checked="checked"{-:/if-} name="image[watermark_position]"> {-:@MIDDLE_RIGHT-}</label>
								</td>
							</tr>
							<tr>
								<td>
						<label><input type="radio" value="7" {-if:7==$_O['image']['watermark_position']-} checked="checked"{-:/if-} name="image[watermark_position]"> {-:@BOTTOM_LEFT-}</label>
								</td>
								<td>
						<label><input type="radio" value="8" {-if:8==$_O['image']['watermark_position']-} checked="checked"{-:/if-} name="image[watermark_position]"> {-:@BOTTOM_CENTER-}</label>
								</td>
								<td>
						<label><input type="radio" value="9" {-if:9==$_O['image']['watermark_position']-} checked="checked"{-:/if-} name="image[watermark_position]"> {-:@BOTTOM_RIGHT-}</label>
								</td>
							</tr>
						</table>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@WATERMARK_POSITION_TIP-}
					</td>
				</tr>
			</table>
		</div><!--/.tabCntnt-->
		<div class="tabCntnt"><!--MEMBER-->
			<table class="formTable">
				<tr>
					<td class="inputTitle">{-:@MEMBER_SWITCH-} [member/switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="member[switch]"{-if:0==$_O['member']['switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="member[switch]"{-if:1==$_O['member']['switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@MEMBER_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@MEMBER_REGISTER-} [member/register]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="member[register]"{-if:0==$_O['member']['register']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="member[register]"{-if:1==$_O['member']['register']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@MEMBER_REGISTER_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@MEMBER_NAME_BAN-} [member/name_ban]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="i" name="member[name_ban]" style="width:360px;height:60px;">{-:$_O['member']['name_ban']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@MEMBER_NAME_BAN_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@MEMBER_USERID_MIN_LENGTH-} [member/userid_min_length]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['member']['userid_min_length']-}" name="member[userid_min_length]" maxlength="20" size="10">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@MEMBER_USERID_MIN_LENGTH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@MEMBER_PASSWORD_MIN_LENGTH-} [member/password_min_length]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['member']['password_min_length']-}" name="member[password_min_length]" maxlength="20" size="10">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@MEMBER_PASSWORD_MIN_LENGTH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@MEMBER_PASS_TYPE-} [member/pass_type]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="member[pass_type]"{-if:0==$_O['member']['pass_type']-} checked="checked"{-:/if-}> {-:@AUTO-}</label>
						<label><input type="radio" value="1" name="member[pass_type]"{-if:1==$_O['member']['pass_type']-} checked="checked"{-:/if-}> {-:@MANUAL-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@MEMBER_PASS_TYPE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@LOGIN_CREDIT-} [member/login_credit]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input class="required i" type="text" value="{-:$_O['member']['login_credit']['m_experience']-}" name="member[login_credit][m_experience]" maxlength="4" size="4"> {-:@EXPERIENCE-}</label>
						<label><input class="required i" type="text" value="{-:$_O['member']['login_credit']['m_points']-}" name="member[login_credit][m_points]" maxlength="4" size="4"> {-:@POINTS-}</label>
					</td>
					<td class="inputArea">
						<table class="listTable">
							<tr>
								{-foreach:$_MCTL,$ct-}
								<th scope="col">{-:$ct['mct_name']-}[{-:$ct['mct_unit']-}]</th>
								{-:/foreach-}
							</tr>
							<tr>
								{-foreach:$_MCTL,$ct-}
								<td>
									<label><input class="required i" type="text" value="{-if:$_O['member']['login_credit'][$ct['mct_alias']]-}{-:$_O['member']['login_credit'][$ct['mct_alias']]-}{-else:-}0{-:/if-}" name="member[login_credit][{-:$ct['mct_alias']-}]" maxlength="4" size="4"></label>
								</td>
								{-:/foreach-}
							</tr>
						</table><!--/credit table-->
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@PUBLISH_CREDIT-} [member/publish_credit]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input class="required i" type="text" value="{-:$_O['member']['publish_credit']['m_experience']-}" name="member[publish_credit][m_experience]" maxlength="4" size="4"> {-:@EXPERIENCE-}</label>
						<label><input class="required i" type="text" value="{-:$_O['member']['publish_credit']['m_points']-}" name="member[publish_credit][m_points]" maxlength="4" size="4"> {-:@POINTS-}</label>
					</td>
					<td class="inputArea">
						<table class="listTable">
							<tr>
								{-foreach:$_MCTL,$ct-}
								<th scope="col">{-:$ct['mct_name']-}[{-:$ct['mct_unit']-}]</th>
								{-:/foreach-}
							</tr>
							<tr>
								{-foreach:$_MCTL,$ct-}
								<td>
									<label><input class="required i" type="text" value="{-if:$_O['member']['publish_credit'][$ct['mct_alias']]-}{-:$_O['member']['publish_credit'][$ct['mct_alias']]-}{-else:-}0{-:/if-}" name="member[publish_credit][{-:$ct['mct_alias']-}]" maxlength="4" size="4"></label>
								</td>
								{-:/foreach-}
							</tr>
						</table><!--/credit table-->
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@REVIEW_CREDIT-} [member/review_credit]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input class="required i" type="text" value="{-:$_O['member']['review_credit']['m_experience']-}" name="member[review_credit][m_experience]" maxlength="4" size="4"> {-:@EXPERIENCE-}</label>
						<label><input class="required i" type="text" value="{-:$_O['member']['review_credit']['m_points']-}" name="member[review_credit][m_points]" maxlength="4" size="4"> {-:@POINTS-}</label>
					</td>
					<td class="inputArea">
						<table class="listTable">
							<tr>
								{-foreach:$_MCTL,$ct-}
								<th scope="col">{-:$ct['mct_name']-}[{-:$ct['mct_unit']-}]</th>
								{-:/foreach-}
							</tr>
							<tr>
								{-foreach:$_MCTL,$ct-}
								<td>
									<label><input class="required i" type="text" value="{-if:$_O['member']['review_credit'][$ct['mct_alias']]-}{-:$_O['member']['review_credit'][$ct['mct_alias']]-}{-else:-}0{-:/if-}" name="member[review_credit][{-:$ct['mct_alias']-}]" maxlength="4" size="4"></label>
								</td>
								{-:/foreach-}
							</tr>
						</table><!--/credit table-->
					</td>
				</tr>
			</table>
		</div><!--/.tabCntnt-->
		<div class="tabCntnt"><!--INTERACTION-->
			<table class="formTable">
				<tr>
					<td class="inputTitle">{-:@REVIEW-}{-:@SWITCH-} [interaction/review_switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="interaction[review_switch]"{-if:0==$_O['interaction']['review_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="interaction[review_switch]"{-if:1==$_O['interaction']['review_switch']-} checked="checked"{-:/if-}> {-:@MEMBER-}{-:@ON-}</label>
						<label><input type="radio" value="2" name="interaction[review_switch]"{-if:2==$_O['interaction']['review_switch']-} checked="checked"{-:/if-}> {-:@ALL-}{-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@REVIEW_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SEARCH-}{-:@SWITCH-} [interaction/search_switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="interaction[search_switch]"{-if:0==$_O['interaction']['search_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="interaction[search_switch]"{-if:1==$_O['interaction']['search_switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@SEARCH_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@FEEDBACK_CHECK-} [interaction/feedback_check]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="interaction[feedback_check]"{-if:0==$_O['interaction']['feedback_check']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="interaction[feedback_check]"{-if:1==$_O['interaction']['feedback_check']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@FEEDBACK_CHECK_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@FEEDBACK_INTERVAL-} [interaction/feedback_interval]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['interaction']['feedback_interval']-}" name="interaction[feedback_interval]" maxlength="10" size="4">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@FEEDBACK_INTERVAL_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SEARCH_INTERVAL-} [interaction/search_interval]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['interaction']['search_interval']-}" name="interaction[search_interval]" maxlength="10" size="4">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@SEARCH_INTERVAL_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@CAPTCHA-} [interaction/captcha]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="interaction[captcha]"{-if:0==$_O['interaction']['captcha']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="interaction[captcha]"{-if:1==$_O['interaction']['captcha']-} checked="checked"{-:/if-}> {-:@ON-}</label>
						<img src="{-url:common/captcha_img?name=test-}" />
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@CAPTCHA_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@MANAGE_CAPTCHA-} [interaction/manage_captcha]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="interaction[manage_captcha]"{-if:0==$_O['interaction']['manage_captcha']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="interaction[manage_captcha]"{-if:1==$_O['interaction']['manage_captcha']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@MANAGE_CAPTCHA_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@REPORT_SWITCH-} [interaction/report_switch]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="interaction[report_switch]"{-if:0==$_O['interaction']['report_switch']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="interaction[report_switch]"{-if:1==$_O['interaction']['report_switch']-} checked="checked"{-:/if-}> {-:@ON-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@REPORT_SWITCH_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@AUTO_REPORT-} [interaction/auto_report]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<label><input type="radio" value="0" name="interaction[auto_report]"{-if:0==$_O['interaction']['auto_report']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
						<label><input type="radio" value="1" name="interaction[auto_report]"{-if:1==$_O['interaction']['auto_report']-} checked="checked"{-:/if-}> {-:@VERIFY-}</label>
						<label><input type="radio" value="2" name="interaction[auto_report]"{-if:2==$_O['interaction']['auto_report']-} checked="checked"{-:/if-}> {-:@FILTER-}</label>
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@AUTO_REPORT_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@FILTER_WORDS-} [interaction/filter_words]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="i" name="interaction[filter_words]" style="width:360px;height:120px;">{-:$_O['interaction']['filter_words']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@FILTER_WORDS_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@FILTER_REPLACE-} [interaction/filter_replace]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input class="required i" type="text" value="{-:$_O['interaction']['filter_replace']-}" name="interaction[filter_replace]" maxlength="10" size="4">
					</td>
					<td class="inputTip">
						<span class="fc_r">*</span> {-:@FILTER_REPLACE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@ALLOW_TAGS-} [interaction/allow_tags]</td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="i" name="interaction[allow_tags]" style="width:360px;height:120px;">{-:$_O['interaction']['allow_tags']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@ALLOW_TAGS_TIP-}
					</td>
				</tr>
			</table>
		</div><!--/.tabCntnt-->
	</dd>
</dl><!--/.atab-->
<div id="operation">
	<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
	<input name="token" type="hidden" value="{-:$_TK['token']-}">
	<span class="btn_b submit" action="{-url:option/edit_option_do-}" to="#formEdit">{-:@SUBMIT-}</span>
</div>
</form>
<script src="{-:*__PUBLIC__-}js/jquery.js"></script>
<script src="{-:*__PUBLIC__-}js/uploadify/uploadify.js"></script>
<script src="{-:*__PUBLIC__-}js/editor/ckeditor.js"></script>
<script src="{-:*__PUBLIC__-}js/editor/adapters/jquery.js"></script>
<script>
$(document).ready(function(){
	var editor_option = {
		filebrowserBrowseUrl : '{-url:finder/browse?typeset=all&type=site-}',
		filebrowserImageBrowseUrl : '{-url:finder/browse?typeset=image&type=site-}',
		filebrowserUploadUrl : '{-url:upload/upload_file?typeset=all&upload_type=site&return_type=editor&timeKey={$_TK["timeKey"]}&token={$_TK["token"]}-}',
		filebrowserImageUploadUrl : '{-url:upload/upload_file?typeset=image&upload_type=site&return_type=editor&timeKey={$_TK["timeKey"]}&token={$_TK["token"]}-}',
		width : 690, height : 90,
	};
	$('.editor').ckeditor(editor_option);
	var editor_option_simple = {
		filebrowserBrowseUrl : '{-url:finder/browse?typeset=all&type=site-}',
		filebrowserImageBrowseUrl : '{-url:finder/browse?typeset=image&type=site-}',
		filebrowserUploadUrl : '{-url:upload/upload_file?typeset=all&upload_type=site&return_type=editor&timeKey={$_TK["timeKey"]}&token={$_TK["token"]}-}',
		filebrowserImageUploadUrl : '{-url:upload/upload_file?typeset=image&upload_type=site&return_type=editor&timeKey={$_TK["timeKey"]}&token={$_TK["token"]}-}',
		toolbar : 'uwa_simple',
		width : 640, height : 90,
	};
	$('.editor_simple').ckeditor(editor_option_simple);
});

var type_desc_all = '{-:@FILE-}', file_type_exts_all = '{-:$_OU['all']-}',
	type_desc_image = '{-:@IMAGE-}', file_type_exts_image = '{-:$_OU['img']-}',
	form_data = {'{-php:echo session_name();-}' : '{-php:echo session_id();-}', 'timeKey' : '{-:$_TK["timeKey"]-}', 'token' : '{-:$_TK["token"]-}'},
	uploadify_swf = '{-:*__PUBLIC__-}js/uploadify/uploadify.swf',
	uploader_all = '{-url:upload/upload_file?typeset=all&upload_type=site-}',
	uploader_image = '{-url:upload/upload_file?typeset=image&upload_type=site-}',
	uploader_image_thumb = '{-url:upload/upload_file?typeset=image&upload_type=site&thumb=yes-}';

var finder_browse_url_all = '{-url:finder/browse?typeset=all&type=site-}',
	finder_browse_url_image = '{-url:finder/browse?typeset=image&type=site-}',
	finder_browse_url_file = '{-url:finder/browse?typeset=file&type=site-}';
</script>
<script src="{-:*__THEME__-}admin/js/c.js"></script>
<script src="{-:*__THEME__-}admin/js/u.js"></script>
<script src="{-:*__THEME__-}admin/js/f.js"></script>
</body>
</html>