<?php

/**
 *--------------------------------------
 * member
 *--------------------------------------
 * @project		: uwa
 * @author		: cblee
 * @created		: 2012-10-3
 * @copyright	: (c)2012 AsThis
 *--------------------------------------
 */

class MemberModl extends Modl {
	public function get_memberInfo($memberId, $output = false) {
		$_MI = $this->where(array('__MEMBER__.member_id' => array('EQ', $memberId)))->join('__MEMBER_MODEL__ AS mm ON mm.member_model_id = __MEMBER__.member_model_id')->join('__MEMBER_LEVEL__ AS ml ON ml.member_level_id = __MEMBER__.member_level_id')->join('__MEMBER_CREDIT__ AS mc ON mc.member_id = __MEMBER__.member_id')->find();
		if(empty($_MI)) {
			return null;
		}

		/* get model field */
		$at = get_instance('ATag', 'field');
		$at->tags = array();
		$at->parse_content($_MI['mm_fieldset']);
		$_MI['mm_field'] = $at->tags;

		/* get information in addon table */
		$addon = M(parse_name($_MI['mm_addon_table'], 1))->where(array('member_id' => array('EQ', $_MI['member_id'])))->find();
		load('field#func');
		foreach($_MI['mm_field'] as $field => $params) {
			$addon[$field] = deal_fieldValue($addon[$field], $params, $output);
		}

		$_MI = array_merge($_MI, $addon);

		return $_MI;
	}

	public function add_member($data, $addon = true, $credit = true) {
		$result = array('data' => '', 'error' => '');

		$data['member_id'] = $this->insert($data);
		if(false === $data['member_id']) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $data['member_id'];

		/* deal with data for addon table */
		if($addon) {
			$memberModelId = $data['member_model_id'];
			$_MMI = M('MemberModel')->get_modelInfo($memberModelId);
			/* deal addon field */
			load('field#func');
			foreach($_MMI['mm_field'] as $tag => $params) {
				$data[$tag] = get_fieldValue($tag, $params, $data);
			}
			/* addon table model */
			if(false === M(parse_name($_MMI['mm_addon_table'], 1))->insert($data)) {
				$result['error'] = L('ADD_ADDON_DATA_FAILED');
				return $result;
			}
		}

		/* deal with credit */
		if($credit) {
			if(false === M('MemberCredit')->insert($data)) {
				$result['error'] = L('ADD_CREDIT_DATA_FAILED');
				return $result;
			}
		}

		return $result;
	}

	public function edit_member($data, $addon = true, $credit = true) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->update($data)) {
			$result['error'] = L('UPDATE_FAILED');
			return $result;
		}

		/* deal with addon table */
		if($addon) {
			$memberModelId = $data['member_model_id'];
			$_MMI = M('MemberModel')->get_modelInfo($memberModelId);
			/* addon table field */
			if(!empty($_MMI['mm_field'])) {
				load('field#func');
				foreach($_MMI['mm_field'] as $tag => $params) {
					$data[$tag] = get_fieldValue($tag, $params, $data);
				}
				if(false === M(parse_name($_MMI['mm_addon_table'], 1))->update($data)) {
					$result['error'] = L('UPDATE_ADDON_DATA_FAILED');
					return $result;
				}
			}
		}

		/* credit */
		if($credit) {
			if(false === M('MemberCredit')->update($data)) {
				$result['error'] = L('UPDATE_CREDIT_DATA_FAILED');
				return $result;
			}
		}

		return $result;
	}

	public function delete_member($memberId) {

		$result = array('data' => '', 'error' => '');

		/* whether it is admin */
		$isAdmin = M('Admin')->is_admin($memberId);
		if($isAdmin) {
			$result['error'] = L('ADMIN_IS_LOCKED');
			return $result;
		}

		$_MI = $this->get_memberInfo($memberId);
		if(empty($_MI)) {
			$result['error'] = L('ITEM_NOT_EXIST');
			return $result;
		}

		if(false === $this->delete($memberId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		/* delete addon table information */
		if(false === M(parse_name($_MI['mm_addon_table'], 1))->delete($memberId)) {
			$result['error'] = L('DELETE_ADDON_DATA_FAILED');
			return $result;
		}

		/* delete credit information */
		if(false === M('MemberCredit')->delete($memberId)) {
			$result['error'] = L('DELETE_CREDIT_DATA_FAILED');
			return $result;
		}

		/* delete upload information */
		$_AUL = M('Upload')->where(array('u_item_type' => array('EQ', 'member'), 'u_item_id' => array('EQ', $memberId)))->select();
		if(!empty($_AUL)) {
			foreach($_AUL as $au) {
				if(__HOST__ == substr($au['u_src'], 0, strlen(__HOST__))) {
					@unlink(realpath($_SERVER['DOCUMENT_ROOT'] . substr($au['u_src'], strlen(__HOST__))));
				}
				else {
					@unlink(realpath($_SERVER['DOCUMENT_ROOT'] . $au['u_src']));
				}
			}
		}
		M('Upload')->where(array('u_item_type' => array('EQ', 'member'), 'u_item_id' => array('EQ', $memberId)))->delete();

		return $result;
	}

	public function check_userid($userid) {
		$userid = strtolower(trim($userid));
		$_o_m = M('Option')->get_option('member');
		if(in_array($userid, explode(',', $_o_m['name_ban']))) {
			return false;
		}
		$result = M('Member')->field('m_userid')->where(array('m_userid' => array('EQ', $userid)))->find();
		if(!empty($result)) {
			return false;
		}
		return true;
	}

	public function check_email($email) {
		$email = strtolower(trim($email));
		$result = M('Member')->field('m_email')->where(array('m_email' => array('EQ', $email)))->find();
		if(!empty($result)) {
			return false;
		}
		return true;
	}

	public function get_mlRank($memberId) {
		$mlId = $this->where(array('member_id' => array('EQ', $memberId)))->get_field('member_level_id');
		return M('MemberLevel')->where(array('member_level_id' => array('EQ', $mlId)))->get_field('ml_rank');
	}

	public function update_credit($memberId, $operation = 'publish', $add = true) {
		$data = array();
		$data['member_id'] = $memberId;
		$_mi = $this->where(array('member_id' => array('EQ', $memberId)))->field('m_experience,m_points')->find();
		$_o_moc = M('Option')->get_option('member/' . $operation . '_credit');
		if($add) {
			$data['m_experience'] = $_mi['m_experience'] + $_o_moc['m_experience'];
			$data['m_points'] = $_mi['m_points'] + $_o_moc['m_points'];
		}
		else {
			$data['m_experience'] = (0 < $_mi['m_experience'] - $_o_moc['m_experience']) ? ($_mi['m_experience'] - $_o_moc['m_experience']) : 0;
			$data['m_points'] = (0 < $_mi['m_points'] - $_o_moc['m_points']) ? ($_mi['m_points'] - $_o_moc['m_points']) : 0;
		}
		$this->update($data);

		$data = array();
		$_mc = M('MemberCredit')->where(array('member_id' => array('EQ', $memberId)))->find();
		foreach($_o_moc as $k => $v) {
			if('m_experience' == $k or 'm_points' == $k or 0 == $v) {
				continue;
			}
			if($add) {
				$data[$k] = $_mc[$k] + $v;
			}
			else {
				$data[$k] = (0 < $_mc[$k] - $v) ? ($_mc[$k] - $v) : 0;
			}
		}
		if(!empty($data)) {
			$data['member_id'] = $memberId;
			M('MemberCredit')->update($data);
		}
	}

	public function pass_member($memberId) {
		$result = array('data' => '', 'error' => '');

		$_MI = $this->where(array('member_id' => array('EQ', $memberId)))->find();
		if(empty($_MI)) {
			$result['error'] = L('ITEM_NOT_EXIST');
			return $result;
		}

		if(false === $this->where(array('member_id' => array('EQ', $memberId)))->set_field('m_status', 1)) {
			$result['error'] = L('PASS_FAILED');
			return $result;
		}

		return $result;
	}

	public function forbidden_member($memberId) {
		$result = array('data' => '', 'error' => '');

		$_MI = $this->where(array('member_id' => array('EQ', $memberId)))->find();
		if(empty($_MI)) {
			$result['error'] = L('ITEM_NOT_EXIST');
			return $result;
		}

		if(false === $this->where(array('member_id' => array('EQ', $memberId)))->set_field('m_status', 2)) {
			$result['error'] = L('FORBIDDEN_FAILED');
			return $result;
		}

		return $result;
	}

}

?>