<?php

/**
 *--------------------------------------
 * admin permission
 *--------------------------------------
 * @project		: uwa
 * @author		: cblee
 * @created		: 2012-10-9
 * @copyright	: (c)2012 AsThis
 *--------------------------------------
 */

class AdminPermissionModl extends Modl {
	/* $gorupSort: whether is group sort */
	public function get_permissionList($groupSort = false) {
		$_APL = $this->order('`admin_permission_id` ASC')->select();
		if(!empty($_APL) && $groupSort) {
			$_t = array();
			foreach($_APL as $ap) {
				$_t[$ap['ap_group']][] = $ap;
			}
			$_APL = $_t;
		}
		return $_APL;
	}

	/* get all permission */
	public function get_allPermission() {
		$allPermission = '';
		$_t = $this->select();
		if(!empty($_t)) {
			foreach($_t as $ap) {
				$allPermission .= $ap['ap_content'] . ',';
			}
		}
		$allPermission = rtrim($allPermission, ',');
		return $allPermission;
	}

	/* get limit permission */
	public function get_limitPermission() {
		/* localhost or licenced uwa is not limit */
		$_licence =  get_licence();
		if('127.0.0.1' == AServer::get_ip() or !empty($_licence)) {
			return '_none';
		}

		$_t_lp = unserialize(ACrypt::decrypt('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', SOFT_NAME));
		if('yes' == $_t_lp['v']) {
			return $_t_lp['p'];
		}
		else {
			return M('AdminPermission')->get_allPermission();
		}
	}

	public function get_permissionInfo($adminPermissionId) {
		$_API = $this->where(array('admin_permission_id' => array('EQ', $adminPermissionId)))->find();
		return $_API;
	}

	public function add_permission($data) {
		$result = array('data' => '', 'error' => '');

		$data['permission'] = array_unique($data['permission']);
		sort($data['permission']);
		$data['ap_content'] = implode(',', $data['permission']);

		unset($data['permission']);
		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $_t_id;

		return $result;
	}

	public function edit_permission($data) {
		$result = array('data' => '', 'error' => '');

		$data['permission'] = array_unique($data['permission']);
		sort($data['permission']);
		$data['ap_content'] = implode(',', $data['permission']);
		unset($data['permission']);
		if(false === $this->update($data)) {
			$result['error'] = L('EDIT_FAILED');
			return $result;
		}

		return $result;
	}

	public function delete_permission($adminPermissionId) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->delete($adminPermissionId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		return $result;
	}
}

?>