<?php

/**
 *--------------------------------------
 * member archive
 *--------------------------------------
 * @project		: uwa
 * @author		: cblee
 * @created		: 2014-05-20
 * @copyright	: (c)2014 AsThis
 *--------------------------------------
 */

class ArchiveCtrlr extends MemberCtrlr {
	public function list_archive() {
		$where = array();
		$where['__ARCHIVE__.member_id'] = array('EQ', ASession::get('member_id'));

		/* get archive model information */
		$archiveModelId = intval(ARequest::get('archive_model_id'));
		$_AMI = M('ArchiveModel')->get_modelInfo($archiveModelId);
		if(empty($_AMI) or !$_AMI['am_status']) {
			$this->error(L('MODEL_IS_NOT_ACTIVE'), Url::U('member/index'));
		}
		$this->assign('_AMI', $_AMI);

		/* filter channel */
		$_ACL = M('ArchiveChannel')->get_memberChannelList($archiveModelId, ASession::get('member_level_id'));
		$act = new ATree($_ACL, array(
			'archive_channel_id',
			'ac_parent_id',
			'ac_sub_channel'));
		$_aclId = implode(',', $act->get_leafid());
		$where['__ARCHIVE__.archive_channel_id'] = array('IN', $_aclId);

		/* filter status */
		$aStatus = in_array(ARequest::get('a_status'), array(
			'n',
			'p',
			'r')) ? ARequest::get('a_status') : '';
		if('n' == $aStatus) {
			$where['__ARCHIVE__.a_status'] = array('EQ', 0);
		}
		elseif('p' == $aStatus) {
			$where['__ARCHIVE__.a_status'] = array('EQ', 1);
		}
		elseif('r' == $aStatus) {
			$where['__ARCHIVE__.a_status'] = array('EQ', 2);
		}

		$order = "`a_edit_time` DESC";

		/* get paging */
		$rowsNum = M('Archive')->where($where)->count();
		$p = new APage($rowsNum, 10, Url::U('archive/list_archive?archive_model_id=' . $archiveModelId . '&a_status=' . $aStatus . '&' . C('VAR.PAGE') . '=_page_'));
		$this->assign('PAGE_LIST', $p->show());
		$limit = $p->get_limit();

		/* archive list */
		$_AL = M('Archive')->get_archiveList($where, $order, $limit, $archiveModelId);
		$this->assign('_AL', $_AL);

		$this->display('member/' . $_AMI['am_tpl_list_member']);
	}

	public function choose_archive() {
		$where = array();
		$where['__ARCHIVE__.member_id'] = array('EQ', ASession::get('member_id'));

		/* filter channel */
		$_ACL = M('ArchiveChannel')->get_memberChannelList(0, ASession::get('member_level_id'));
		$act = new ATree($_ACL, array(
			'archive_channel_id',
			'ac_parent_id',
			'ac_sub_channel'));
		$_aclId = implode(',', $act->get_leafid());
		$where['__ARCHIVE__.archive_channel_id'] = array('IN', $_aclId);

		/* filter status */
		$where['__ARCHIVE__.a_status'] = array('EQ', 1);

		$order = "`a_edit_time` DESC";

		/* get paging */
		$rowsNum = M('Archive')->where($where)->count();
		$p = new APage($rowsNum, 10, Url::U('archive/choose_archive?a_status=' . $aStatus . '&' . C('VAR.PAGE') . '=_page_'));
		$this->assign('PAGE_LIST', $p->show());
		$limit = $p->get_limit();

		/* archive list */
		$_AL = M('Archive')->get_archiveList($where, $order, $limit, $archiveModelId);
		$this->assign('_AL', $_AL);

		$this->display();
	}

	public function add_archive() {
		/* get model information */
		$archiveModelId = intval(ARequest::get('archive_model_id'));
		$_AMI = M('ArchiveModel')->get_modelInfo($archiveModelId);
		if(empty($_AMI) or !$_AMI['am_status']) {
			$this->error(L('MODEL_IS_NOT_ACTIVE'), Url::U('member/index'));
		}
		$this->assign('_AI', $_AMI);

		/* get channel list */
		$_ACL = M('ArchiveChannel')->get_memberChannelList($archiveModelId, ASession::get('member_level_id'));
		if(empty($_ACL)) {
			$this->error(L('NO_CHANNEL_AVAILABLE'), Url::U('member/index'));
		}
		$act = new ATree($_ACL, array(
			'archive_channel_id',
			'ac_parent_id',
			'ac_sub_channel'));
		$_ACLStr = $act->get_leafStr(0, "<option value='\$archive_channel_id'>\$spacer \$ac_name</option>\r\n");
		$this->assign('_ACLStr', $_ACLStr);

		$_FI = '';
		load('field#func');
		foreach($_AMI['am_field'] as $tag => $params) {
			if(1 == $params['f_is_auto']) {
				$_FI .= get_formItem($tag, $params, null, true);
			}
		}
		$this->assign('_FI', $_FI);

		$this->display('member/' . $_AMI['am_tpl_add_member']);
	}
	public function add_archive_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		check_interaction();

		$data = array();
		$data['archive_channel_id'] = intval(ARequest::get('archive_channel_id'));
		/* check permission */
		$_aclId = explode(',', M('ArchiveChannel')->get_memberChannelList(0, ASession::get('member_level_id'), true));
		if(!in_array($data['archive_channel_id'], $_aclId)) {
			$this->error(L('PERMISSION_LIMIT'), Url::U('member/index'));
		}

		/* upload thumb */
		if('' != $_FILES['a_thumb_uploader']['name']) {
			$watermark = false;
			$returnType = 'normal';
			$_t_ai = M('ArchiveChannel')->get_channelInfo($data['archive_channel_id']);
			$uploadType = $_t_ai['am_alias'];

			$result = M('Upload')->upload_file('a_thumb_uploader', 'archive', 'image', 'yes', false);
			if(empty($result['error'])) {
				$data['a_thumb'] = $result['data'];
			}
		}

		$data['a_title'] = AFilter::text(AFilter::plain_text(ARequest::get('a_title'), 85));
		$data['a_keywords'] = AFilter::text(AFilter::plain_text(ARequest::get('a_keywords'), 85));
		$data['a_description'] = AFilter::text(ARequest::get('a_description'), 200);
		$data['a_cost_points'] = intval(ARequest::get('a_cost_points'));
		$data['member_id'] = ASession::get('member_id');
		$data['m_username'] = AFilter::is_username(ARequest::get('m_username')) ? ACookie::get('m_username') : '';
		$data['a_add_time'] = time();
		$data['a_edit_time'] = $data['a_add_time'];
		$data['a_add_ip'] = AServer::get_ip();
		$data['a_edit_ip'] = $data['a_add_ip'];
		$data['a_rank'] = 50;

		$_pass_switch = M('ArchiveChannel')->field('ac_pass_switch')->find($data['archive_channel_id']);
		if(0 == $_pass_switch['ac_pass_switch']) {
			$data['a_status'] = 1;
		}
		else {
			$data['a_status'] = 0;
		}

		$_o = M('Option')->get_option(array('core', 'interaction'));
		$_aci = M('ArchiveChannel')->where(array('archive_channel_id' => array('EQ', $data['archive_channel_id'])))->find();
		if($_o['interaction']['review_switch'] and $_aci['ac_review_switch']) {
			$data['a_review_switch'] = 1;
		}
		else {
			$data['a_review_switch'] = 0;
		}
		if($_o['core']['html_switch'] and 0 != $_aci['ac_is_html']) {
			$data['a_is_html'] = 1;
		}
		else {
			$data['a_is_html'] = 0;
		}

		/* insert to main table */
		$result = M('Archive')->add_archive($data);
		if(!empty($result['error'])) {
			$this->error(L('PUBLISH_FAILED'), Url::U('archive/list_archive?archive_model_id=' . $data['archive_model_id']));
		}

		/* insert to addon table */
		$data['archive_id'] = $result['data'];
		$data = array_merge(ARequest::get(), $data);

		/* delete external links */
		if(isset($data['delete_external_links']) and !empty($data['delete_external_links'])) {
			foreach($data['delete_external_links'] as $field) {
				if(MAGIC_QUOTES_GPC) {
					$data[$field] = stripslashes($data[$field]);
				}
				$data[$field] = str_replace(__HOST__, '#basehost#', $data[$field]);
				$data[$field] = preg_replace("/(<a[ \t\r\n]{1,}href=[\"']{0,}http:\/\/[^\/]([^>]*)>)|(<\/a>)/isU", '', $data[$field]);
				$data[$field] = str_replace('#basehost#', __HOST__, $data[$field]);
				if(MAGIC_QUOTES_GPC) {
					$data[$field] = addslashes($data[$field]);
				}
			}
		}

		$result = M('Archive')->add_archive_addon($data);
		if(!empty($result['error'])) {
			$this->error(L('PUBLISH_FAILED'), Url::U('archive/list_archive?archive_model_id=' . $data['archive_model_id']));
		}

		/* update upload */
		M('Upload')->update_upload($data['archive_id']);

		/* update member credit */
		if($data['a_status']) {
			M('Member')->update_credit(ASession::get('member_id'), 'publish');
		}

		/* update TAG */
		if(!empty($data['a_keywords'])) {
			$keywords = explode(',', $data['a_keywords']);
			foreach($keywords as $keyword) {
				$keyword = trim($keyword);
				if(!empty($keyword)) {
					M('Tag')->add_tag_archive($keyword, $data['archive_id']);
				}
			}
		}

		$this->success(L('PUBLISH_SUCCESS'), Url::U('archive/list_archive?archive_model_id=' . $data['archive_model_id']));
	}

	public function edit_archive() {
		$_AI = M('Archive')->get_archiveInfo(intval(ARequest::get('archive_id')));
		if(empty($_AI) or ASession::get('member_id') != $_AI['member_id']) {
			$this->error(L('ITEM_NOT_EXIST'), Url::U('member/index'));
		}
		$this->assign('_AI', $_AI);

		/* get channel list */
		$_ACL = M('ArchiveChannel')->get_memberChannelList($_AI['archive_model_id'], ASession::get('member_level_id'));
		if(empty($_ACL)) {
			$this->error(L('NO_CHANNEL_AVAILABLE'), Url::U('member/index'));
		}
		$act = new ATree($_ACL, array(
			'archive_channel_id',
			'ac_parent_id',
			'ac_sub_channel'));
		$_ACLStr = $act->get_leafStr(0, "<option value='\$archive_channel_id'>\$spacer \$ac_name</option>\r\n", $_AI['archive_channel_id'], "<option value='\$archive_channel_id' selected='selected'>\$spacer \$ac_name</option>\r\n");
		$this->assign('_ACLStr', $_ACLStr);

		$_FI = '';
		load('field#func');
		foreach($_AI['am_field'] as $tag => $params) {
			if(1 == $params['f_is_auto']) {
				$_FI .= get_formItem($tag, $params, $_AI, true);
			}
		}
		$this->assign('_FI', $_FI);

		$this->display('member/' . $_AI['am_tpl_edit_member']);
	}
	public function edit_archive_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		check_interaction();

		$data = array();
		/* check permission */
		$data['archive_id'] = intval(ARequest::get('archive_id'));
		$_AI = M('Archive')->where(array('archive_id' => array('EQ', $data['archive_id']), 'member_id' => array('EQ', ASession::get('member_id'))))->field('archive_channel_id,a_status,a_thumb')->find();
		if(empty($_AI)) {
			$this->error(L('ITEM_NOT_EXIST'), Url::U('member/index'));
		}
		$data['archive_channel_id'] = intval(ARequest::get('archive_channel_id'));

		$_ACL = M('ArchiveChannel')->get_memberChannelList(0, ASession::get('member_level_id'));
		$act = new ATree($_ACL, array(
			'archive_channel_id',
			'ac_parent_id',
			'ac_sub_channel'));
		$_aclId = $act->get_leafid();
		if(!in_array($data['archive_channel_id'], $_aclId)) {
			$this->error(L('PERMISSION_LIMIT'), Url::U('archive/list_archive?archive_model_id=' . $data['archive_model_id']));
		}

		/* upload thumb */
		if('' != $_FILES['a_thumb_uploader']['name']) {
			$watermark = false;
			$returnType = 'normal';
			$_t_ai = M('ArchiveChannel')->get_channelInfo($data['archive_channel_id']);
			$uploadType = $_t_ai['am_alias'];

			$result = M('Upload')->upload_file('a_thumb_uploader', 'archive', 'image', 'yes', false);
			if(empty($result['error'])) {
				$data['a_thumb'] = $result['data'];
			}

			/* delete old thumb */
			if(!empty($_AI['a_thumb'])) {
				M('Upload')->where(array('u_src' => array('EQ', $_AI['a_thumb'])))->delete();
				if(__HOST__ == substr($_AI['a_thumb'], 0, strlen(__HOST__))) {
					@unlink(realpath($_SERVER['DOCUMENT_ROOT'] . substr($_AI['a_thumb'], strlen(__HOST__))));
				}
				else {
					@unlink(realpath($_SERVER['DOCUMENT_ROOT'] . $_AI['a_thumb']));
				}
			}
		}

		$data['a_title'] = AFilter::text(AFilter::plain_text(ARequest::get('a_title'), 85));
		$data['a_keywords'] = AFilter::text(AFilter::plain_text(ARequest::get('a_keywords'), 85));
		$data['a_description'] = AFilter::text(ARequest::get('a_description'), 200);
		$data['a_cost_points'] = intval(ARequest::get('a_cost_points'));
		$data['member_id'] = ASession::get('member_id');
		$data['m_username'] = AFilter::is_username(ARequest::get('m_username')) ? ACookie::get('m_username') : '';
		$data['a_edit_time'] = time();
		$data['a_edit_ip'] = AServer::get_ip();

		$_pass_switch = M('ArchiveChannel')->field('ac_pass_switch')->find($data['archive_channel_id']);
		if(0 == $_pass_switch['ac_pass_switch']) {
			$data['a_status'] = 1;
		}
		else {
			$data['a_status'] = 0;
		}

		/* edit main table data */
		$result = M('Archive')->edit_archive($data);
		if(!empty($result['error'])) {
			$this->error(L('EDIT_FAILED'), Url::U('archive/list_archive?archive_model_id=' . $data['archive_model_id']));
		}

		/* edit addon table data */
		$data = array_merge(ARequest::get(), $data);

		/* delete external links */
		if(isset($data['delete_external_links']) and !empty($data['delete_external_links'])) {
			foreach($data['delete_external_links'] as $field) {
				if(MAGIC_QUOTES_GPC) {
					$data[$field] = stripslashes($data[$field]);
				}
				$data[$field] = str_replace(__HOST__, '#basehost#', $data[$field]);
				$data[$field] = preg_replace("/(<a[ \t\r\n]{1,}href=[\"']{0,}http:\/\/[^\/]([^>]*)>)|(<\/a>)/isU", '', $data[$field]);
				$data[$field] = str_replace('#basehost#', __HOST__, $data[$field]);
				if(MAGIC_QUOTES_GPC) {
					$data[$field] = addslashes($data[$field]);
				}
			}
		}

		$result = M('Archive')->edit_archive_addon($data);
		if(!empty($result['error'])) {
			$this->error(L('EDIT_FAILED'), Url::U('archive/list_archive?archive_model_id=' . $data['archive_model_id']));
		}

		/* update upload */
		M('Upload')->update_upload($data['archive_id']);

		/* update TAG */
		if(!empty($data['a_keywords'])) {
			$keywords = explode(',', $data['a_keywords']);
			foreach($keywords as $keyword) {
				$keyword = trim($keyword);
				if(!empty($keyword)) {
					M('Tag')->add_tag_archive($keyword, $data['archive_id']);
				}
			}
		}

		$this->success(L('EDIT_SUCCESS'), Url::U('archive/list_archive?archive_model_id=' . $data['archive_model_id']));
	}

}

?>