<?php

/**
 *--------------------------------------
 * COOKIE
 *--------------------------------------
 * @project		: pfa
 * @author		: cblee
 * @created		: 2012-9-23
 * @copyright	: (c)2012 AsThis
 *--------------------------------------
 */

class ACookie {
	public static function set($name, $value = '', $key = null, $prefix = null, $expire = null, $path = null, $domain = null) {
		if(is_null($key)) {
			$key = C('COOKIE.KEY');
		}

		if(is_null($prefix)) {
			$prefix = C('COOKIE.PREFIX');
		}

		if(is_null($expire)) {
			$expire = time() + C('COOKIE.EXPIRE');
		}
		else {
			$expire = time() + $expire;
		}

		if(is_null($path)) {
			$path = C('COOKIE.PATH');
		}

		if(is_null($domain)) {
			$domain = C('COOKIE.DOMAIN');
		}

		if(C('COOKIE.CILENT_CHECK')) {
			setcookie($prefix . 'client_id', ACrypt::encrypt(AServer::get_clientId(), $key), $expire, $path, $domain);
		}

		$value = ACrypt::encrypt(serialize($value), $key);
		setCookie($prefix . $name, $value, $expire, $path, $domain);
	}

	public static function get($name = null, $key = null, $prefix = null) {
		if(is_null($key)) {
			$key = C('COOKIE.KEY');
		}

		if(is_null($prefix)) {
			$prefix = C('COOKIE.PREFIX');
		}

		$is_checked = 1;
		if(C('COOKIE.CILENT_CHECK')) {
			$is_checked = self::check_clientId();
		}

		if(1 == $is_checked) {
			if(is_null($name)) {
				$_c = array();
				foreach($_COOKIE as $k => $v) {
					$_t_name = substr($k, strlen($prefix));
					if((substr($k, 0, strlen($prefix)) == $prefix) and 'client_id' != $_t_name) {
						$_c[$_t_name] = unserialize(ACrypt::decrypt($v, $key));
					}
				}
				return $_c;
			}
			return isset($_COOKIE[$prefix . $name]) ? unserialize(ACrypt::decrypt($_COOKIE[$prefix . $name], $key)) : '';
		}
		elseif(0 == $is_checked) {
			self::del($prefix . 'client_id');
		}
		return '';
	}

	public static function del($name, $key = null, $prefix = null) {
		self::set($name, '', $key, $prefix, -1000);
	}

	/* clear all cookie */
	public static function clear($prefix = null) {
		if(is_null($prefix)) {
			$prefix = C('COOKIE.PREFIX');
		}
		$preLen = strlen($prefix);
		foreach($_COOKIE as $name => $val) {
			if(strpos($name, $prefix) === 0) {
				self::del(substr($name, $preLen), '', $prefix);
			}
		}
	}

	/* check client ID */
	private static function check_clientId() {
		$prefix = C('COOKIE.PREFIX');
		$key = C('COOKIE.KEY');
		if(isset($_COOKIE[$prefix . 'client_id'])) {
			if(AServer::get_clientId() == ACrypt::decrypt($_COOKIE[$prefix . 'client_id'], $key)) {
				return 1;
			}
			return 0;
		}
		return - 1;
	}

	/* constructors privatization */
	private function __construct() {
	}
}

?>