<?php

/**
 *--------------------------------------
 * single page
 *--------------------------------------
 * @project		: uwa
 * @author		: cblee
 * @created		: 2012-10-19
 * @copyright	: (c)2012 AsThis
 *--------------------------------------
 */

class SinglePageModl extends Modl {
	public function get_singlePageList($where = '', $order = '', $limit = 10) {
		$_SPL = $this->where($where)->order($order)->limit($limit)->select();
		if(!empty($_SPL)) {
			foreach($_SPL as $k => $v) {
				/* update url */
				if(empty($v['sp_url'])) {
					$_r = $this->build_url($v['single_page_id']);
					$_SPL[$k]['sp_url'] = $_r['data'];
				}
			}
		}
		return $_SPL;
	}

	public function get_singlePageInfo($singlePageId) {
		$_SPI = $this->where(array('single_page_id' => array('EQ', $singlePageId)))->find();
		if(!empty($_SPI)) {
			/* update url */
			if(empty($_SPI['sp_url'])) {
				$_r = $this->build_url($_SPI['single_page_id']);
				$_SPI['sp_url'] = $_r['data'];
			}
		}
		return $_SPI;
	}

	public function add_single_page($data) {
		$result = array('data' => '', 'error' => '');

		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $_t_id;

		/* update upload */
		M('Upload')->update_upload($_t_id);

		return $result;
	}

	public function edit_single_page($data) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->update($data)) {
			$result['error'] = L('EDIT_FAILED');
			return $result;
		}

		/* update upload */
		M('Upload')->update_upload($data['single_page_id']);

		return $result;
	}

	public function delete_single_page($singlePageId) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->delete($singlePageId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		/* delete upload */
		$_AUL = M('Upload')->where(array('u_item_type' => array('EQ', 'single_page'), 'u_item_id' => array('EQ', $singlePageId)))->select();
		if(!empty($_AUL)) {
			foreach($_AUL as $au) {
				if(__HOST__ == substr($au['u_src'], 0, strlen(__HOST__))) {
					@unlink(realpath($_SERVER['DOCUMENT_ROOT'] . substr($au['u_src'], strlen(__HOST__))));
				}
				else {
					@unlink(realpath($_SERVER['DOCUMENT_ROOT'] . $au['u_src']));
				}
			}
		}
		M('Upload')->where(array('u_item_type' => array('EQ', 'single_page'), 'u_item_id' => array('EQ', $singlePageId)))->delete();

		return $result;
	}

	public function build_url($singlePageId) {
		$result = array('data' => '', 'error' => '');

		$_SPI = $this->where(array('single_page_id' => array('EQ', $singlePageId)))->find();
		if(empty($_SPI)) {
			$result['error'] = L('ITEM_NOT_EXIST');
			return $result;
		}

		if($_SPI['sp_is_html']) {
			vendor('Pinyin#class');
			$pyc = get_instance('Pinyin');
			$naming = str_replace(array('{uwa_path}', '{sp_py}'), array('', $pyc->get_pinyin($_SPI['sp_title'], 'utf-8')), $_SPI['sp_html_naming']);
			$url = __APP__ . trim($naming, '/') . C('HTML.FILE_SUFFIX');
		}
		else {
			$url = Url::U('home@single_page/show_single_page?single_page_id=' . $singlePageId);
		}
		$this->where(array('single_page_id' => array('EQ', $singlePageId)))->set_field('sp_url', $url);
		$result['data'] = $url;
		return $result;
	}

}

?>