<?php

/**
 *--------------------------------------
 * option
 *--------------------------------------
 * @project		: uwa
 * @author		: cblee
 * @created		: 2012-10-15
 * @copyright	: (c)2012 AsThis
 *--------------------------------------
 */

class OptionCtrlr extends ManageCtrlr {
	public function edit_option() {
		$_LANGSET = get_langset();
		$this->assign('_LANGSET', $_LANGSET);

		$_TPL = M('Template')->get_templateList();
		$this->assign('_TPL', $_TPL);

		$_O = M('Option')->get_option(array(
			'site',
			'core',
			'performance',
			'member',
			'upload',
			'image',
			'interaction'));
		$this->assign('_O', $_O);

		/* member credit type */
		$_MCTL = M('MemberCreditType')->get_creditTypeList();
		$this->assign('_MCTL', $_MCTL);

		$this->display();
	}
	public function edit_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$cfgFile = CFG_PATH . D_S . 'comm.php';

		$_C = include ($cfgFile);
		/* language */
		$_C['LANG']['NAME'] = $data['site']['language'];
		$_C['LANG']['DETECT'] = $data['site']['lang_detect'] ? true : false;
		/* template */
		$_C['TE']['TPL_THEME'] = $data['site']['theme'];
		$_C['TE']['TPL_PROTECTION'] = $data['site']['tpl_protection'] ? true : false;
		$_C['TE']['GZIP'] = $data['core']['gzip_switch'] ? true : false;
		/* cache */
		$_C['CACHE']['TYPE'] = $data['performance']['cache_type'];
		$_C['CACHE']['EXPIRE'] = intval($data['core']['cache_expire']);
		$_C['CACHE']['MEMCACHE_HOST'] = $data['performance']['memcache_host'];
		$_C['CACHE']['MEMCACHE_PORT'] = intval($data['performance']['memcache_port']);
		/* HTML */
		$_C['HTML']['DIR'] = $data['core']['html_path'];
		/* cookie, session */
		$_C['COOKIE']['PREFIX'] = $data['core']['cookie_prefix'];
		$_C['COOKIE']['EXPIRE'] = intval($data['core']['cookie_expire']);
		$_C['COOKIE']['KEY'] = $data['core']['cookie_key'];
		$_C['SESSION']['PREFIX'] = $data['core']['cookie_prefix'];
		/* debug switch */
		$_C['DEBUG']['SWITCH'] = $data['core']['debug_switch'] ? true : false;
		$_C['DEBUG']['STAT'] = $data['core']['debug_stat'] ? true : false;
		$_C['DEBUG']['PAGE_TRACE'] = $data['core']['debug_page_trace'] ? true : false;
		/* url host prefix */
		$_C['URL']['HOST_PREFIX'] = $data['core']['host_prefix_switch'] ? true : false;
		/* rewrite */
		if(1 == $data['core']['rewrite_switch']) {
			$_C['URL']['TYPE'] = 3;
		}
		else {
			$_C['URL']['TYPE'] = 1;
		}

		$content = var_export($_C, true);
		$content = "<?php\r\nreturn {$content};\r\n?>";
		if(!@file_put_contents($cfgFile, $content)) {
			M('AdminLog')->add_log(ASession::get('m_userid'), L('EDIT') . L('OPTION') . ': ' . L('SAVE_CFG_FILE_FAILED'), 0);
			$this->error(L('SAVE_CFG_FILE_FAILED'), Url::U('option/edit_option'));
		}

		if(file_exists(RUNTIME_PATH . D_S . '~runtime.php')) {
			@unlink(realpath(RUNTIME_PATH . D_S . '~runtime.php'));
		}

		if(!M('Option')->save_option($data)) {
			M('AdminLog')->add_log(ASession::get('m_userid'), L('EDIT') . L('OPTION'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_option'));
		}
		M('AdminLog')->add_log(ASession::get('m_userid'), L('EDIT') . L('OPTION'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_option'));
	}

	public function edit_custom_option() {
		/* custom option */
		$_CO = M('Option')->where(array('o_type' => array('EQ', 1)))->select();
		$this->assign('_CO', $_CO);

		$this->display();
	}
	public function edit_custom_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		if(!M('Option')->save_option($data)) {
			M('AdminLog')->add_log(ASession::get('m_userid'), L('EDIT') . L('CUSTOM_OPTION'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_custom_option'));
		}
		M('AdminLog')->add_log(ASession::get('m_userid'), L('EDIT') . L('CUSTOM_OPTION'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_custom_option'));
	}

	public function add_custom_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$_t_co = M('Option')->where(array('o_key' => array('EQ', $data['o_key'])))->find();
		if(!empty($_t_co)) {
			M('AdminLog')->add_log(ASession::get('m_userid'), L('ADD') . L('CUSTOM_OPTION') . ': OPTION_TITLE[' . $data['o_title'] . ']' . L('EXIST'), 0);
			$this->error(L('ADD_FAILED') . ': ' . L('CUSTOM_OPTION') . L('EXIST'), Url::U('option/edit_custom_option'));
		}

		if('bool' == $data['o_value_type']) {
			$data['o_value'] = strtoupper($data['o_value']);
			if('Y' != $data['o_value'] && 'N' != $data['o_value']) {
				M('AdminLog')->add_log(ASession::get('m_userid'), L('ADD') . L('CUSTOM_OPTION') . ': OPTION_TITLE[' . $data['o_title'] . ']', 0);
				$this->error(L('ADD_FAILED') . ': ' . L('PARAMS_ERROR'), Url::U('option/edit_custom_option'));
			}
		}

		$data['o_type'] = 1;
		$result = M('Option')->insert($data);

		if(false === $result) {
			M('AdminLog')->add_log(ASession::get('m_userid'), L('ADD') . L('CUSTOM_OPTION') . ': ' . $result['error'], 0);
			$this->error(L('ADD_FAILED'), Url::U('option/edit_custom_option'));
		}

		F('~_O', null);
		M('AdminLog')->add_log(ASession::get('m_userid'), L('ADD') . L('CUSTOM_OPTION') . ': OPTION_TITLE[' . $data['o_title'] . ']');
		$this->success(L('ADD_SUCCESS'), Url::U('option/edit_custom_option'));
	}

	public function delete_custom_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$oKey = ARequest::get('o_key');
		$_t_o = M('Option')->where(array('o_type' => array('EQ', 1), 'o_key' => array('EQ', $oKey)))->find();
		if(empty($_t_o)) {
			M('AdminLog')->add_log(ASession::get('m_userid'), L('DELETE') . L('CUSTOM_OPTION') . ': KEY[' . $oKey . ']' . L('ITEM_NOT_EXIST'), 0);
			$this->error(L('ITEM_NOT_EXIST'), Url::U('option/edit_custom_option'));
		}

		$result = M('Option')->where(array('o_type' => array('EQ', 1), 'o_key' => array('EQ', $oKey)))->delete();

		if(false === $result) {
			M('AdminLog')->add_log(ASession::get('m_userid'), L('DELETE') . L('CUSTOM_OPTION') . ': KEY[' . $oKey . ']', 0);
			$this->error(L('DELETE_FAILED'), Url::U('option/edit_custom_option'));
		}

		F('~_O', null);
		M('AdminLog')->add_log(ASession::get('m_userid'), L('DELETE') . L('CUSTOM_OPTION') . ': KEY[' . $oKey . ']');
		$this->success(L('DELETE_SUCCESS'), Url::U('option/edit_custom_option'));
	}

}

?>