/*
 * artDialog iframeTools
 * Date: 2011-07-12 10:49
 * http://code.google.com/p/artdialog/
 * (c) 2009-2010 TangBin, http://www.planeArt.cn
 *
 * This is licensed under the GNU LGPL, version 2.1 or later.
 * For details, see: http://creativecommons.org/licenses/LGPL/2.1/
 */
;(function ($, window, artDialog, undefined) {

var _parentDialog, _proxyDialog, _zIndex,
	_data = '_ARTDIALOG.DATA',
	_open = '_ARTDIALOG.OPEN',
	_origin = '_ARTDIALOG.ORIGIN',
	_winName = window.name = window.name || '_ARTDIALOG.WINNAME' + (new Date).getTime();


/** ȡ artDialog ɿ缶õ߲ window  */
var _parent = artDialog.parent = function () {
	var parent = window,
	test = function (name) {
		try {
			var doc = window[name].document;	// |Ȩ
			doc.getElementsByTagName; 			// chrome ذȫ
		} catch (e) {
			return false;
		};
		// ܼ޷ʾԪ
		return doc.getElementsByTagName('frameset').length === 0;
	};
	
	if (test('top')) {
		parent = window.top;
	} else if (test('parent')) {
		parent = window.parent;
	};
	
	return parent;
}();


_parentDialog = _parent.artDialog;


// ȡҳԻֵ
_zIndex = function () {
	return _parentDialog.defaults.zIndex;
};



/**
 * ݹӿ
 * @param	{String}	洢
 * @param	{Any}		Ҫ洢(޴򷵻رѯ)
 */
artDialog.data = function (name, value) {
	var parent = artDialog.parent,
		cache = parent[_data] || {};
	parent[_data] = cache;
	
	if (value) {
		cache[name] = value;
	} else {
		return cache[name];
	};
	return cache;
};


/**
 * ݹɾӿ
 * @param	{String}	ɾ
 */
artDialog.removeData = function (name) {
	var cache = artDialog.parent[_data];
	if (cache && cache[name]) delete cache[name];
};


/** ͨԻ */
artDialog.through = _proxyDialog = function () {
	var api = _parentDialog.apply(this, arguments);
		
	// ӵǰwindowΪiframeпܶԻwindowжغȫرЩԻ
	// ΪiframeעҲڴɾ䴴Ķ󣬿Էֹص
	if (_parent !== window) artDialog.list[api.config.id] = api;
	return api;
};

// ҳжǰرдԽĶԻ
_parent !== window && $(window).bind('unload', function () {
	var list = artDialog.list;
	for (var i in list) {
		if (list[i]) {
			list[i].close();
			delete list[i];
		};
	};
});


/**
 *  (iframe)
 * @param	{String}	ַ
 * @param	{Object}	ò. ﴫĻصյĵ1Ϊiframeڲwindow
 * @param	{Boolean}	Ƿ. Ĭtrue
 */
artDialog.open = function (url, options, cache) {
	options = options || {};
	
	var api, titleWrap, loadInit, oldLocation,
		iframe, $iframe, $idoc, iwin, ibody,
		parent = artDialog.parent,
		iframeCss = 'width:100%;height:100%;border:none 0',
		title = options.title,
		$content, $main;
		
	if (cache === false) {
		var ts = (new Date()).getTime(),
			ret = url.replace(/([?&])_=[^&]*/, "$1_=" + ts );
		url = ret + ((ret === url) ? (/\?/.test(url) ? "&" : "?") + "_=" + ts : "");
	};
		
	var load = function () {
		var iWidth, iHeight, newLocation,
			loading = iframe.previousSibling,
			aConfig = api.config;
		titleWrap.style.display = 'block';
		$content.addClass('aui_contentFull');
		
		if (!loadInit && loading) loading.parentNode.removeChild(loading);
		
		iwin = iframe.contentWindow;
		try {
			ibody = iwin.document.body;// 
		} catch (e) {
			$iframe.unbind('load', load);
			loadInit = true;
			iframe.style.cssText = iframeCss;
			api.position(aConfig.left, aConfig.top);
			return;
		};
		
		$(iwin).bind('unload', unload);
		newLocation = iwin.location.href;
		if (newLocation === oldLocation) return;
		oldLocation = newLocation;
		$idoc = $(iwin.document);
		
		iWidth = aConfig.width === 'auto' ?
			$idoc.width() + parseInt($(ibody).css('marginLeft')) : aConfig.width;
		iHeight = aConfig.height === 'auto' ?
			$idoc.height() : aConfig.height;
			
		if (!loadInit) {
			setTimeout(function () {
				iframe.style.cssText = iframeCss;
			}, 0);// setTimeout: ֹIE6~7¶ԻʽȾ쳣
		};
		
		api.size(iWidth, iHeight);
		aConfig.follow ?
			api.follow(aConfig.follow) :
			api.position(aConfig.left, aConfig.top);
		
		!loadInit && options.initFn && options.initFn.call(api, iwin, parent);
		loadInit = true;
	};
	
	var unload = function () {
		loadInit = false;
	};
		
	var config = {
		zIndex: _zIndex(),
		tmpl: null,
		initFn: function () {
			api = this;
			var DOM = api.DOM;
			$main = DOM.main;
			$content = DOM.content;
			titleWrap = DOM.titleWrap[0];
			!title && (titleWrap.style.display = 'none');
			
			iframe = api.iframe = parent.document.createElement('iframe');
			iframe.src = url;
			iframe.name = 'Open' + api.config.id;
			iframe.style.cssText = 'position:absolute;left:-9999em;top:-9999em;border:none 0;background:transparent';
			iframe.setAttribute('frameborder', 0, 0);
			iframe.setAttribute('allowTransparency', true);
			$iframe = $(iframe);
			api.content().appendChild(iframe);
			
			iwin = iframe.contentWindow;
			
			try {
				iwin.name = iframe.name;
				artDialog.data(iframe.name + _open, api);
				artDialog.data(iframe.name + _origin, window);
				$(iwin).bind('unload', unload);
			} catch (e) {};
			
			$iframe.bind('load', load);
			
			// iframeڴopenǰiframeжض¶ڴƳ
			// ֿԱûرն
			api.lock();
		},
		closeFn: function () {
			$iframe.css('display', 'none').unbind('load', load);
			
			options.closeFn && options.closeFn.call(this, iframe.contentWindow, parent);
			$content.removeClass('aui_contentFull');
			
			// ҪҪiframeַ´γֵĶԻIE67޷۽input
			// IEɾiframeiframeȻڴг⣬ûsrc׽ķ
			$iframe[0].src = 'about:blank';
			$iframe.remove();
			
			try {
				artDialog.removeData(iframe.name + _open);
				artDialog.removeData(iframe.name + _origin);
				$(iwin).unbind('unload', unload);
			} catch (e) {};
		}
	};
	
	// صһָiframeڲwindow
	if (typeof options.yesFn === 'function') config.yesFn = function () {
		return options.yesFn.call(api, iframe.contentWindow, parent);
	};
	if (typeof options.noFn === 'function') config.noFn = function () {
		return options.noFn.call(api, iframe.contentWindow, parent);
	};
	
	delete options.content;

	for (var i in options) {
		if (config[i] === undefined) config[i] = options[i];
	};
	
	return _proxyDialog(config);
};


/** ȡopenƽӿ(open򿪵iframeڲ˽з) */
artDialog.open.api = artDialog.data(_winName + _open);


/** ȡopenԴҳwindow(open򿪵iframeڲ˽з) */
artDialog.open.origin = artDialog.data(_winName + _origin) || window;


/** artDialog.open 򿪵iframeҳرնԻݷ */
artDialog.close = function () {
	var api = artDialog.data(_winName + _open);
	api && api.close();
	return false;
};


/**
 * Ajax
 * @param	{String}			ַ
 * @param	{Object, String}	ò. ַʾʹģJSON
 * @param	{Boolean}			Ƿ. Ĭtrue
 */
artDialog.load = function(url, options, cache){
	cache = cache || false;
	var opt = options || {},
		tmpl = typeof opt === 'string' ? opt : null;
		
	var config = {
		zIndex: _zIndex(),
		initFn: function(here){
			var api = this,
				aConfig = api.config;
			
			$.ajax({
				url: url,
				success: function (content) {
					if (tmpl) content = 'JSON' in window && JSON.parse ?
						JSON.parse(content) : eval('(' + content + ')');
						
					api.content(content, tmpl);
					aConfig.follow ?
						api.follow(aConfig.follow) :
						api.position(aConfig.left, aConfig.top);
	
					opt.initFn && opt.initFn.call(api, here);				
				},
				cache: cache
			});
			
		}
	};
		
	if (opt.tmpl) {
		tmpl = opt.tmpl;
		opt.tmpl = null;
	};
	
	delete options.content;
	
	for (var i in opt) {
		if (config[i] === undefined) config[i] = opt[i];
	};
	
	return _proxyDialog(config);
};


/**
 * 
 * @param	{String}	Ϣ
 */
artDialog.alert = function (content) {
	return _proxyDialog({
		id: 'Alert',
		zIndex: _zIndex(),
		icon: 'warning',
		fixed: true,
		lock: true,
		content: content,
		yesFn: true
	});
};


/**
 * ȷ
 * @param	{String}	Ϣ
 * @param	{Function}	ȷťص
 * @param	{Function}	ȡťص
 */
artDialog.confirm = function (content, yes, no) {
	return _proxyDialog({
		id: 'Confirm',
		zIndex: _zIndex(),
		icon: 'question',
		fixed: true,
		lock: true,
		opacity: .1,
		content: content,
		yesFn: function (here) {
			return yes.call(this, here);
		},
		noFn: function (here) {
			return no && no.call(this, here);
		}
	});
};


/**
 * 
 * @param	{String}	
 * @param	{Function}	ص. ղֵ
 * @param	{String}	Ĭֵ
 */
artDialog.prompt = function (content, yes, value) {
	value = value || '';
	var input;
	
	return _proxyDialog({
		id: 'Prompt',
		zIndex: _zIndex(),
		icon: 'question',
		fixed: true,
		lock: true,
		opacity: .1,
		content: [
			'<div style="marginBottom:5px;font-size:12px">',
				content,
			'</div>',
			'<div>',
				'<input value="',
					value,
				'" style="width:18em;padding:6px 4px" />',
			'</div>'
			].join(''),
		initFn: function () {
			input = this.DOM.content.find('input')[0];
			input.select();
			input.focus();
		},
		yesFn: function (here) {
			return yes && yes.call(this, input.value, here);
		},
		noFn: true
	});
};


/**
 * ʾ
 * @param	{String}	ʾ
 * @param	{Number}	ʾʱ (Ĭ1.5)
 */
artDialog.tips = function (content, time) {
	return _proxyDialog({
		id: 'Tips',
		zIndex: _zIndex(),
		title: false,
		fixed: true
	})
	.content('<div style="padding: 0 1em;">' + content + '</div>')
	.position('50%', 'goldenRatio')
	.time(time || 1.5);
};
artDialog.notice = function (options) {
    var opt = options || {},
        api, aConfig, hide, wrap, top,
        duration = 800;
        
    var config = {
        id: 'Notice',
        left: '100%',
        top: '100%',
        fixed: true,
        drag: false,
        resize: false,
        follow: null,
        lock: false,
        init: function(here){
            api = this;
            aConfig = api.config;
            wrap = api.DOM.wrap;
            top = parseInt(wrap[0].style.top);
            hide = top + wrap[0].offsetHeight;
            
            wrap.css('top', hide + 'px')
                .animate({top: top + 'px'}, duration, function () {
                    opt.init && opt.init.call(api, here);
                });
        },
        close: function(here){
            wrap.animate({top: hide + 'px'}, duration, function () {
                opt.close && opt.close.call(this, here);
                aConfig.close = $.noop;
                api.close();
            });
            
            return false;
        }
    };	
    
    for (var i in opt) {
        if (config[i] === undefined) config[i] = opt[i];
    };
    
    return artDialog(config);
};

// ǿartDialogק
// - ֹiframe²
// - ԳԻ϶Ż
$(function () {
	var event = artDialog.dragEvent;
	if (!event) return;

	var $window = $(window),
		$document = $(document),
		positionType = !-[1,] && !('minWidth' in document.documentElement.style)
		? 'absolute' : 'fixed',
		dragEvent = event.prototype,
		mask = document.createElement('div'),
		style = mask.style;
		
	style.cssText = 'display:none;position:' + positionType + ';left:0;top:0;width:100%;height:100%;'
	+ 'cursor:move;filter:alpha(opacity=0);opacity:0;background:#FFF';
		
	document.body.appendChild(mask);
	dragEvent._start = dragEvent.start;
	dragEvent._stop = dragEvent.stop;
	
	dragEvent.start = function () {
		var DOM = artDialog.focus.DOM,
			main = DOM.main[0],
			iframe = DOM.content[0].getElementsByTagName('iframe')[0];
		
		dragEvent._start.apply(this, arguments);
		style.display = 'block';
		style.zIndex = artDialog.defaults.zIndex + 3;
		
		if (positionType === 'absolute') {
			style.width = $window.width() + 'px';
			style.height = $window.height() + 'px';
			style.left = $document.scrollLeft() + 'px';
			style.top = $document.scrollTop() + 'px';
		};
		
		if (iframe && main.offsetWidth * main.offsetHeight > 160000) {
			main.style.visibility = 'hidden';
		};
	};
	
	dragEvent.stop = function () {
		var dialog = artDialog.focus;
		dragEvent._stop.apply(this, arguments);
		style.display = 'none';
		if (dialog) dialog.DOM.main[0].style.visibility = 'visible';
	};
});

})(window.jQuery || window.art, this, this.artDialog);



