CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{9C414D29-7041-46CF-9A7D-C6373614B233}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{89846452-DA87-4D2C-944F-170E6616C305}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{489136FD-C6E1-4631-8583-485B6ACB57DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{CFFC1672-93B3-44BB-AC64-4309F13A4C74}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{3BE6260A-9819-45EF-B4A9-B7DA6EEEC6A3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{C69D5AA8-917B-4467-81C1-7DE4C86A7596}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{1E7B22B2-7653-4F2B-A913-E40D99AE1EAB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{97E0C54E-EB42-4F4B-9213-892DDDFF90D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{D247D3CA-41F7-46FC-A5B1-E502474E867F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{2EE7B51F-FAAB-4A2D-98C8-D153BE6FDB90}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{9B88787E-A245-498C-BE74-03A5AD5F1B4B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{FD20C912-497A-45A8-8FD7-BFF849BFBAA4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{8BDF71A3-A455-4484-8A72-58E9B652778F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{DC3BACD3-D2A1-4639-90D7-0E1D673D584E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{8A0997A2-25D3-4366-BF25-E1023750BF82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{53404690-459B-4DC0-AAC1-7C89E7FCF24F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{890E857A-8F7D-4131-9FF1-9CA21192007C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{65E0F6C2-2D75-4A76-BE59-352FED538A1B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{C80B98CF-F295-4D75-864D-FED8479EF32D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{B4306D6D-2DFE-46F6-BE05-11F67B36A6AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{93A0F249-C8F8-4F81-A051-0937F6174081}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{2AEE283B-979B-4230-853C-8CBADE1B8C5E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{1DE926CC-5B16-4BC9-B260-7BC24F0F2B15}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{89F85C08-8AF1-4EDE-8049-A7562A69F6DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{71BE6974-3F9E-41F1-9073-57AB62C6A897}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{749EB018-E680-481D-A798-6DCC4712B809}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{460FA82E-AC8A-4246-82E1-7B90E7283275}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{7D224BAC-2351-4673-BBBD-4524B8F3FD3D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{92D4DAE6-7FCE-4647-85AD-B40BBBDB2F9D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{1F02C8B8-E1E9-4348-A7E6-D42D19234550}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{C98B7CD2-5D46-4130-9950-4E4A2C92F662}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{EC682A9F-9A5E-4EBD-A19A-9E9C7F0206E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{F216F49F-5377-4E53-B85D-6E3AD8CDE42C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{E747E8AC-9273-4347-ADC0-30DAAC073AE9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{A81F8C6F-7446-4108-9CA5-C3D4E6773D5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{14771CFB-50D4-4BA8-A7E8-F138F2C227F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{B41B1166-C82F-4DDD-8EB6-03175296A204}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{F408183C-7F88-4A35-82D7-80945F834B12}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{BF3254DF-032D-446C-8F70-EEA85B4812EE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{DF19AC32-4BB3-48FA-95C0-265DC5FB1A98}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{3FECBFED-E5CC-453B-99B6-7A99C10D6E8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{69E21969-90E5-41B1-9FB6-A428AA82CD25}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{B35F0A7E-73C6-48D8-97C9-9406BA84BF59}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{72F6D500-5169-4D4B-8E71-27FFCE8D5EFE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{FA148573-E0E5-400F-8978-D95410035F18}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{DF19AC32-4BB3-48FA-95C0-265DC5FB1A99}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{E6299DEC-FE6B-4BAE-89C6-97F287E33A93}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{0744D46C-B2FB-4718-9387-7B571D3133D3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{721F201C-73C7-4F95-8079-A9D0EEE9FED2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{66730C5A-82DB-474B-A685-0484C6A59B7F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{0279E1B9-0871-41BA-910B-1A8962A72687}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{FC30A6FE-8968-4FEA-9461-27C1BD51075D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{5D7BB2B4-3778-4286-A820-CB80AFB3256A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{E34FB6A3-9908-4AE5-807A-B947343C7367}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{8A420EDB-862E-4C82-BA13-9D9370D7CF57}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{03527BAB-4B06-4F5D-A4B3-457D005F72C4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{EECE1C32-F1AC-4A85-8D36-DE1ED77FEA00}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{2E1BF0FB-821A-4CF1-9A43-333A064C3413}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{26FAE072-6D20-49A4-96B3-1C66FA0569AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{0DE4E246-69F3-4D36-A02F-4A2C0BD873F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{C93F448E-F065-41CD-8FEB-4459EA52D351}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{E7D960A6-B4B0-4BFC-BA0C-4905467BE4D9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{36815267-1C28-4768-8A07-F28744B5A4D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{9C292231-2CE4-4893-971F-FFDA45AE875A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{1518F589-A9CD-4CC3-99D8-99801F5BCFF5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{93072A3E-CF91-4E25-9316-EBA7808CD5DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{E41AA91D-E1E2-4498-B7E9-D669395022EF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{904ED171-CF4B-4637-92E9-7BAE496197BD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{F4E4E47B-1E29-4197-A2AD-CF33E06956DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{73F9DBD8-20BD-49CC-82B9-8A6175579DC1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{D789E20D-6185-4C02-95F3-A649B744FACE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{E827AE2B-A83C-49D4-B672-A24D1A6FD89E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{5DE9C0BB-2DC4-4CC7-9544-C3102AAA27F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{77CD28EF-DFDE-4142-BFA4-9D7E4377A3C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{CDCDAC16-D2C4-43AB-B209-4240C6C96514}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{ACE171FB-CBBD-4168-8C53-8B5C84C1DDAD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{649E466B-8929-4AE7-A855-73B7B85A9E1A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{27C19B89-402D-439D-8D5B-995E1E7A854D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{DAEFC71B-8B2E-465E-8FE2-E01254D9B2D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{9618C71D-31E7-4864-A7C1-0ABA3F236E22}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{DA499B6C-D17D-48F9-A5A6-6F76A3BD20F7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{34095D68-70DC-4672-B3F0-969DFA815004}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{C9B1347F-26E6-4B84-A840-531FCD1B8F7E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{DFC907AD-D1C3-4669-9569-483F7075DE02}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{D344E569-ABBA-4E34-AFEF-23C01F1B3A4B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{6EE62A33-9F89-4473-9A08-127BD835B063}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{95BA7BED-609C-4780-A6D5-269750484069}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{F8DCD5F7-98E6-4B03-BA00-DB7811B679CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{15DDF6DC-B41B-493F-9C5E-F23FAC81C1AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{F3A5352C-724A-4E7E-977A-FEBD225D4C0B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{33BD0B7F-CF0D-45DD-8B34-DA37D2A919AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{03245650-3A0C-44A8-86B8-A074E9F939A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{C9D00500-9E38-4943-993D-CB8C72DF7485}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{51CC95B3-494E-4B61-B44B-3F14C3A19D63}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{2AEEBC84-FA86-4F01-BD3D-8701639000B7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{FF7B84CC-D263-4FBC-8D25-8E47B7165D30}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{AADBFB12-EED5-4119-B228-5C2B9C5C8E9C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{7D3BF844-0003-428B-9BD6-11B693DFD980}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{3907D683-0B9A-4122-9924-CF396A33ABF2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{2133A596-0E02-43D5-9ADE-3B181A18963D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{E3D11C0D-E72D-4339-BC49-D86D7066C089}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{CACFCF56-F06E-4EB6-93C5-D2B769953BE2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{9F9A50DA-3238-4C0B-AFFE-8D04D044F4DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{9464BB02-4315-4304-9144-6D577A016CAE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{280F70E8-C6EB-4601-9F8E-7BF85F1F8986}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{83A6706F-609A-45DE-88FC-56BB6970477A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{2DD4DE71-993F-46DE-B349-E9B601BD8FA7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{BA2DE4D5-B69A-4BAF-82B2-4B9B48C21D3E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{D217283F-A38F-43B9-B3AC-FA9D80E18162}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{170F972D-D1FA-4B45-BDDB-E20E205C9766}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{12421F1B-5660-48A2-B159-FAE72EEA7A2F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{7E706189-6318-4BCA-9B59-016628754338}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{AD8B8B45-6DC7-42D6-BB03-1ED9D5094FDF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{FB109740-53CE-4B3E-9CC9-213EA40EC49C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{A6735685-8625-4E5D-9CE4-D97A4EF75206}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{32F530CC-143E-46E6-BD21-03919692801B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{C48510D7-1897-4F06-8DD7-B393068C5C20}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{AB46913E-C8BA-450F-A75D-C40A2C410E06}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{54D528A7-EB2D-4D97-A9F4-601D5984481F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{13FB7CF1-9B0A-49C1-8D43-C4A39F6F09A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{2F7EB898-233D-425C-9EE7-CAC1563E68FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{BE19301B-7560-403A-98AD-B9DFF750845F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "patch", "Shared Technology", "Photoshop Camera Raw 7", "")
INSERT INTO PayloadData VALUES("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{69564C6A-9BA4-4875-A72C-9CB424C75AD8}"><File><InstallPath>[INSTALLDIR]\Plug-Ins\CS6\File Formats\Camera Raw.8bi</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File></ValidationInfo>')
INSERT INTO PayloadData VALUES("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "0" , "ValidationSig", "CoOOUE9OoZ2xlOo3diiil2AuDhfsTmOUGy0OyyRDufNJB3Yhlzq1hN0uryMi/Oc5MVA0xk5Aoiew8Ww27yTbmZofSNRAAoOdCplpGZqyH8ahrGqPmrkrKL9f4cCFW1uSSXD81A9VjPJYl4K20tH0xzhnIfwnDTXmo1B0B1w/B/auhaFAjqr/0LKPbY2q7NXjOhkzJgG2sJhdnhBmgb1+apRnFOnydeUE+Vx6bG2Hs3F1YmELtmGS2Q4dInzH++f/pRxdqbYpnNBSrZCDro/E3nSN2vmdFwVymYrHDRORk1DUfa4fkFTrN8ZGkIA70w+hoEau78MM7QIYht0U1LrusNbIL6ofIhYjMzacZrMvSdF7uSp96gJzbFwkpdGlT0kJzuhVYcM/oV8jP7TFRWPGC5WHBXkH6v6JGAP5YmnsIvxcn9t9o820eT6vKXOpIy0pwHSPiT/61zuOz/MJKM5vbyDdzlm2o4Ol6QMjJXYUXqgZpGfy6gqLAg626fiPUved")
INSERT INTO Payloads VALUES	("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "Shared Technology", "Photoshop Camera Raw 7_7.3_AdobeCameraRaw7.0All", "7.3", "patch")
INSERT INTO PayloadData VALUES("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.98.0"><BuildInfo>
    <Property name="Created">2012-11-01 15:03:54.245000</Property>
    <Property name="TargetName">AdobeCameraRaw7.0All-011112150354</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{69564C6A-9BA4-4875-A72C-9CB424C75AD8}</Property>
    <Property name="ProductName">Photoshop Camera Raw 7</Property>
    <Property name="ProductVersion">7.3</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeCommon]</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
      <Family>Shared Technology</Family>
      <ProductName>Photoshop Camera Raw 7_7.3_AdobeCameraRaw7.0All</ProductName>
      <ProductVersion>7.3</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{9C414D29-7041-46CF-9A7D-C6373614B233}</AdobeCode>
    <AdobeCode>{89846452-DA87-4D2C-944F-170E6616C305}</AdobeCode>
    <AdobeCode>{489136FD-C6E1-4631-8583-485B6ACB57DD}</AdobeCode>
    <AdobeCode>{CFFC1672-93B3-44BB-AC64-4309F13A4C74}</AdobeCode>
    <AdobeCode>{3BE6260A-9819-45EF-B4A9-B7DA6EEEC6A3}</AdobeCode>
    <AdobeCode>{C69D5AA8-917B-4467-81C1-7DE4C86A7596}</AdobeCode>
    <AdobeCode>{1E7B22B2-7653-4F2B-A913-E40D99AE1EAB}</AdobeCode>
    <AdobeCode>{97E0C54E-EB42-4F4B-9213-892DDDFF90D8}</AdobeCode>
    <AdobeCode>{D247D3CA-41F7-46FC-A5B1-E502474E867F}</AdobeCode>
    <AdobeCode>{2EE7B51F-FAAB-4A2D-98C8-D153BE6FDB90}</AdobeCode>
    <AdobeCode>{9B88787E-A245-498C-BE74-03A5AD5F1B4B}</AdobeCode>
    <AdobeCode>{FD20C912-497A-45A8-8FD7-BFF849BFBAA4}</AdobeCode>
    <AdobeCode>{8BDF71A3-A455-4484-8A72-58E9B652778F}</AdobeCode>
    <AdobeCode>{DC3BACD3-D2A1-4639-90D7-0E1D673D584E}</AdobeCode>
    <AdobeCode>{8A0997A2-25D3-4366-BF25-E1023750BF82}</AdobeCode>
    <AdobeCode>{53404690-459B-4DC0-AAC1-7C89E7FCF24F}</AdobeCode>
    <AdobeCode>{890E857A-8F7D-4131-9FF1-9CA21192007C}</AdobeCode>
    <AdobeCode>{65E0F6C2-2D75-4A76-BE59-352FED538A1B}</AdobeCode>
    <AdobeCode>{C80B98CF-F295-4D75-864D-FED8479EF32D}</AdobeCode>
    <AdobeCode>{B4306D6D-2DFE-46F6-BE05-11F67B36A6AB}</AdobeCode>
    <AdobeCode>{93A0F249-C8F8-4F81-A051-0937F6174081}</AdobeCode>
    <AdobeCode>{2AEE283B-979B-4230-853C-8CBADE1B8C5E}</AdobeCode>
    <AdobeCode>{1DE926CC-5B16-4BC9-B260-7BC24F0F2B15}</AdobeCode>
    <AdobeCode>{89F85C08-8AF1-4EDE-8049-A7562A69F6DE}</AdobeCode>
    <AdobeCode>{71BE6974-3F9E-41F1-9073-57AB62C6A897}</AdobeCode>
    <AdobeCode>{749EB018-E680-481D-A798-6DCC4712B809}</AdobeCode>
    <AdobeCode>{460FA82E-AC8A-4246-82E1-7B90E7283275}</AdobeCode>
    <AdobeCode>{7D224BAC-2351-4673-BBBD-4524B8F3FD3D}</AdobeCode>
    <AdobeCode>{92D4DAE6-7FCE-4647-85AD-B40BBBDB2F9D}</AdobeCode>
    <AdobeCode>{1F02C8B8-E1E9-4348-A7E6-D42D19234550}</AdobeCode>
    <AdobeCode>{C98B7CD2-5D46-4130-9950-4E4A2C92F662}</AdobeCode>
    <AdobeCode>{EC682A9F-9A5E-4EBD-A19A-9E9C7F0206E6}</AdobeCode>
    <AdobeCode>{F216F49F-5377-4E53-B85D-6E3AD8CDE42C}</AdobeCode>
    <AdobeCode>{E747E8AC-9273-4347-ADC0-30DAAC073AE9}</AdobeCode>
    <AdobeCode>{A81F8C6F-7446-4108-9CA5-C3D4E6773D5F}</AdobeCode>
    <AdobeCode>{14771CFB-50D4-4BA8-A7E8-F138F2C227F8}</AdobeCode>
    <AdobeCode>{B41B1166-C82F-4DDD-8EB6-03175296A204}</AdobeCode>
    <AdobeCode>{F408183C-7F88-4A35-82D7-80945F834B12}</AdobeCode>
    <AdobeCode>{BF3254DF-032D-446C-8F70-EEA85B4812EE}</AdobeCode>
    <AdobeCode>{DF19AC32-4BB3-48FA-95C0-265DC5FB1A98}</AdobeCode>
    <AdobeCode>{3FECBFED-E5CC-453B-99B6-7A99C10D6E8F}</AdobeCode>
    <AdobeCode>{69E21969-90E5-41B1-9FB6-A428AA82CD25}</AdobeCode>
    <AdobeCode>{B35F0A7E-73C6-48D8-97C9-9406BA84BF59}</AdobeCode>
    <AdobeCode>{72F6D500-5169-4D4B-8E71-27FFCE8D5EFE}</AdobeCode>
    <AdobeCode>{FA148573-E0E5-400F-8978-D95410035F18}</AdobeCode>
    <AdobeCode>{DF19AC32-4BB3-48FA-95C0-265DC5FB1A99}</AdobeCode>
    <AdobeCode>{E6299DEC-FE6B-4BAE-89C6-97F287E33A93}</AdobeCode>
    <AdobeCode>{0744D46C-B2FB-4718-9387-7B571D3133D3}</AdobeCode>
    <AdobeCode>{721F201C-73C7-4F95-8079-A9D0EEE9FED2}</AdobeCode>
    <AdobeCode>{66730C5A-82DB-474B-A685-0484C6A59B7F}</AdobeCode>
    <AdobeCode>{0279E1B9-0871-41BA-910B-1A8962A72687}</AdobeCode>
    <AdobeCode>{FC30A6FE-8968-4FEA-9461-27C1BD51075D}</AdobeCode>
    <AdobeCode>{5D7BB2B4-3778-4286-A820-CB80AFB3256A}</AdobeCode>
    <AdobeCode>{E34FB6A3-9908-4AE5-807A-B947343C7367}</AdobeCode>
    <AdobeCode>{8A420EDB-862E-4C82-BA13-9D9370D7CF57}</AdobeCode>
    <AdobeCode>{03527BAB-4B06-4F5D-A4B3-457D005F72C4}</AdobeCode>
    <AdobeCode>{EECE1C32-F1AC-4A85-8D36-DE1ED77FEA00}</AdobeCode>
    <AdobeCode>{2E1BF0FB-821A-4CF1-9A43-333A064C3413}</AdobeCode>
    <AdobeCode>{26FAE072-6D20-49A4-96B3-1C66FA0569AD}</AdobeCode>
    <AdobeCode>{0DE4E246-69F3-4D36-A02F-4A2C0BD873F4}</AdobeCode>
    <AdobeCode>{C93F448E-F065-41CD-8FEB-4459EA52D351}</AdobeCode>
    <AdobeCode>{E7D960A6-B4B0-4BFC-BA0C-4905467BE4D9}</AdobeCode>
    <AdobeCode>{36815267-1C28-4768-8A07-F28744B5A4D5}</AdobeCode>
    <AdobeCode>{9C292231-2CE4-4893-971F-FFDA45AE875A}</AdobeCode>
    <AdobeCode>{1518F589-A9CD-4CC3-99D8-99801F5BCFF5}</AdobeCode>
    <AdobeCode>{93072A3E-CF91-4E25-9316-EBA7808CD5DC}</AdobeCode>
    <AdobeCode>{E41AA91D-E1E2-4498-B7E9-D669395022EF}</AdobeCode>
    <AdobeCode>{904ED171-CF4B-4637-92E9-7BAE496197BD}</AdobeCode>
    <AdobeCode>{F4E4E47B-1E29-4197-A2AD-CF33E06956DC}</AdobeCode>
    <AdobeCode>{73F9DBD8-20BD-49CC-82B9-8A6175579DC1}</AdobeCode>
    <AdobeCode>{D789E20D-6185-4C02-95F3-A649B744FACE}</AdobeCode>
    <AdobeCode>{E827AE2B-A83C-49D4-B672-A24D1A6FD89E}</AdobeCode>
    <AdobeCode>{5DE9C0BB-2DC4-4CC7-9544-C3102AAA27F9}</AdobeCode>
    <AdobeCode>{77CD28EF-DFDE-4142-BFA4-9D7E4377A3C0}</AdobeCode>
    <AdobeCode>{CDCDAC16-D2C4-43AB-B209-4240C6C96514}</AdobeCode>
    <AdobeCode>{ACE171FB-CBBD-4168-8C53-8B5C84C1DDAD}</AdobeCode>
    <AdobeCode>{649E466B-8929-4AE7-A855-73B7B85A9E1A}</AdobeCode>
    <AdobeCode>{27C19B89-402D-439D-8D5B-995E1E7A854D}</AdobeCode>
    <AdobeCode>{DAEFC71B-8B2E-465E-8FE2-E01254D9B2D2}</AdobeCode>
    <AdobeCode>{9618C71D-31E7-4864-A7C1-0ABA3F236E22}</AdobeCode>
    <AdobeCode>{DA499B6C-D17D-48F9-A5A6-6F76A3BD20F7}</AdobeCode>
    <AdobeCode>{34095D68-70DC-4672-B3F0-969DFA815004}</AdobeCode>
    <AdobeCode>{C9B1347F-26E6-4B84-A840-531FCD1B8F7E}</AdobeCode>
    <AdobeCode>{DFC907AD-D1C3-4669-9569-483F7075DE02}</AdobeCode>
    <AdobeCode>{D344E569-ABBA-4E34-AFEF-23C01F1B3A4B}</AdobeCode>
    <AdobeCode>{6EE62A33-9F89-4473-9A08-127BD835B063}</AdobeCode>
    <AdobeCode>{95BA7BED-609C-4780-A6D5-269750484069}</AdobeCode>
    <AdobeCode>{F8DCD5F7-98E6-4B03-BA00-DB7811B679CC}</AdobeCode>
    <AdobeCode>{15DDF6DC-B41B-493F-9C5E-F23FAC81C1AB}</AdobeCode>
    <AdobeCode>{F3A5352C-724A-4E7E-977A-FEBD225D4C0B}</AdobeCode>
    <AdobeCode>{33BD0B7F-CF0D-45DD-8B34-DA37D2A919AD}</AdobeCode>
    <AdobeCode>{03245650-3A0C-44A8-86B8-A074E9F939A9}</AdobeCode>
    <AdobeCode>{C9D00500-9E38-4943-993D-CB8C72DF7485}</AdobeCode>
    <AdobeCode>{51CC95B3-494E-4B61-B44B-3F14C3A19D63}</AdobeCode>
    <AdobeCode>{2AEEBC84-FA86-4F01-BD3D-8701639000B7}</AdobeCode>
    <AdobeCode>{FF7B84CC-D263-4FBC-8D25-8E47B7165D30}</AdobeCode>
    <AdobeCode>{AADBFB12-EED5-4119-B228-5C2B9C5C8E9C}</AdobeCode>
    <AdobeCode>{7D3BF844-0003-428B-9BD6-11B693DFD980}</AdobeCode>
    <AdobeCode>{3907D683-0B9A-4122-9924-CF396A33ABF2}</AdobeCode>
    <AdobeCode>{2133A596-0E02-43D5-9ADE-3B181A18963D}</AdobeCode>
    <AdobeCode>{E3D11C0D-E72D-4339-BC49-D86D7066C089}</AdobeCode>
    <AdobeCode>{CACFCF56-F06E-4EB6-93C5-D2B769953BE2}</AdobeCode>
    <AdobeCode>{9F9A50DA-3238-4C0B-AFFE-8D04D044F4DE}</AdobeCode>
    <AdobeCode>{9464BB02-4315-4304-9144-6D577A016CAE}</AdobeCode>
    <AdobeCode>{280F70E8-C6EB-4601-9F8E-7BF85F1F8986}</AdobeCode>
    <AdobeCode>{83A6706F-609A-45DE-88FC-56BB6970477A}</AdobeCode>
    <AdobeCode>{2DD4DE71-993F-46DE-B349-E9B601BD8FA7}</AdobeCode>
    <AdobeCode>{BA2DE4D5-B69A-4BAF-82B2-4B9B48C21D3E}</AdobeCode>
    <AdobeCode>{D217283F-A38F-43B9-B3AC-FA9D80E18162}</AdobeCode>
    <AdobeCode>{170F972D-D1FA-4B45-BDDB-E20E205C9766}</AdobeCode>
    <AdobeCode>{12421F1B-5660-48A2-B159-FAE72EEA7A2F}</AdobeCode>
    <AdobeCode>{7E706189-6318-4BCA-9B59-016628754338}</AdobeCode>
    <AdobeCode>{AD8B8B45-6DC7-42D6-BB03-1ED9D5094FDF}</AdobeCode>
    <AdobeCode>{FB109740-53CE-4B3E-9CC9-213EA40EC49C}</AdobeCode>
    <AdobeCode>{A6735685-8625-4E5D-9CE4-D97A4EF75206}</AdobeCode>
    <AdobeCode>{32F530CC-143E-46E6-BD21-03919692801B}</AdobeCode>
    <AdobeCode>{C48510D7-1897-4F06-8DD7-B393068C5C20}</AdobeCode>
    <AdobeCode>{AB46913E-C8BA-450F-A75D-C40A2C410E06}</AdobeCode>
    <AdobeCode>{54D528A7-EB2D-4D97-A9F4-601D5984481F}</AdobeCode>
    <AdobeCode>{13FB7CF1-9B0A-49C1-8D43-C4A39F6F09A5}</AdobeCode>
    <AdobeCode>{2F7EB898-233D-425C-9EE7-CAC1563E68FE}</AdobeCode>
    <AdobeCode>{BE19301B-7560-403A-98AD-B9DFF750845F}</AdobeCode>
  </Upgrades><Channel enable="1" id="PhotoshopCameraRaw7-7.0">
        <DisplayName>Photoshop Camera Raw 7</DisplayName>
      </Channel><Update id="7.3.22">
        
        
      &lt;DisplayName default="en_US"&gt;
        &lt;en_US&gt;Photoshop Camera Raw 7.3&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour 7.3 de Photoshop Camera Raw&lt;/fr_FR&gt;
		&lt;de_DE&gt;Photoshop Camera Raw 7.3-Update&lt;/de_DE&gt;
		&lt;it_IT&gt;Aggiornamento di Photoshop Camera Raw 7.3&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop Camera Raw 7.3 アップデート&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización Photoshop Camera Raw 7.3&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatering till Photoshop Camera Raw 7.3&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop Camera Raw 7.3 更新&lt;/zh_CN&gt;
		&lt;zh_TW&gt;Photoshop Camera Raw 7.3 更新&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Photoshop Camera Raw 7.3-update&lt;/nl_NL&gt;
		&lt;ko_KR&gt;Photoshop Camera Raw 7.3 업데이트&lt;/ko_KR&gt;
		&lt;nb_NO&gt;Oppdatering for Photoshop Camera Raw 7.3&lt;/nb_NO&gt;
		&lt;da_DK&gt;Photoshop Camera Raw 7.3-opdatering&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop Camera Raw 7.3 -päivitys&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Photoshop Camera Raw 7.3 – aktualizacja&lt;/pl_PL&gt;
		&lt;cs_CZ&gt;Aktualizace Photoshop Camera Raw 7.3&lt;/cs_CZ&gt;
		&lt;ro_RO&gt;Actualizare Photoshop Camera Raw 7.3&lt;/ro_RO&gt;
		&lt;hu_HU&gt;Photoshop Camera Raw 7.3 frissítés&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление Photoshop Camera Raw 7.3&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do Photoshop Camera Raw 7.3&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення Photoshop Camera Raw 7.3&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop Camera Raw 7.3 Güncellemesi&lt;/tr_TR&gt;
    &lt;/DisplayName&gt;&lt;Description default="en_US"&gt;
        &lt;en_US&gt;Update to the Camera Raw plug-in that ships with Photoshop CS6.  Adds raw support for new camera models.&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour du module externe Camera Raw fourni avec Photoshop CS6.  Ajoute la prise en charge des fichiers Raw pour les nouveaux modèles d'appareils photo.&lt;/fr_FR&gt;
		&lt;de_DE&gt;Update für das Camera Raw-Zusatzmodul, das im Lieferumfang von Photoshop CS6 enthalten ist.  Zusätzliche Unterstützung für Raw-Dateien aus neuen Kameramodellen&lt;/de_DE&gt;
		&lt;it_IT&gt;Eseguite l'aggiornamento del plug-in di Camera Raw in dotazione con Photoshop CS6.  Consente il supporto per i file raw per nuovi modelli di fotocamere&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop CS6 に同梱されている Camera Raw プラグインに更新します。  新しいカメラモデル対応の Raw サポートが追加されます。&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización para el plugin Camera Raw suministrado con Photoshop CS6.  Permite la compatibilidad con los archivos RAW de los nuevos modelos de cámara.&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatera plugin-programmet Camera Raw som levereras med Photoshop CS6.  Lägger till stöd för raw-format för nya kameramodeller.&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop CS6 随附的 Camera Raw 插件的更新。针对新相机型号增加 raw 文件格式支持&lt;/zh_CN&gt;
		&lt;zh_TW&gt;更新 Photoshop CS6 隨附的 Camera Raw 增效模組。  新增對新相機機型的原生支援&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Update voor de Camera Raw-plug-in die bij Photoshop CS6 wordt geleverd.  Voegt RAW-ondersteuning toe voor nieuwe cameramodellen&lt;/nl_NL&gt;
		&lt;cs_CZ&gt;Aktualizace zásuvného modulu Camera Raw, dodávaného s aplikací Photoshop CS6.  Přidává podporu formátu raw u nových modelů fotoaparátů&lt;/cs_CZ&gt;
		&lt;nb_NO&gt;Oppdatering for tilleggsmodulen Camera Raw som leveres med Photoshop CS6.  Legger til ekte støtte for nye kameramodeller&lt;/nb_NO&gt;
		&lt;da_DK&gt;Opdatering til Camera Raw-ekstramodulet, der leveres sammen med Photoshop CS6.  Føjer Raw-understøttelse til nye kameramodeller&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop CS6:n mukana toimitettavan Camera Raw -laajennuksen päivitys.  Lisää raw-tuen uusille kameramalleille.&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Aktualizacja wtyczki Camera Raw, która jest dołączona do programu Photoshop CS6.  Dodaje obsługę RAW dla nowych modeli aparatów&lt;/pl_PL&gt;
		&lt;ko_KR&gt;Photoshop CS6와 함께 제공된 Camera Raw 플러그인을 업데이트합니다.  새 카메라 모델의 raw 파일 지원 추가&lt;/ko_KR&gt;
		&lt;ro_RO&gt;Actualizaţi la plugin-ul Camera Raw livrat cu Photoshop CS6.  Acesta adaugă compatibilitate cu formate brute de la noi modele de camere foto&lt;/ro_RO&gt;
		&lt;hu_HU&gt;A Photoshop CS6 verzióhoz tartozó Camera Raw bővítmény frissítése.  Biztosítja a raw-formátum támogatását újabb fényképezőgép-típusok esetében is&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление внешнего модуля Camera Raw, который входит в комплект поставки Photoshop CS6.  Добавлена поддержка формата raw для новых моделей камер&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do plug-in do Camera Raw fornecido com o Photoshop CS6.  Inclusão de suporte adicional para novos modelos de câmeras&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення для модуля Camera Raw, що постачається з пакетом Photoshop CS6.  Додано підтримку формату raw для нових моделей фотокамер.&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop CS6 ile birlikte verilen Camera Raw eklentisine güncelleyin.  Yeni fotoğraf makinesi modelleri için raw desteği sağlar.&lt;/tr_TR&gt;
    &lt;/Description&gt;</Update><Extends type="patch">
    <ParentProductInfo>
      <Family>Shared Technology</Family>
      <ProductName>Photoshop Camera Raw 7</ProductName>
      <AdobeCode>{CFC3110A-491C-4DBF-A97D-66C567600A2F}</AdobeCode>
    </ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="42583048" sysDriveSize="0"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>42583570</TotalSize>
      <MaxPathComponent>/Plug-Ins/CS6/File Formats\Camera Raw.8bi</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="1" name="Assets1_1" size="42583048"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
    <Win32>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Bb][Rr][Ii][Dd][Gg][Ee].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Aa][Uu][Tt][Oo][Aa][Nn][Aa][Ll][Yy][Zz][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 10.0.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr][Ff][Xx].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 9.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Dd][Oo][Ww][Nn][Ll][Oo][Aa][Dd][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Ll][Ii][Gg][Hh][Tt][Rr][Oo][Oo][Mm].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 9.0.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp][Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Oo][Rr][Gg][Aa][Nn][Ii][Zz][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Dd][Nn][Gg] [Cc][Oo][Nn][Vv][Ee][Rr][Tt][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp][Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Ee][Dd][Ii][Tt][Oo][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 10.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss].[Ee][Xx][Ee]$</Process>
    </Win32>
  </ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">7.3</Value>
      <Value lang="be_BY">7.3</Value>
      <Value lang="bg_BG">7.3</Value>
      <Value lang="ca_ES">7.3</Value>
      <Value lang="cs_CZ">7.3</Value>
      <Value lang="da_DK">7.3</Value>
      <Value lang="de_DE">7.3</Value>
      <Value lang="el_GR">7.3</Value>
      <Value lang="en_GB">7.3</Value>
      <Value lang="en_MX">7.3</Value>
      <Value lang="en_US">7.3</Value>
      <Value lang="en_XC">7.3</Value>
      <Value lang="en_XM">7.3</Value>
      <Value lang="es_ES">7.3</Value>
      <Value lang="es_MX">7.3</Value>
      <Value lang="es_QM">7.3</Value>
      <Value lang="et_EE">7.3</Value>
      <Value lang="fi_FI">7.3</Value>
      <Value lang="fr_CA">7.3</Value>
      <Value lang="fr_FR">7.3</Value>
      <Value lang="fr_MX">7.3</Value>
      <Value lang="fr_XM">7.3</Value>
      <Value lang="he_IL">7.3</Value>
      <Value lang="hi_IN">7.3</Value>
      <Value lang="hr_HR">7.3</Value>
      <Value lang="hu_HU">7.3</Value>
      <Value lang="is_IS">7.3</Value>
      <Value lang="it_IT">7.3</Value>
      <Value lang="ja_JP">7.3</Value>
      <Value lang="ko_KR">7.3</Value>
      <Value lang="lt_LT">7.3</Value>
      <Value lang="lv_LV">7.3</Value>
      <Value lang="mk_MK">7.3</Value>
      <Value lang="nb_NO">7.3</Value>
      <Value lang="nl_NL">7.3</Value>
      <Value lang="nn_NO">7.3</Value>
      <Value lang="no_NO">7.3</Value>
      <Value lang="pl_PL">7.3</Value>
      <Value lang="pt_BR">7.3</Value>
      <Value lang="ro_RO">7.3</Value>
      <Value lang="ru_RU">7.3</Value>
      <Value lang="sh_YU">7.3</Value>
      <Value lang="sk_SK">7.3</Value>
      <Value lang="sl_SI">7.3</Value>
      <Value lang="sq_AL">7.3</Value>
      <Value lang="sv_SE">7.3</Value>
      <Value lang="th_TH">7.3</Value>
      <Value lang="tr_TR">7.3</Value>
      <Value lang="uk_UA">7.3</Value>
      <Value lang="vi_VN">7.3</Value>
      <Value lang="zh_CN">7.3</Value>
      <Value lang="zh_TW">7.3</Value>
      <Value lang="en_AE">7.3</Value>
      <Value lang="en_IL">7.3</Value>
      <Value lang="fr_MA">7.3</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Photoshop Camera Raw 7</Value>
      <Value lang="be_BY">Photoshop Camera Raw 7</Value>
      <Value lang="bg_BG">Photoshop Camera Raw 7</Value>
      <Value lang="ca_ES">Photoshop Camera Raw 7</Value>
      <Value lang="cs_CZ">Photoshop Camera Raw 7</Value>
      <Value lang="da_DK">Photoshop Camera Raw 7</Value>
      <Value lang="de_DE">Photoshop Camera Raw 7</Value>
      <Value lang="el_GR">Photoshop Camera Raw 7</Value>
      <Value lang="en_GB">Photoshop Camera Raw 7</Value>
      <Value lang="en_MX">Photoshop Camera Raw 7</Value>
      <Value lang="en_US">Photoshop Camera Raw 7</Value>
      <Value lang="en_XC">Photoshop Camera Raw 7</Value>
      <Value lang="en_XM">Photoshop Camera Raw 7</Value>
      <Value lang="es_ES">Photoshop Camera Raw 7</Value>
      <Value lang="es_MX">Photoshop Camera Raw 7</Value>
      <Value lang="es_QM">Photoshop Camera Raw 7</Value>
      <Value lang="et_EE">Photoshop Camera Raw 7</Value>
      <Value lang="fi_FI">Photoshop Camera Raw 7</Value>
      <Value lang="fr_CA">Photoshop Camera Raw 7</Value>
      <Value lang="fr_FR">Photoshop Camera Raw 7</Value>
      <Value lang="fr_MX">Photoshop Camera Raw 7</Value>
      <Value lang="fr_XM">Photoshop Camera Raw 7</Value>
      <Value lang="he_IL">Photoshop Camera Raw 7</Value>
      <Value lang="hi_IN">Photoshop Camera Raw 7</Value>
      <Value lang="hr_HR">Photoshop Camera Raw 7</Value>
      <Value lang="hu_HU">Photoshop Camera Raw 7</Value>
      <Value lang="is_IS">Photoshop Camera Raw 7</Value>
      <Value lang="it_IT">Photoshop Camera Raw 7</Value>
      <Value lang="ja_JP">Photoshop Camera Raw 7</Value>
      <Value lang="ko_KR">Photoshop Camera Raw 7</Value>
      <Value lang="lt_LT">Photoshop Camera Raw 7</Value>
      <Value lang="lv_LV">Photoshop Camera Raw 7</Value>
      <Value lang="mk_MK">Photoshop Camera Raw 7</Value>
      <Value lang="nb_NO">Photoshop Camera Raw 7</Value>
      <Value lang="nl_NL">Photoshop Camera Raw 7</Value>
      <Value lang="nn_NO">Photoshop Camera Raw 7</Value>
      <Value lang="no_NO">Photoshop Camera Raw 7</Value>
      <Value lang="pl_PL">Photoshop Camera Raw 7</Value>
      <Value lang="pt_BR">Photoshop Camera Raw 7</Value>
      <Value lang="ro_RO">Photoshop Camera Raw 7</Value>
      <Value lang="ru_RU">Photoshop Camera Raw 7</Value>
      <Value lang="sh_YU">Photoshop Camera Raw 7</Value>
      <Value lang="sk_SK">Photoshop Camera Raw 7</Value>
      <Value lang="sl_SI">Photoshop Camera Raw 7</Value>
      <Value lang="sq_AL">Photoshop Camera Raw 7</Value>
      <Value lang="sv_SE">Photoshop Camera Raw 7</Value>
      <Value lang="th_TH">Photoshop Camera Raw 7</Value>
      <Value lang="tr_TR">Photoshop Camera Raw 7</Value>
      <Value lang="uk_UA">Photoshop Camera Raw 7</Value>
      <Value lang="vi_VN">Photoshop Camera Raw 7</Value>
      <Value lang="zh_CN">Photoshop Camera Raw 7</Value>
      <Value lang="zh_TW">Photoshop Camera Raw 7</Value>
      <Value lang="en_AE">Photoshop Camera Raw 7</Value>
      <Value lang="en_IL">Photoshop Camera Raw 7</Value>
      <Value lang="fr_MA">Photoshop Camera Raw 7</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "0", "ChannelID", "PhotoshopCameraRaw7-7.0")
INSERT INTO PayloadData VALUES("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "0", "ChannelInfo", '<Channel enable="1" id="PhotoshopCameraRaw7-7.0">
        <DisplayName>Photoshop Camera Raw 7</DisplayName>
      </Channel>')
INSERT INTO PayloadData VALUES("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "0", "UpdateID", "7.3.22")
INSERT INTO PayloadData VALUES("{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "0", "UpdateInfo", '<Update id="7.3.22">
        
        
      &lt;DisplayName default="en_US"&gt;
        &lt;en_US&gt;Photoshop Camera Raw 7.3&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour 7.3 de Photoshop Camera Raw&lt;/fr_FR&gt;
		&lt;de_DE&gt;Photoshop Camera Raw 7.3-Update&lt;/de_DE&gt;
		&lt;it_IT&gt;Aggiornamento di Photoshop Camera Raw 7.3&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop Camera Raw 7.3 アップデート&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización Photoshop Camera Raw 7.3&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatering till Photoshop Camera Raw 7.3&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop Camera Raw 7.3 更新&lt;/zh_CN&gt;
		&lt;zh_TW&gt;Photoshop Camera Raw 7.3 更新&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Photoshop Camera Raw 7.3-update&lt;/nl_NL&gt;
		&lt;ko_KR&gt;Photoshop Camera Raw 7.3 업데이트&lt;/ko_KR&gt;
		&lt;nb_NO&gt;Oppdatering for Photoshop Camera Raw 7.3&lt;/nb_NO&gt;
		&lt;da_DK&gt;Photoshop Camera Raw 7.3-opdatering&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop Camera Raw 7.3 -päivitys&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Photoshop Camera Raw 7.3 – aktualizacja&lt;/pl_PL&gt;
		&lt;cs_CZ&gt;Aktualizace Photoshop Camera Raw 7.3&lt;/cs_CZ&gt;
		&lt;ro_RO&gt;Actualizare Photoshop Camera Raw 7.3&lt;/ro_RO&gt;
		&lt;hu_HU&gt;Photoshop Camera Raw 7.3 frissítés&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление Photoshop Camera Raw 7.3&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do Photoshop Camera Raw 7.3&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення Photoshop Camera Raw 7.3&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop Camera Raw 7.3 Güncellemesi&lt;/tr_TR&gt;
    &lt;/DisplayName&gt;&lt;Description default="en_US"&gt;
        &lt;en_US&gt;Update to the Camera Raw plug-in that ships with Photoshop CS6.  Adds raw support for new camera models.&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour du module externe Camera Raw fourni avec Photoshop CS6.  Ajoute la prise en charge des fichiers Raw pour les nouveaux modèles d'appareils photo.&lt;/fr_FR&gt;
		&lt;de_DE&gt;Update für das Camera Raw-Zusatzmodul, das im Lieferumfang von Photoshop CS6 enthalten ist.  Zusätzliche Unterstützung für Raw-Dateien aus neuen Kameramodellen&lt;/de_DE&gt;
		&lt;it_IT&gt;Eseguite l'aggiornamento del plug-in di Camera Raw in dotazione con Photoshop CS6.  Consente il supporto per i file raw per nuovi modelli di fotocamere&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop CS6 に同梱されている Camera Raw プラグインに更新します。  新しいカメラモデル対応の Raw サポートが追加されます。&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización para el plugin Camera Raw suministrado con Photoshop CS6.  Permite la compatibilidad con los archivos RAW de los nuevos modelos de cámara.&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatera plugin-programmet Camera Raw som levereras med Photoshop CS6.  Lägger till stöd för raw-format för nya kameramodeller.&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop CS6 随附的 Camera Raw 插件的更新。针对新相机型号增加 raw 文件格式支持&lt;/zh_CN&gt;
		&lt;zh_TW&gt;更新 Photoshop CS6 隨附的 Camera Raw 增效模組。  新增對新相機機型的原生支援&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Update voor de Camera Raw-plug-in die bij Photoshop CS6 wordt geleverd.  Voegt RAW-ondersteuning toe voor nieuwe cameramodellen&lt;/nl_NL&gt;
		&lt;cs_CZ&gt;Aktualizace zásuvného modulu Camera Raw, dodávaného s aplikací Photoshop CS6.  Přidává podporu formátu raw u nových modelů fotoaparátů&lt;/cs_CZ&gt;
		&lt;nb_NO&gt;Oppdatering for tilleggsmodulen Camera Raw som leveres med Photoshop CS6.  Legger til ekte støtte for nye kameramodeller&lt;/nb_NO&gt;
		&lt;da_DK&gt;Opdatering til Camera Raw-ekstramodulet, der leveres sammen med Photoshop CS6.  Føjer Raw-understøttelse til nye kameramodeller&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop CS6:n mukana toimitettavan Camera Raw -laajennuksen päivitys.  Lisää raw-tuen uusille kameramalleille.&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Aktualizacja wtyczki Camera Raw, która jest dołączona do programu Photoshop CS6.  Dodaje obsługę RAW dla nowych modeli aparatów&lt;/pl_PL&gt;
		&lt;ko_KR&gt;Photoshop CS6와 함께 제공된 Camera Raw 플러그인을 업데이트합니다.  새 카메라 모델의 raw 파일 지원 추가&lt;/ko_KR&gt;
		&lt;ro_RO&gt;Actualizaţi la plugin-ul Camera Raw livrat cu Photoshop CS6.  Acesta adaugă compatibilitate cu formate brute de la noi modele de camere foto&lt;/ro_RO&gt;
		&lt;hu_HU&gt;A Photoshop CS6 verzióhoz tartozó Camera Raw bővítmény frissítése.  Biztosítja a raw-formátum támogatását újabb fényképezőgép-típusok esetében is&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление внешнего модуля Camera Raw, который входит в комплект поставки Photoshop CS6.  Добавлена поддержка формата raw для новых моделей камер&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do plug-in do Camera Raw fornecido com o Photoshop CS6.  Inclusão de suporte adicional para novos modelos de câmeras&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення для модуля Camera Raw, що постачається з пакетом Photoshop CS6.  Додано підтримку формату raw для нових моделей фотокамер.&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop CS6 ile birlikte verilen Camera Raw eklentisine güncelleyin.  Yeni fotoğraf makinesi modelleri için raw desteği sağlar.&lt;/tr_TR&gt;
    &lt;/Description&gt;</Update>')
