/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner.recorder.actions;

import com.android.monkeyrunner.MonkeyDevice;
import com.android.monkeyrunner.recorder.actions.Action;
import com.android.monkeyrunner.recorder.actions.PyDictUtilBuilder;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;

public class TouchAction
implements Action {
    public static final BiMap<String, String> DOWNUP_FLAG_MAP = ImmutableBiMap.of((Object)"downAndUp", (Object)"Tap", (Object)"down", (Object)"Down", (Object)"up", (Object)"Up");
    private final int x;
    private final int y;
    private final String direction;

    public TouchAction(int x, int y, String direction) {
        this.x = x;
        this.y = y;
        this.direction = direction;
    }

    public String getDisplayName() {
        return String.format("%s touchscreen at (%d, %d)", DOWNUP_FLAG_MAP.get((Object)this.direction), this.x, this.y);
    }

    public void execute(MonkeyDevice device) throws Exception {
        device.touch(this.x, this.y, MonkeyDevice.TOUCH_NAME_TO_ENUM.get(this.direction));
    }

    public String serialize() {
        String pydict = PyDictUtilBuilder.newBuilder().add("x", this.x).add("y", this.y).add("type", this.direction).build();
        return "TOUCH|" + pydict;
    }
}

