/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner.recorder.actions;

import com.android.monkeyrunner.MonkeyDevice;
import com.android.monkeyrunner.recorder.actions.Action;
import com.android.monkeyrunner.recorder.actions.PyDictUtilBuilder;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;

public class PressAction
implements Action {
    public static String[] KEYS = new String[]{"MENU", "HOME", "SEARCH"};
    public static final BiMap<String, String> DOWNUP_FLAG_MAP = ImmutableBiMap.of((Object)"downAndUp", (Object)"Press", (Object)"down", (Object)"Down", (Object)"up", (Object)"Up");
    private final String key;
    private final String downUpFlag;

    public PressAction(String key, String downUpFlag) {
        this.key = key;
        this.downUpFlag = downUpFlag;
    }

    public PressAction(String key) {
        this(key, "downAndUp");
    }

    public String getDisplayName() {
        return String.format("%s button %s", DOWNUP_FLAG_MAP.get((Object)this.downUpFlag), this.key);
    }

    public String serialize() {
        String pydict = PyDictUtilBuilder.newBuilder().add("name", this.key).add("type", this.downUpFlag).build();
        return "PRESS|" + pydict;
    }

    public void execute(MonkeyDevice device) {
        device.press(this.key, MonkeyDevice.TOUCH_NAME_TO_ENUM.get(this.downUpFlag));
    }
}

