/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner.adb;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.monkeyrunner.MonkeyDevice;
import com.android.monkeyrunner.MonkeyRunnerBackend;
import com.android.monkeyrunner.adb.AdbMonkeyDevice;
import com.android.sdklib.SdkConstants;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class AdbBackend
implements MonkeyRunnerBackend {
    private static Logger LOG = Logger.getLogger(AdbBackend.class.getCanonicalName());
    private static final int CONNECTION_ITERATION_TIMEOUT_MS = 200;
    private final List<AdbMonkeyDevice> devices = Lists.newArrayList();
    private final AndroidDebugBridge bridge;

    public AdbBackend() {
        String adbLocation = this.findAdb();
        AndroidDebugBridge.init((boolean)false);
        this.bridge = AndroidDebugBridge.createBridge((String)adbLocation, (boolean)true);
    }

    private String findAdb() {
        String mrParentLocation = System.getProperty("com.android.monkeyrunner.bindir");
        if (mrParentLocation != null && mrParentLocation.length() != 0) {
            File platformTools = new File(new File(mrParentLocation).getParent(), "platform-tools");
            if (platformTools.isDirectory()) {
                return platformTools.getAbsolutePath() + File.separator + SdkConstants.FN_ADB;
            }
            return mrParentLocation + File.separator + SdkConstants.FN_ADB;
        }
        return SdkConstants.FN_ADB;
    }

    private IDevice findAttacedDevice(String deviceIdRegex) {
        Pattern pattern = Pattern.compile(deviceIdRegex);
        for (IDevice device : this.bridge.getDevices()) {
            String serialNumber = device.getSerialNumber();
            if (!pattern.matcher(serialNumber).matches()) continue;
            return device;
        }
        return null;
    }

    public MonkeyDevice waitForConnection() {
        return this.waitForConnection(Integer.MAX_VALUE, ".*");
    }

    public MonkeyDevice waitForConnection(long timeoutMs, String deviceIdRegex) {
        do {
            IDevice device;
            if ((device = this.findAttacedDevice(deviceIdRegex)) != null && device.getState() == IDevice.DeviceState.ONLINE) {
                AdbMonkeyDevice amd = new AdbMonkeyDevice(device);
                this.devices.add(amd);
                return amd;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Error sleeping", e);
            }
        } while ((timeoutMs -= 200L) > 0L);
        return null;
    }

    public void shutdown() {
        for (AdbMonkeyDevice device : this.devices) {
            device.dispose();
        }
        AndroidDebugBridge.terminate();
    }
}

