/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import com.android.monkeyrunner.doc.MonkeyRunnerExported;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyReflectedField;
import org.python.core.PyReflectedFunction;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JythonUtils {
    private static final Logger LOG = Logger.getLogger(JythonUtils.class.getCanonicalName());
    private static final Map<Class<? extends PyObject>, Class<?>> PYOBJECT_TO_JAVA_OBJECT_MAP;
    private static final Predicate<AccessibleObject> SHOULD_BE_DOCUMENTED;
    private static final Predicate<Field> IS_FIELD_STATIC;

    private JythonUtils() {
    }

    public static ArgParser createArgParser(PyObject[] args, String[] kws) {
        Method m;
        Class<?> clz;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement element = stackTrace[2];
        String methodName = element.getMethodName();
        String className = element.getClassName();
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.SEVERE, "Got exception: ", e);
            return null;
        }
        try {
            m = clz.getMethod(methodName, PyObject[].class, String[].class);
        }
        catch (SecurityException e) {
            LOG.log(Level.SEVERE, "Got exception: ", e);
            return null;
        }
        catch (NoSuchMethodException e) {
            LOG.log(Level.SEVERE, "Got exception: ", e);
            return null;
        }
        MonkeyRunnerExported annotation = m.getAnnotation(MonkeyRunnerExported.class);
        return new ArgParser(methodName, args, kws, annotation.args());
    }

    public static double getFloat(ArgParser ap, int position) {
        PyObject arg = ap.getPyObject(position);
        if (Py.isInstance((PyObject)arg, (PyObject)PyFloat.TYPE)) {
            return ((PyFloat)arg).asDouble();
        }
        if (Py.isInstance((PyObject)arg, (PyObject)PyInteger.TYPE)) {
            return ((PyInteger)arg).asDouble();
        }
        throw Py.TypeError((String)("Unable to parse argument: " + position));
    }

    public static double getFloat(ArgParser ap, int position, double defaultValue) {
        PyObject arg = ap.getPyObject(position, (PyObject)new PyFloat(defaultValue));
        if (Py.isInstance((PyObject)arg, (PyObject)PyFloat.TYPE)) {
            return ((PyFloat)arg).asDouble();
        }
        if (Py.isInstance((PyObject)arg, (PyObject)PyInteger.TYPE)) {
            return ((PyInteger)arg).asDouble();
        }
        throw Py.TypeError((String)("Unable to parse argument: " + position));
    }

    public static List<Object> getList(ArgParser ap, int position) {
        PyObject arg = ap.getPyObject(position, Py.None);
        if (Py.isInstance((PyObject)arg, (PyObject)PyNone.TYPE)) {
            return Collections.emptyList();
        }
        ArrayList ret = Lists.newArrayList();
        PyList array = (PyList)arg;
        for (int x = 0; x < array.__len__(); ++x) {
            PyObject item = array.__getitem__(x);
            Class<?> javaClass = PYOBJECT_TO_JAVA_OBJECT_MAP.get(item.getClass());
            if (javaClass == null) continue;
            ret.add(item.__tojava__(javaClass));
        }
        return ret;
    }

    public static Map<String, Object> getMap(ArgParser ap, int position) {
        PyObject arg = ap.getPyObject(position, Py.None);
        if (Py.isInstance((PyObject)arg, (PyObject)PyNone.TYPE)) {
            return Collections.emptyMap();
        }
        HashMap ret = Maps.newHashMap();
        PyDictionary dict = (PyDictionary)arg;
        PyList items = dict.items();
        for (int x = 0; x < items.__len__(); ++x) {
            PyTuple item = (PyTuple)items.__getitem__(x);
            String key = (String)item.__getitem__(0).__str__().__tojava__(String.class);
            PyObject value = item.__getitem__(1);
            Class<?> javaClass = PYOBJECT_TO_JAVA_OBJECT_MAP.get(value.getClass());
            if (javaClass == null) continue;
            ret.put(key, value.__tojava__(javaClass));
        }
        return ret;
    }

    private static PyObject convertObject(Object o) {
        if (o instanceof String) {
            return new PyString((String)o);
        }
        if (o instanceof Double) {
            return new PyFloat(((Double)o).doubleValue());
        }
        if (o instanceof Integer) {
            return new PyInteger(((Integer)o).intValue());
        }
        if (o instanceof Float) {
            float f = ((Float)o).floatValue();
            return new PyFloat(f);
        }
        return Py.None;
    }

    public static PyDictionary convertMapToDict(Map<String, Object> map) {
        HashMap resultMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            resultMap.put(new PyString(entry.getKey()), JythonUtils.convertObject(entry.getValue()));
        }
        return new PyDictionary((Map)resultMap);
    }

    public static void convertDocAnnotationsForClass(Class<?> clz, PyObject dict) {
        MonkeyRunnerExported doc;
        Preconditions.checkNotNull((Object)dict);
        Preconditions.checkArgument((boolean)(dict instanceof PyStringMap));
        if (clz.isAnnotationPresent(MonkeyRunnerExported.class)) {
            MonkeyRunnerExported doc2 = clz.getAnnotation(MonkeyRunnerExported.class);
            String fullDoc = JythonUtils.buildClassDoc(doc2, clz);
            dict.__setitem__("__doc__", (PyObject)new PyString(fullDoc));
        }
        Collection functions = Sets.newHashSet();
        for (PyObject item : dict.asIterable()) {
            functions.add(item.toString());
        }
        functions = Collections2.filter((Collection)functions, (Predicate)new Predicate<String>(){

            public boolean apply(String value) {
                return !value.startsWith("__");
            }
        });
        for (Method method : clz.getMethods()) {
            String methodName;
            PyObject pyFunc;
            if (!method.isAnnotationPresent(MonkeyRunnerExported.class) || (pyFunc = dict.__finditem__(methodName = method.getName())) == null || !(pyFunc instanceof PyReflectedFunction)) continue;
            PyReflectedFunction realPyFunc = (PyReflectedFunction)pyFunc;
            doc = method.getAnnotation(MonkeyRunnerExported.class);
            realPyFunc.__doc__ = new PyString(JythonUtils.buildDoc(doc));
            functions.remove(methodName);
        }
        for (AccessibleObject accessibleObject : clz.getFields()) {
            String fieldName;
            PyObject pyField;
            if (!accessibleObject.isAnnotationPresent(MonkeyRunnerExported.class) || (pyField = dict.__finditem__(fieldName = ((Field)accessibleObject).getName())) == null || !(pyField instanceof PyReflectedField)) continue;
            PyReflectedField realPyfield = (PyReflectedField)pyField;
            doc = ((Field)accessibleObject).getAnnotation(MonkeyRunnerExported.class);
            functions.remove(fieldName);
        }
        for (String name : functions) {
            dict.__delitem__(name);
        }
    }

    private static String buildClassDoc(MonkeyRunnerExported doc, Class<?> clz) {
        Collection annotatedFields = Collections2.filter(Arrays.asList(clz.getFields()), SHOULD_BE_DOCUMENTED);
        Collection staticFields = Collections2.filter((Collection)annotatedFields, IS_FIELD_STATIC);
        Collection nonStaticFields = Collections2.filter((Collection)annotatedFields, (Predicate)Predicates.not(IS_FIELD_STATIC));
        StringBuilder sb = new StringBuilder();
        for (String line : JythonUtils.splitString(doc.doc(), 80)) {
            sb.append(line).append("\n");
        }
        if (staticFields.size() > 0) {
            sb.append("\nClass Fields: \n");
            for (Field f : staticFields) {
                sb.append(JythonUtils.buildFieldDoc(f));
            }
        }
        if (nonStaticFields.size() > 0) {
            sb.append("\n\nFields: \n");
            for (Field f : nonStaticFields) {
                sb.append(JythonUtils.buildFieldDoc(f));
            }
        }
        return sb.toString();
    }

    private static String buildFieldDoc(Field f) {
        MonkeyRunnerExported annotation = f.getAnnotation(MonkeyRunnerExported.class);
        StringBuilder sb = new StringBuilder();
        int indentOffset = 5 + f.getName().length();
        String indent = JythonUtils.makeIndent(indentOffset);
        sb.append("  ").append(f.getName()).append(" - ");
        boolean first = true;
        for (String line : JythonUtils.splitString(annotation.doc(), 80 - indentOffset)) {
            if (first) {
                first = false;
                sb.append(line).append("\n");
                continue;
            }
            sb.append(indent).append(line).append("\n");
        }
        return sb.toString();
    }

    private static String buildDoc(MonkeyRunnerExported doc) {
        Collection<String> docs = JythonUtils.splitString(doc.doc(), 80);
        StringBuilder sb = new StringBuilder();
        for (String d : docs) {
            sb.append(d).append("\n");
        }
        if (doc.args() != null && doc.args().length > 0) {
            String[] args = doc.args();
            String[] argDocs = doc.argDocs();
            sb.append("\n  Args:\n");
            for (int x = 0; x < doc.args().length; ++x) {
                sb.append("    ").append(args[x]);
                if (argDocs == null || argDocs.length <= x) continue;
                sb.append(" - ");
                int indentOffset = args[x].length() + 3 + 4;
                Collection<String> lines = JythonUtils.splitString(argDocs[x], 80 - indentOffset);
                boolean first = true;
                String indent = JythonUtils.makeIndent(indentOffset);
                for (String line : lines) {
                    if (first) {
                        first = false;
                        sb.append(line).append("\n");
                        continue;
                    }
                    sb.append(indent).append(line).append("\n");
                }
            }
        }
        return sb.toString();
    }

    private static String makeIndent(int indentOffset) {
        if (indentOffset == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        while (indentOffset > 0) {
            sb.append(' ');
            --indentOffset;
        }
        return sb.toString();
    }

    private static Collection<String> splitString(String source, int offset) {
        BreakIterator boundary = BreakIterator.getLineInstance();
        boundary.setText(source);
        ArrayList lines = Lists.newArrayList();
        StringBuilder currentLine = new StringBuilder();
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            String b = source.substring(start, end);
            if (currentLine.length() + b.length() < offset) {
                currentLine.append(b);
            } else {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(b);
            }
            start = end;
            end = boundary.next();
        }
        lines.add(currentLine.toString());
        return lines;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(PyString.class, String.class);
        builder.put(PyFloat.class, Double.class);
        builder.put(PyInteger.class, Integer.class);
        PYOBJECT_TO_JAVA_OBJECT_MAP = builder.build();
        SHOULD_BE_DOCUMENTED = new Predicate<AccessibleObject>(){

            public boolean apply(AccessibleObject ao) {
                return ao.isAnnotationPresent(MonkeyRunnerExported.class);
            }
        };
        IS_FIELD_STATIC = new Predicate<Field>(){

            public boolean apply(Field f) {
                return (f.getModifiers() & 8) != 0;
            }
        };
    }
}

