/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import java.text.DecimalFormat;

public class TraceUnits {
    private TimeScale mTimeScale = TimeScale.MicroSeconds;
    private double mScale = 1.0;
    DecimalFormat mFormatter = new DecimalFormat();

    public double getScaledValue(long value) {
        return (double)value * this.mScale;
    }

    public double getScaledValue(double value) {
        return value * this.mScale;
    }

    public String valueOf(long value) {
        return this.valueOf((double)value);
    }

    public String valueOf(double value) {
        double scaled = value * this.mScale;
        String pattern = (double)((int)scaled) == scaled ? "###,###" : "###,###.###";
        this.mFormatter.applyPattern(pattern);
        return this.mFormatter.format(scaled);
    }

    public String labelledString(double value) {
        String units = this.label();
        String num = this.valueOf(value);
        return String.format("%s: %s", units, num);
    }

    public String labelledString(long value) {
        return this.labelledString((double)value);
    }

    public String label() {
        if (this.mScale == 1.0) {
            return "usec";
        }
        if (this.mScale == 0.001) {
            return "msec";
        }
        if (this.mScale == 1.0E-6) {
            return "sec";
        }
        return null;
    }

    public void setTimeScale(TimeScale val) {
        this.mTimeScale = val;
        switch (val) {
            case Seconds: {
                this.mScale = 1.0E-6;
                break;
            }
            case MilliSeconds: {
                this.mScale = 0.001;
                break;
            }
            case MicroSeconds: {
                this.mScale = 1.0;
            }
        }
    }

    public TimeScale getTimeScale() {
        return this.mTimeScale;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeScale {
        Seconds,
        MilliSeconds,
        MicroSeconds;

    }
}

