/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DebugPortManager;
import com.android.ddmlib.Log;
import com.android.ddms.DebugPortProvider;
import com.android.ddms.PrefsDialog;
import com.android.ddms.UIThread;
import com.android.sdkstats.SdkStatsService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Properties;

public class Main {
    public static String sRevision;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac OS")) {
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            System.setProperty("JAVA_STARTED_ON_FIRST_THREAD_" + rt.getName().split("@")[0], "1");
        }
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler());
        PrefsDialog.init();
        Log.d("ddms", "Initializing");
        if (args.length >= 3 && args[0].equals("ping")) {
            SdkStatsService.ping(args[1], args[2], null);
            return;
        }
        if (args.length > 0) {
            Log.e("ddms", "Unknown argument: " + args[0]);
            System.exit(1);
        }
        String ddmsParentLocation = System.getProperty("com.android.ddms.bindir");
        Main.ping(ddmsParentLocation);
        DebugPortManager.setProvider(DebugPortProvider.getInstance());
        UIThread ui = UIThread.getInstance();
        try {
            ui.runUI(ddmsParentLocation);
        }
        finally {
            PrefsDialog.save();
            AndroidDebugBridge.terminate();
        }
        Log.d("ddms", "Bye");
        System.exit(0);
    }

    public static void ping(String ddmsParentLocation) {
        Properties p = new Properties();
        try {
            File sourceProp = ddmsParentLocation != null && ddmsParentLocation.length() > 0 ? new File(ddmsParentLocation, "source.properties") : new File("source.properties");
            p.load(new FileInputStream(sourceProp));
            sRevision = p.getProperty("Pkg.Revision");
            if (sRevision != null && sRevision.length() > 0) {
                SdkStatsService.ping("ddms", sRevision, null);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
            Log.e("ddms", "shutting down due to uncaught exception");
            Log.e("ddms", e);
            System.exit(1);
        }
    }
}

