/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.xml;

import com.android.sdklib.io.IAbstractFile;
import com.android.sdklib.io.IAbstractFolder;
import com.android.sdklib.io.StreamException;
import com.android.sdklib.xml.AndroidXPathFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class AndroidManifest {
    public static final String NODE_MANIFEST = "manifest";
    public static final String NODE_APPLICATION = "application";
    public static final String NODE_ACTIVITY = "activity";
    public static final String NODE_SERVICE = "service";
    public static final String NODE_RECEIVER = "receiver";
    public static final String NODE_PROVIDER = "provider";
    public static final String NODE_INTENT = "intent-filter";
    public static final String NODE_ACTION = "action";
    public static final String NODE_CATEGORY = "category";
    public static final String NODE_USES_SDK = "uses-sdk";
    public static final String NODE_INSTRUMENTATION = "instrumentation";
    public static final String NODE_USES_LIBRARY = "uses-library";
    public static final String NODE_SUPPORTS_SCREENS = "supports-screens";
    public static final String NODE_USES_CONFIGURATION = "uses-configuration";
    public static final String NODE_USES_FEATURE = "uses-feature";
    public static final String ATTRIBUTE_PACKAGE = "package";
    public static final String ATTRIBUTE_VERSIONCODE = "versionCode";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_REQUIRED = "required";
    public static final String ATTRIBUTE_GLESVERSION = "glEsVersion";
    public static final String ATTRIBUTE_PROCESS = "process";
    public static final String ATTRIBUTE_DEBUGGABLE = "debuggable";
    public static final String ATTRIBUTE_MIN_SDK_VERSION = "minSdkVersion";
    public static final String ATTRIBUTE_TARGET_SDK_VERSION = "targetSdkVersion";
    public static final String ATTRIBUTE_TARGET_PACKAGE = "targetPackage";
    public static final String ATTRIBUTE_EXPORTED = "exported";
    public static final String ATTRIBUTE_RESIZEABLE = "resizeable";
    public static final String ATTRIBUTE_ANYDENSITY = "anyDensity";
    public static final String ATTRIBUTE_SMALLSCREENS = "smallScreens";
    public static final String ATTRIBUTE_NORMALSCREENS = "normalScreens";
    public static final String ATTRIBUTE_LARGESCREENS = "largeScreens";
    public static final String ATTRIBUTE_REQ_5WAYNAV = "reqFiveWayNav";
    public static final String ATTRIBUTE_REQ_NAVIGATION = "reqNavigation";
    public static final String ATTRIBUTE_REQ_HARDKEYBOARD = "reqHardKeyboard";
    public static final String ATTRIBUTE_REQ_KEYBOARDTYPE = "reqKeyboardType";
    public static final String ATTRIBUTE_REQ_TOUCHSCREEN = "reqTouchScreen";

    public static String getPackage(IAbstractFolder projectFolder) throws XPathExpressionException, StreamException {
        IAbstractFile file = projectFolder.getFile("AndroidManifest.xml");
        return AndroidManifest.getPackage(file);
    }

    public static String getPackage(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        return xPath.evaluate("/manifest/@package", new InputSource(manifestFile.getContents()));
    }

    public static boolean getDebuggable(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        String value = xPath.evaluate("/manifest/application/@debuggable", new InputSource(manifestFile.getContents()));
        return Boolean.parseBoolean(value);
    }

    public static int getVersionCode(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        String result = xPath.evaluate("/manifest/@android:versionCode", new InputSource(manifestFile.getContents()));
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static boolean hasVersionCode(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        Node node;
        XPath xPath = AndroidXPathFactory.newXPath();
        Object result = xPath.evaluate("/manifest/@android:versionCode", new InputSource(manifestFile.getContents()), XPathConstants.NODE);
        return result != null && (node = (Node)result).getNodeValue().length() > 0;
    }

    public static int getMinSdkVersion(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        String result = xPath.evaluate("/manifest/uses-sdk/@android:minSdkVersion", new InputSource(manifestFile.getContents()));
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return result.length() > 0 ? -1 : 1;
        }
    }

    public static String combinePackageAndClassName(String javaPackage, String className) {
        boolean hasDot;
        if (className == null || className.length() == 0) {
            return javaPackage;
        }
        if (javaPackage == null || javaPackage.length() == 0) {
            return className;
        }
        boolean startWithDot = className.charAt(0) == '.';
        boolean bl = hasDot = className.indexOf(46) != -1;
        if (startWithDot || !hasDot) {
            if (startWithDot) {
                return javaPackage + className;
            }
            return javaPackage + '.' + className;
        }
        return className;
    }

    public static String extractActivityName(String fullActivityName, String packageName) {
        String name;
        if (packageName != null && fullActivityName != null && packageName.length() > 0 && fullActivityName.startsWith(packageName) && (name = fullActivityName.substring(packageName.length())).length() > 0 && name.charAt(0) == '.') {
            return name;
        }
        return fullActivityName;
    }
}

