/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.resources;

import com.android.sdklib.resources.ResourceEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ScreenOrientation implements ResourceEnum
{
    PORTRAIT("port", "Portrait", "Portrait Orientation"),
    LANDSCAPE("land", "Landscape", "Landscape Orientation"),
    SQUARE("square", "Square", "Square Orientation");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private ScreenOrientation(String value, String shortDisplayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = shortDisplayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static ScreenOrientation getEnum(String value) {
        for (ScreenOrientation orient : ScreenOrientation.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(ScreenOrientation orientation) {
        int i = 0;
        for (ScreenOrientation orient : ScreenOrientation.values()) {
            if (orient == orientation) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ScreenOrientation getByIndex(int index) {
        int i = 0;
        for (ScreenOrientation orient : ScreenOrientation.values()) {
            if (i == index) {
                return orient;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

