/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.DocPackage;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.PlatformToolPackage;
import com.android.sdklib.internal.repository.SamplePackage;
import com.android.sdklib.internal.repository.ToolPackage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SdkSource
implements IDescription {
    private String mUrl;
    private Package[] mPackages;
    private String mDescription;
    private String mFetchError;
    private final String mUiName;

    public SdkSource(String url, String uiName) {
        if (url == null) {
            url = "";
        }
        if ((url = url.trim()).endsWith("/")) {
            url = url + this.getUrlDefaultXmlFile();
        }
        this.mUrl = url;
        this.mUiName = uiName;
        this.setDefaultDescription();
    }

    public abstract boolean isAddonSource();

    protected abstract String getUrlDefaultXmlFile();

    protected abstract int getNsLatestVersion();

    protected abstract String getNsUri();

    protected abstract String getNsPattern();

    protected abstract String getSchemaUri(int var1);

    protected abstract String getRootElementName();

    protected abstract InputStream getXsdStream(int var1);

    protected abstract Document findAlternateToolsXml(InputStream var1) throws IOException;

    public boolean equals(Object obj) {
        if (obj instanceof SdkSource) {
            SdkSource rs = (SdkSource)obj;
            return rs.getUrl().equals(this.getUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.mUrl.hashCode();
    }

    public String getUiName() {
        return this.mUiName;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public Package[] getPackages() {
        return this.mPackages;
    }

    public void clearPackages() {
        this.mPackages = null;
    }

    public String toString() {
        String s = this.getShortDescription();
        if (s != null) {
            return s;
        }
        return super.toString();
    }

    public String getShortDescription() {
        if (this.mUiName != null && this.mUiName.length() > 0) {
            String host = "malformed URL";
            try {
                URL u = new URL(this.mUrl);
                host = u.getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return String.format("%1$s (%2$s)", this.mUiName, host);
        }
        return this.mUrl;
    }

    public String getLongDescription() {
        return this.mDescription == null ? "" : this.mDescription;
    }

    public String getFetchError() {
        return this.mFetchError;
    }

    public void load(ITaskMonitor monitor, boolean forceHttp) {
        monitor.setProgressMax(4);
        this.setDefaultDescription();
        String url = this.mUrl;
        if (forceHttp) {
            url = url.replaceAll("https://", "http://");
        }
        monitor.setDescription("Fetching %1$s", url);
        monitor.incProgress(1);
        this.mFetchError = null;
        Boolean[] validatorFound = new Boolean[]{Boolean.FALSE};
        String[] validationError = new String[]{null};
        Exception[] exception = new Exception[]{null};
        InputStream xml = this.fetchUrl(url, exception);
        Document validatedDoc = null;
        boolean usingAlternateXml = false;
        boolean usingAlternateUrl = false;
        String validatedUri = null;
        if (xml == null && !url.endsWith(this.getUrlDefaultXmlFile())) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + this.getUrlDefaultXmlFile();
            xml = this.fetchUrl(url, exception);
            usingAlternateUrl = true;
        }
        if (xml != null) {
            monitor.setDescription("Validate XML", new Object[0]);
            for (int tryOtherUrl = 0; tryOtherUrl < 2; ++tryOtherUrl) {
                int version = this.getXmlSchemaVersion(xml);
                if (version >= 1 && version <= this.getNsLatestVersion()) {
                    String uri = this.validateXml(xml, url, version, validationError, validatorFound);
                    if (uri != null) {
                        validatedDoc = this.getDocument(xml, monitor);
                        validatedUri = uri;
                        if (!usingAlternateUrl || validatedDoc == null) break;
                        monitor.setResult("Repository found at %1$s", url);
                        this.mUrl = url;
                        break;
                    }
                    if (!validatorFound[0].equals(Boolean.FALSE)) break;
                    this.mFetchError = validationError[0];
                    break;
                }
                if (version > this.getNsLatestVersion()) {
                    try {
                        validatedDoc = this.findAlternateToolsXml(xml);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (validatedDoc == null) break;
                    validationError[0] = null;
                    validatedUri = this.getNsUri();
                    usingAlternateXml = true;
                    break;
                }
                if (version < 1 && tryOtherUrl == 0 && !usingAlternateUrl) {
                    this.mFetchError = String.format("Failed to validate the XML for the repository at URL '%1$s'", url);
                    if (url.endsWith(this.getUrlDefaultXmlFile())) break;
                    if (!url.endsWith("/")) {
                        url = url + "/";
                    }
                    if ((xml = this.fetchUrl(url = url + this.getUrlDefaultXmlFile(), null)) == null) break;
                } else {
                    if (version >= 1 || !usingAlternateUrl || this.mFetchError != null) break;
                    this.mFetchError = String.format("Failed to validate the XML for the repository at URL '%1$s'", url);
                    break;
                }
                usingAlternateUrl = true;
            }
        }
        if (exception[0] != null) {
            this.mFetchError = "Failed to fetch URL";
            String reason = null;
            if (exception[0] instanceof FileNotFoundException) {
                reason = "File not found";
                this.mFetchError = this.mFetchError + ": " + reason;
            } else if (exception[0] instanceof SSLKeyException) {
                reason = "HTTPS SSL error. You might want to force download through HTTP in the settings.";
                this.mFetchError = this.mFetchError + ": HTTPS SSL error";
            } else {
                reason = exception[0].getMessage() != null ? exception[0].getMessage() : String.format("Unknown (%1$s)", exception[0].getClass().getName());
            }
            monitor.setResult("Failed to fetch URL %1$s, reason: %2$s", url, reason);
        }
        if (validationError[0] != null) {
            monitor.setResult("%s", validationError[0]);
        }
        if (validatedDoc == null) {
            return;
        }
        if (usingAlternateXml) {
            String info;
            boolean isADT = false;
            try {
                Class<?> adt = Class.forName("com.android.ide.eclipse.adt.AdtPlugin");
                isADT = adt != null;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (isADT) {
                info = "This repository requires a more recent version of ADT. Please update the Eclipse Android plugin.";
                this.mDescription = "This repository requires a more recent version of ADT, the Eclipse Android plugin.\nYou must update it before you can see other new packages.";
            } else {
                info = "This repository requires a more recent version of the Tools. Please update.";
                this.mDescription = "This repository requires a more recent version of the Tools.\nYou must update it before you can see other new packages.";
            }
            this.mFetchError = this.mFetchError == null ? info : this.mFetchError + ". " + info;
        }
        monitor.incProgress(1);
        if (xml != null) {
            monitor.setDescription("Parse XML", new Object[0]);
            monitor.incProgress(1);
            this.parsePackages(validatedDoc, validatedUri, monitor);
            this.mDescription = this.mPackages == null || this.mPackages.length == 0 ? this.mDescription + "\nNo packages found." : (this.mPackages.length == 1 ? this.mDescription + "\nOne package found." : this.mDescription + String.format("\n%1$d packages found.", this.mPackages.length));
        }
        monitor.incProgress(1);
    }

    private void setDefaultDescription() {
        if (this.isAddonSource()) {
            String desc = "";
            if (this.mUiName != null) {
                desc = desc + "Add-on Provider: " + this.mUiName;
                desc = desc + "\n";
            }
            this.mDescription = desc = desc + "Add-on URL: " + this.mUrl;
        } else {
            this.mDescription = String.format("SDK Source: %1$s", this.mUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream fetchUrl(String urlString, Exception[] outException) {
        ByteArrayInputStream byteArrayInputStream;
        block12: {
            URL url = new URL(urlString);
            InputStream is = null;
            int inc = 65536;
            int curr = 0;
            byte[] result = new byte[inc];
            try {
                int n;
                is = url.openStream();
                while ((n = is.read(result, curr, result.length - curr)) != -1) {
                    if ((curr += n) != result.length) continue;
                    byte[] temp = new byte[curr + inc];
                    System.arraycopy(result, 0, temp, 0, curr);
                    result = temp;
                }
                byteArrayInputStream = new ByteArrayInputStream(result, 0, curr);
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (outException != null) {
                        outException[0] = e;
                    }
                    return null;
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return byteArrayInputStream;
    }

    protected String validateXml(InputStream xml, String url, int version, String[] outError, Boolean[] validatorFound) {
        if (xml == null) {
            return null;
        }
        try {
            Validator validator = this.getValidator(version);
            if (validator == null) {
                validatorFound[0] = Boolean.FALSE;
                outError[0] = String.format("XML verification failed for %1$s.\nNo suitable XML Schema Validator could be found in your Java environment. Please consider updating your version of Java.", url);
                return null;
            }
            validatorFound[0] = Boolean.TRUE;
            xml.reset();
            validator.validate(new StreamSource(xml));
            return this.getSchemaUri(version);
        }
        catch (SAXParseException e) {
            outError[0] = String.format("XML verification failed for %1$s.\nLine %2$d:%3$d, Error: %4$s", url, e.getLineNumber(), e.getColumnNumber(), e.toString());
        }
        catch (Exception e) {
            outError[0] = String.format("XML verification failed for %1$s.\nError: %2$s", url, e.toString());
        }
        return null;
    }

    protected int getXmlSchemaVersion(InputStream xml) {
        if (xml == null) {
            return 0;
        }
        Node doc = null;
        try {
            xml.reset();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(xml);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (doc == null) {
            return 0;
        }
        Pattern nsPattern = Pattern.compile(this.getNsPattern());
        String prefix = null;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            Matcher m;
            String uri;
            Node attr;
            if (child.getNodeType() != 1) continue;
            prefix = null;
            String name = child.getNodeName();
            int pos = name.indexOf(58);
            if (pos > 0 && pos < name.length() - 1) {
                prefix = name.substring(0, pos);
                name = name.substring(pos + 1);
            }
            if (!this.getRootElementName().equals(name)) continue;
            NamedNodeMap attrs = child.getAttributes();
            String xmlns = "xmlns";
            if (prefix != null) {
                xmlns = xmlns + ":" + prefix;
            }
            if ((attr = attrs.getNamedItem(xmlns)) == null || (uri = attr.getNodeValue()) == null || !(m = nsPattern.matcher(uri)).matches()) continue;
            String version = m.group(1);
            try {
                return Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private Validator getValidator(int version) throws SAXException {
        InputStream xsdStream = this.getXsdStream(version);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (factory == null) {
            return null;
        }
        Schema schema = factory.newSchema(new StreamSource(xsdStream));
        Validator validator = schema == null ? null : schema.newValidator();
        return validator;
    }

    protected boolean parsePackages(Document doc, String nsUri, ITaskMonitor monitor) {
        Node root = this.getFirstChild(doc, nsUri, this.getRootElementName());
        if (root != null) {
            Node child;
            ArrayList<AddonPackage> packages = new ArrayList<AddonPackage>();
            HashMap<String, String> licenses = new HashMap<String, String>();
            for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                Node id;
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !child.getLocalName().equals("license") || (id = child.getAttributes().getNamedItem("id")) == null) continue;
                licenses.put(id.getNodeValue(), child.getTextContent());
            }
            for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI())) continue;
                String name = child.getLocalName();
                Package p = null;
                try {
                    if ("add-on".equals(name)) {
                        p = new AddonPackage(this, child, nsUri, licenses);
                    } else if ("extra".equals(name)) {
                        p = new ExtraPackage(this, child, nsUri, licenses);
                    } else if (!this.isAddonSource()) {
                        if ("platform".equals(name)) {
                            p = new PlatformPackage(this, child, nsUri, licenses);
                        } else if ("doc".equals(name)) {
                            p = new DocPackage(this, child, nsUri, licenses);
                        } else if ("tool".equals(name)) {
                            p = new ToolPackage(this, child, nsUri, licenses);
                        } else if ("platform-tool".equals(name)) {
                            p = new PlatformToolPackage(this, child, nsUri, licenses);
                        } else if ("sample".equals(name)) {
                            p = new SamplePackage(this, child, nsUri, licenses);
                        }
                    }
                    if (p == null) continue;
                    packages.add((AddonPackage)p);
                    monitor.setDescription("Found %1$s", p.getShortDescription());
                    continue;
                }
                catch (Exception e) {
                    monitor.setResult("Ignoring invalid %1$s element: %2$s", name, e.toString());
                }
            }
            this.mPackages = packages.toArray(new Package[packages.size()]);
            Arrays.sort(this.mPackages, null);
            return true;
        }
        return false;
    }

    private Node getFirstChild(Node node, String nsUri, String xmlLocalName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || xmlLocalName != null && !child.getLocalName().equals(xmlLocalName)) continue;
            return child;
        }
        return null;
    }

    protected Document getDocument(InputStream xml, ITaskMonitor monitor) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            xml.reset();
            Document doc = builder.parse(new InputSource(xml));
            return doc;
        }
        catch (ParserConfigurationException e) {
            monitor.setResult("Failed to create XML document builder", new Object[0]);
        }
        catch (SAXException e) {
            monitor.setResult("Failed to parse XML document", new Object[0]);
        }
        catch (IOException e) {
            monitor.setResult("Failed to read XML document", new Object[0]);
        }
        return null;
    }
}

