/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.MinToolsPackage;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.XmlParserUtils;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformPackage
extends MinToolsPackage
implements IPackageVersion {
    public static final String PROP_VERSION = "Platform.Version";
    private final AndroidVersion mVersion;
    private final String mVersionName;

    PlatformPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mVersionName = XmlParserUtils.getXmlString(packageNode, "version");
        int apiLevel = XmlParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = XmlParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        this.mVersion = new AndroidVersion(apiLevel, codeName);
    }

    PlatformPackage(IAndroidTarget target, Properties props) {
        super(null, props, target.getRevision(), null, target.getDescription(), null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), target.getLocation());
        this.mVersion = target.getVersion();
        this.mVersionName = target.getVersionName();
    }

    @Override
    void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
        if (this.mVersionName != null) {
            props.setProperty(PROP_VERSION, this.mVersionName);
        }
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    @Override
    public String getShortDescription() {
        String s = this.mVersion.isPreview() ? String.format("SDK Platform Android %1$s Preview, revision %2$s%3$s", this.getVersionName(), this.getRevision(), this.isObsolete() ? " (Obsolete)" : "") : String.format("SDK Platform Android %1$s, API %2$d, revision %3$s%4$s", this.getVersionName(), this.mVersion.getApiLevel(), this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, String suggestedDir, SdkManager sdkManager) {
        for (IAndroidTarget target : sdkManager.getTargets()) {
            if (!target.isPlatform() || !target.getVersion().equals(this.mVersion)) continue;
            return new File(target.getLocation());
        }
        File platforms = new File(osSdkRoot, "platforms");
        File folder = new File(platforms, String.format("android-%s", this.getVersion().getApiString()));
        return folder;
    }

    @Override
    public boolean preInstallHook(Archive archive, ITaskMonitor monitor, String osSdkRoot, File installFolder) {
        File platformsRoot = new File(osSdkRoot, "platforms");
        if (!platformsRoot.isDirectory()) {
            platformsRoot.mkdir();
        }
        return super.preInstallHook(archive, monitor, osSdkRoot, installFolder);
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof PlatformPackage) {
            PlatformPackage newPkg = (PlatformPackage)pkg;
            return newPkg.getVersion().equals(this.getVersion());
        }
        return false;
    }
}

