/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.export;

import com.android.sdklib.internal.export.LogHelper;
import com.android.sdklib.internal.export.ProjectConfig;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApkData
implements Comparable<ApkData> {
    private static final String PROP_PROJECT = "project";
    private static final String PROP_BUILDINFO = "buildInfo";
    private static final String PROP_MINOR = "minorCode";
    private static final String PROP_ABI = "abi";
    private static final String PROP_RESOURCES = "resources";
    private static final String[][] ABI_SORTING = new String[][]{{"armeabi", "armeabi-v7a"}};
    private final ProjectConfig mProjectConfig;
    private final HashMap<String, String> mOutputNames = new HashMap();
    private int mBuildInfo;
    private int mMinorCode;
    private final String mAbi;
    private final Map<String, String> mSoftVariantMap = new HashMap<String, String>();

    ApkData(ProjectConfig projectConfig, String abi, Map<String, String> softVariants) {
        this.mProjectConfig = projectConfig;
        this.mAbi = abi;
        if (softVariants != null) {
            this.mSoftVariantMap.putAll(softVariants);
        }
    }

    ApkData(ProjectConfig projectConfig, String abi) {
        this(projectConfig, abi, null);
    }

    ApkData(ProjectConfig projectConfig, Map<String, String> softVariants) {
        this(projectConfig, null, softVariants);
    }

    ApkData(ProjectConfig projectConfig) {
        this(projectConfig, null, null);
    }

    public ProjectConfig getProjectConfig() {
        return this.mProjectConfig;
    }

    public String getOutputName(String key) {
        return this.mOutputNames.get(key);
    }

    public void setOutputName(String key, String outputName) {
        this.mOutputNames.put(key, outputName);
    }

    public int getBuildInfo() {
        return this.mBuildInfo;
    }

    void setBuildInfo(int buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public int getMinorCode() {
        return this.mMinorCode;
    }

    void setMinorCode(int minor) {
        this.mMinorCode = minor;
    }

    public String getAbi() {
        return this.mAbi;
    }

    public Map<String, String> getSoftVariantMap() {
        return this.mSoftVariantMap;
    }

    public int getCompositeVersionCode(int versionCode) {
        int trueVersionCode = versionCode * 10000;
        trueVersionCode += this.getBuildInfo() * 100;
        return trueVersionCode += this.getMinorCode();
    }

    public String toString() {
        return this.getLogLine(null);
    }

    public String getLogLine(String key) {
        String filter;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOutputName(key)).append(':');
        LogHelper.write(sb, PROP_BUILDINFO, this.mBuildInfo);
        LogHelper.write(sb, PROP_MINOR, this.mMinorCode);
        LogHelper.write(sb, PROP_PROJECT, this.mProjectConfig.getRelativePath());
        sb.append(this.mProjectConfig.getConfigString(true));
        if (this.mAbi != null) {
            LogHelper.write(sb, PROP_ABI, this.mAbi);
        }
        if ((filter = this.mSoftVariantMap.get(key)) != null) {
            LogHelper.write(sb, PROP_RESOURCES, filter);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(ApkData o) {
        int comp;
        int minSdkDiff = this.mProjectConfig.getMinSdkVersion() - o.mProjectConfig.getMinSdkVersion();
        if (minSdkDiff != 0) {
            return minSdkDiff;
        }
        if (!this.mProjectConfig.getSupportsScreens().hasSameScreenSupportAs(o.mProjectConfig.getSupportsScreens())) {
            return this.mProjectConfig.getSupportsScreens().compareScreenSizesWith(o.mProjectConfig.getSupportsScreens());
        }
        if (this.mProjectConfig.getGlEsVersion() != -1) {
            if (o.mProjectConfig.getGlEsVersion() == -1) return -1;
            comp = this.mProjectConfig.getGlEsVersion() - o.mProjectConfig.getGlEsVersion();
            if (comp != 0) {
                return comp;
            }
        } else if (o.mProjectConfig.getGlEsVersion() != -1) {
            return 1;
        }
        if (this.mAbi == null || o.mAbi == null || (comp = this.compareAbi(this.mAbi, o.mAbi)) == 0) return 0;
        return comp;
    }

    private int compareAbi(String abi, String abi2) {
        for (String[] abiArray : ABI_SORTING) {
            int abiIndex = -1;
            int abiIndex2 = -1;
            int count = abiArray.length;
            for (int i = 0; i < count; ++i) {
                if (abiArray[i].equals(abi)) {
                    abiIndex = i;
                }
                if (!abiArray[i].equals(abi2)) continue;
                abiIndex2 = i;
            }
            if (abiIndex == -1 || abiIndex == -1) continue;
            return abiIndex - abiIndex2;
        }
        return 0;
    }
}

