/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

final class TaskHelper {
    TaskHelper() {
    }

    static File getSdkLocation(Project antProject) {
        String sdkOsPath = antProject.getProperty("sdk.dir");
        if (sdkOsPath == null || sdkOsPath.length() == 0) {
            throw new BuildException("SDK Location is not set.");
        }
        File sdk = new File(sdkOsPath);
        if (!sdk.isDirectory()) {
            throw new BuildException(String.format("SDK Location '%s' is not valid.", sdkOsPath));
        }
        return sdk;
    }

    static int getToolsRevision(File sdkFile) {
        Properties p = new Properties();
        try {
            File toolsFolder = new File(sdkFile, "tools");
            File sourceProp = new File(toolsFolder, "source.properties");
            p.load(new FileInputStream(sourceProp));
            String value = p.getProperty("Pkg.Revision");
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    static String checkSinglePath(String attribute, Path path) {
        String[] paths = path.list();
        if (paths.length != 1) {
            throw new BuildException(String.format("Value for '%1$s' is not valid. It must resolve to a single path", attribute));
        }
        return paths[0];
    }
}

