/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.io.FileWrapper;
import com.android.sdklib.io.FolderWrapper;
import com.android.sdklib.io.IAbstractFile;
import com.android.sdklib.io.IAbstractFolder;
import com.android.sdklib.xml.AndroidManifest;
import com.android.sdklib.xml.AndroidXPathFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ImportTask;
import org.apache.tools.ant.types.Path;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetupTask
extends ImportTask {
    private static final String RULES_MAIN = "main_rules.xml";
    private static final String RULES_TEST = "test_rules.xml";
    private static final String RULES_LIBRARY = "lib_rules.xml";
    private boolean mDoImport = true;

    public void execute() throws BuildException {
        File platformTools;
        int toolsRevison;
        Project antProject = this.getProject();
        File sdkDir = TaskHelper.getSdkLocation(antProject);
        String sdkOsPath = sdkDir.getPath();
        if (sdkOsPath.length() > 0 && !sdkOsPath.endsWith(File.separator)) {
            sdkOsPath = sdkOsPath + File.separator;
        }
        if ((toolsRevison = TaskHelper.getToolsRevision(sdkDir)) != -1) {
            System.out.println("Android SDK Tools Revision " + toolsRevison);
        }
        if (!(platformTools = new File(sdkDir, "platform-tools")).isDirectory()) {
            throw new BuildException(String.format("SDK Platform Tools component is missing. Please install it with the SDK Manager (%1$s%2$c%3$s)", "tools", Character.valueOf(File.separatorChar), SdkConstants.androidCmdName()));
        }
        String targetHashString = antProject.getProperty("target");
        boolean isTestProject = false;
        if (antProject.getProperty("tested.project.dir") != null) {
            isTestProject = true;
        }
        if (targetHashString == null) {
            throw new BuildException("Android Target is not set.");
        }
        final ArrayList messages = new ArrayList();
        SdkManager manager = SdkManager.createManager((String)sdkOsPath, (ISdkLog)new ISdkLog(){

            public void error(Throwable t, String errorFormat, Object ... args) {
                if (errorFormat != null) {
                    messages.add(String.format("Error: " + errorFormat, args));
                }
                if (t != null) {
                    messages.add("Error: " + t.getMessage());
                }
            }

            public void printf(String msgFormat, Object ... args) {
                messages.add(String.format(msgFormat, args));
            }

            public void warning(String warningFormat, Object ... args) {
                messages.add(String.format("Warning: " + warningFormat, args));
            }
        });
        if (manager == null) {
            for (String msg : messages) {
                System.out.println(msg);
            }
            throw new BuildException("Failed to parse SDK content.");
        }
        IAndroidTarget androidTarget = manager.getTargetFromHashString(targetHashString);
        if (androidTarget == null) {
            throw new BuildException(String.format("Unable to resolve target '%s'", targetHashString));
        }
        System.out.println("Project Target: " + androidTarget.getName());
        if (!androidTarget.isPlatform()) {
            System.out.println("Vendor: " + androidTarget.getVendor());
            System.out.println("Platform Version: " + androidTarget.getVersionName());
        }
        System.out.println("API level: " + androidTarget.getVersion().getApiString());
        boolean isLibrary = false;
        String libraryProp = antProject.getProperty("android.library");
        if (libraryProp != null) {
            isLibrary = Boolean.valueOf(libraryProp);
        }
        if (isLibrary) {
            System.out.println("Project Type: Android Library");
        }
        this.processReferencedLibraries(antProject, androidTarget);
        this.checkManifest(antProject, androidTarget.getVersion());
        String androidJar = androidTarget.getPath(1);
        antProject.setProperty("android.jar", androidJar);
        String androidAidl = androidTarget.getPath(2);
        antProject.setProperty("android.aidl", androidAidl);
        antProject.setProperty("aapt", androidTarget.getPath(20));
        antProject.setProperty("aidl", androidTarget.getPath(21));
        antProject.setProperty("dx", androidTarget.getPath(22));
        Path bootclasspath = new Path(antProject);
        Path.PathElement element = bootclasspath.createPathElement();
        element.setPath(androidJar);
        IAndroidTarget.IOptionalLibrary[] libraries = androidTarget.getOptionalLibraries();
        if (libraries != null) {
            HashSet<String> visitedJars = new HashSet<String>();
            for (IAndroidTarget.IOptionalLibrary library : libraries) {
                String jarPath = library.getJarPath();
                if (visitedJars.contains(jarPath)) continue;
                visitedJars.add(jarPath);
                element = bootclasspath.createPathElement();
                element.setPath(library.getJarPath());
            }
        }
        antProject.addReference("android.target.classpath", (Object)bootclasspath);
        if (this.mDoImport) {
            File rulesFolder = new File(new File(sdkOsPath, "tools"), "ant");
            if (!rulesFolder.isDirectory()) {
                throw new BuildException(String.format("Rules directory '%s' is missing.", rulesFolder.getAbsolutePath()));
            }
            String importedRulesFileName = isLibrary ? RULES_LIBRARY : (isTestProject ? RULES_TEST : RULES_MAIN);
            File rules = new File(rulesFolder, importedRulesFileName);
            if (!rules.isFile()) {
                throw new BuildException(String.format("Build rules file '%s' is missing.", rules));
            }
            String rulesOsPath = rules.getAbsolutePath();
            if (rulesOsPath.startsWith(sdkOsPath) && (rulesOsPath = rulesOsPath.substring(sdkOsPath.length())).startsWith(File.separator)) {
                rulesOsPath = rulesOsPath.substring(1);
            }
            System.out.println("\nImporting rules file: " + rulesOsPath);
            this.setFile(rules.getAbsolutePath());
            super.execute();
        }
    }

    public void setImport(boolean value) {
        this.mDoImport = value;
    }

    private void checkManifest(Project antProject, AndroidVersion androidVersion) {
        block12: {
            try {
                File manifest = new File(antProject.getBaseDir(), "AndroidManifest.xml");
                XPath xPath = AndroidXPathFactory.newXPath();
                String value = xPath.evaluate("/manifest/@package", new InputSource(new FileInputStream(manifest)));
                if (value != null && value.indexOf(46) == -1) {
                    throw new BuildException(String.format("Application package '%1$s' must have a minimum of 2 segments.", value));
                }
                value = xPath.evaluate("/manifest/uses-sdk/@android:minSdkVersion", new InputSource(new FileInputStream(manifest)));
                if (androidVersion.isPreview()) {
                    String codeName = androidVersion.getCodename();
                    if (!codeName.equals(value)) {
                        throw new BuildException(String.format("For '%1$s' SDK Preview, attribute minSdkVersion in AndroidManifest.xml must be '%1$s'", codeName));
                    }
                    break block12;
                }
                if (value.length() > 0) {
                    int minSdkValue = -1;
                    try {
                        minSdkValue = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        throw new BuildException(String.format("Attribute %1$s in AndroidManifest.xml must be an Integer!", "minSdkVersion"));
                    }
                    int projectApiLevel = androidVersion.getApiLevel();
                    if (minSdkValue < projectApiLevel) {
                        System.out.println(String.format("WARNING: Attribute %1$s in AndroidManifest.xml (%2$d) is lower than the project target API level (%3$d)", "minSdkVersion", minSdkValue, projectApiLevel));
                    } else if (minSdkValue > androidVersion.getApiLevel()) {
                        System.out.println(String.format("WARNING: Attribute %1$s in AndroidManifest.xml (%2$d) is higher than the project target API level (%3$d)", "minSdkVersion", minSdkValue, projectApiLevel));
                    }
                    break block12;
                }
                System.out.println("WARNING: No minSdkVersion value set. Application will install on all Android versions.");
            }
            catch (XPathExpressionException e) {
                throw new BuildException((Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private void processReferencedLibraries(Project antProject, IAndroidTarget androidTarget) {
        Path sourcePath = new Path(antProject);
        Path resPath = new Path(antProject);
        Path libsPath = new Path(antProject);
        Path jarsPath = new Path(antProject);
        StringBuilder sb = new StringBuilder();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        };
        System.out.println("\n------------------\nResolving library dependencies:");
        ArrayList<File> libraries = this.getProjectLibraries(antProject);
        if (libraries.size() > 0) {
            System.out.println("------------------\nOrdered libraries:");
            for (File library : libraries) {
                String value;
                System.out.println(library.getAbsolutePath());
                Path.PathElement element = sourcePath.createPathElement();
                ProjectProperties prop = ProjectProperties.load((IAbstractFolder)new FolderWrapper(library), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.BUILD);
                String sourceDir = "src";
                if (prop != null && (value = prop.getProperty("source.dir")) != null) {
                    sourceDir = value;
                }
                String path = library.getAbsolutePath();
                element.setPath(path + "/" + sourceDir);
                element = resPath.createPathElement();
                element.setPath(path + "/" + "res");
                element = libsPath.createPathElement();
                element.setPath(path + "/" + "libs");
                File libsFolder = new File(library, "libs");
                File[] jarFiles = libsFolder.listFiles(filter);
                if (jarFiles != null) {
                    for (File jarFile : jarFiles) {
                        element = jarsPath.createPathElement();
                        element.setPath(jarFile.getAbsolutePath());
                    }
                }
                FileWrapper manifest = new FileWrapper(library, "AndroidManifest.xml");
                try {
                    String value2 = AndroidManifest.getPackage((IAbstractFile)manifest);
                    if (value2 == null) continue;
                    sb.append(';');
                    sb.append(value2);
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        } else {
            System.out.println("No library dependencies.\n");
        }
        System.out.println("------------------\n");
        antProject.addReference("project.libraries.src", (Object)sourcePath);
        antProject.addReference("project.libraries.jars", (Object)jarsPath);
        antProject.addReference("project.libraries.libs", (Object)libsPath);
        if (sourcePath.list().length > 0) {
            antProject.addReference("project.libraries.res", (Object)resPath);
            antProject.setProperty("project.libraries.package", sb.toString());
        }
    }

    private ArrayList<File> getProjectLibraries(final Project antProject) {
        ArrayList<File> libraries = new ArrayList<File>();
        File baseDir = antProject.getBaseDir();
        ArrayList<File> topLevelLibraries = this.getDirectDependencies(baseDir, new IPropertySource(){

            public String getProperty(String name) {
                return antProject.getProperty(name);
            }
        });
        this.resolveFullLibraryDependencies(topLevelLibraries, libraries);
        return libraries;
    }

    private void resolveFullLibraryDependencies(ArrayList<File> inLibraries, ArrayList<File> outLibraries) {
        for (int i = inLibraries.size() - 1; i >= 0; --i) {
            File library = inLibraries.get(i);
            final ProjectProperties defaultProp = ProjectProperties.load((IAbstractFolder)new FolderWrapper(library), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.DEFAULT);
            ArrayList<File> dependencies = this.getDirectDependencies(library, new IPropertySource(){

                public String getProperty(String name) {
                    return defaultProp.getProperty(name);
                }
            });
            this.resolveFullLibraryDependencies(dependencies, outLibraries);
            if (outLibraries.contains(library)) continue;
            outLibraries.add(0, library);
        }
    }

    private ArrayList<File> getDirectDependencies(File baseFolder, IPropertySource source) {
        String propName;
        String rootPath;
        ArrayList<File> libraries = new ArrayList<File>();
        int index = 1;
        while ((rootPath = source.getProperty(propName = "android.library.reference." + Integer.toString(index++))) != null) {
            try {
                File library = new File(baseFolder, rootPath).getCanonicalFile();
                File defaultProp = new File(library, ProjectProperties.PropertyType.DEFAULT.getFilename());
                if (!defaultProp.isFile()) {
                    throw new BuildException(String.format("%1$s resolve to a path with no %2$s file for project %3$s", rootPath, ProjectProperties.PropertyType.DEFAULT.getFilename(), baseFolder.getAbsolutePath()));
                }
                if (libraries.contains(library)) continue;
                System.out.println(String.format("%1$s: %2$s => %3$s", baseFolder.getAbsolutePath(), rootPath, library.getAbsolutePath()));
                libraries.add(library);
            }
            catch (IOException e) {
                throw new BuildException("Failed to resolve library path: " + rootPath, (Throwable)e);
            }
        }
        return libraries;
    }

    public static interface IPropertySource {
        public String getProperty(String var1);
    }
}

