/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class ClassRenamer
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor {
    public void visitProgramClass(ProgramClass programClass) {
        programClass.thisClassConstantAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.thisClassName = ClassObfuscator.newClassName(libraryClass);
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        String string = programMember.getName(programClass);
        String string2 = MemberObfuscator.newMemberName(programMember);
        if (string2 != null && !string2.equals(string)) {
            programMember.u2nameIndex = new ConstantPoolEditor(programClass).addUtf8Constant(string2);
        }
    }

    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        String string = MemberObfuscator.newMemberName(libraryMember);
        if (string != null) {
            libraryMember.name = string;
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String string = ClassObfuscator.newClassName(clazz);
        if (string != null) {
            classConstant.u2nameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
    }
}

