/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmuilib.TablePanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class SysinfoPanel
extends TablePanel
implements IShellOutputReceiver {
    private Label mLabel;
    private Button mFetchButton;
    private Combo mDisplayMode;
    private DefaultPieDataset mDataset;
    private File mDataFile;
    private FileOutputStream mTempStream;
    private int mMode = 0;
    private static final int MODE_CPU = 0;
    private static final int MODE_ALARM = 1;
    private static final int MODE_WAKELOCK = 2;
    private static final int MODE_MEMINFO = 3;
    private static final int MODE_SYNC = 4;
    private static final String[] BUGREPORT_SECTION = new String[]{"cpuinfo", "alarm", "batteryinfo", "MEMORY INFO", "content"};
    private static final String[] DUMP_COMMAND = new String[]{"dumpsys cpuinfo", "dumpsys alarm", "dumpsys batteryinfo", "cat /proc/meminfo ; procrank", "dumpsys content"};
    private static final String[] CAPTIONS = new String[]{"CPU load", "Alarms", "Wakelocks", "Memory usage", "Sync"};

    public void generateDataset(File file) {
        this.mDataset.clear();
        this.mLabel.setText("");
        if (file == null) {
            return;
        }
        try {
            BufferedReader br = this.getBugreportReader(file);
            if (this.mMode == 0) {
                this.readCpuDataset(br);
            } else if (this.mMode == 1) {
                this.readAlarmDataset(br);
            } else if (this.mMode == 2) {
                this.readWakelockDataset(br);
            } else if (this.mMode == 3) {
                this.readMeminfoDataset(br);
            } else if (this.mMode == 4) {
                this.readSyncDataset(br);
            }
        }
        catch (IOException e) {
            Log.e((String)"DDMS", (Throwable)e);
        }
    }

    public void deviceSelected() {
        if (this.getCurrentDevice() != null) {
            this.mFetchButton.setEnabled(true);
            this.loadFromDevice();
        } else {
            this.mFetchButton.setEnabled(false);
        }
    }

    public void clientSelected() {
    }

    public void setFocus() {
        this.mDisplayMode.setFocus();
    }

    private void loadFromDevice() {
        try {
            this.initShellOutputBuffer();
            if (this.mMode == 3) {
                this.mTempStream.write("------ MEMORY INFO ------\n".getBytes());
            }
            this.getCurrentDevice().executeShellCommand(DUMP_COMMAND[this.mMode], (IShellOutputReceiver)this);
        }
        catch (IOException e) {
            Log.e((String)"DDMS", (Throwable)e);
        }
        catch (TimeoutException e) {
            Log.e((String)"DDMS", (Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            Log.e((String)"DDMS", (Throwable)e);
        }
        catch (ShellCommandUnresponsiveException e) {
            Log.e((String)"DDMS", (Throwable)e);
        }
    }

    void initShellOutputBuffer() throws IOException {
        this.mDataFile = File.createTempFile("ddmsfile", ".txt");
        this.mDataFile.deleteOnExit();
        this.mTempStream = new FileOutputStream(this.mDataFile);
    }

    public void addOutput(byte[] data, int offset, int length) {
        try {
            this.mTempStream.write(data, offset, length);
        }
        catch (IOException e) {
            Log.e((String)"DDMS", (Throwable)e);
        }
    }

    public void flush() {
        if (this.mTempStream != null) {
            try {
                this.mTempStream.close();
                this.generateDataset(this.mDataFile);
                this.mTempStream = null;
                this.mDataFile = null;
            }
            catch (IOException e) {
                Log.e((String)"DDMS", (Throwable)e);
            }
        }
    }

    public boolean isCancelled() {
        return false;
    }

    protected Control createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        top.setLayoutData((Object)new GridData(1808));
        Composite buttons = new Composite(top, 0);
        buttons.setLayout((Layout)new RowLayout());
        this.mDisplayMode = new Combo(buttons, 8);
        for (String mode : CAPTIONS) {
            this.mDisplayMode.add(mode);
        }
        this.mDisplayMode.select(this.mMode);
        this.mDisplayMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SysinfoPanel.this.mMode = SysinfoPanel.this.mDisplayMode.getSelectionIndex();
                if (SysinfoPanel.this.mDataFile != null) {
                    SysinfoPanel.this.generateDataset(SysinfoPanel.this.mDataFile);
                } else if (SysinfoPanel.this.getCurrentDevice() != null) {
                    SysinfoPanel.this.loadFromDevice();
                }
            }
        });
        final Button loadButton = new Button(buttons, 8);
        loadButton.setText("Load from File");
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(loadButton.getShell(), 4096);
                fileDialog.setText("Load bugreport");
                String filename = fileDialog.open();
                if (filename != null) {
                    SysinfoPanel.this.mDataFile = new File(filename);
                    SysinfoPanel.this.generateDataset(SysinfoPanel.this.mDataFile);
                }
            }
        });
        this.mFetchButton = new Button(buttons, 8);
        this.mFetchButton.setText("Update from Device");
        this.mFetchButton.setEnabled(false);
        this.mFetchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SysinfoPanel.this.loadFromDevice();
            }
        });
        this.mLabel = new Label(top, 0);
        this.mLabel.setLayoutData((Object)new GridData(768));
        this.mDataset = new DefaultPieDataset();
        JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)this.mDataset, (boolean)false, (boolean)true, (boolean)false);
        ChartComposite chartComposite = new ChartComposite(top, 2048, chart, 420, 420, 300, 200, 3000, 3000, true, true, true, true, false, true);
        chartComposite.setLayoutData((Object)new GridData(1808));
        return top;
    }

    public void clientChanged(Client client, int changeMask) {
    }

    private BufferedReader getBugreportReader(File file) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(file));
        do {
            if ((line = br.readLine()) != null) continue;
            Log.d((String)"DDMS", (String)("Service not found " + line));
            break;
        } while (!line.startsWith("DUMP OF SERVICE ") && !line.startsWith("-----") || line.indexOf(BUGREPORT_SECTION[this.mMode]) <= 0);
        return br;
    }

    private static long parseTimeMs(String s) {
        long total = 0L;
        Pattern p = Pattern.compile("([\\d\\.]+)\\s*([a-z]+)");
        Matcher m = p.matcher(s);
        while (m.find()) {
            String label = m.group(2);
            if ("sec".equals(label)) {
                total += (long)(Double.parseDouble(m.group(1)) * 1000.0);
                continue;
            }
            long value = Integer.parseInt(m.group(1));
            if ("d".equals(label)) {
                total += value * 24L * 60L * 60L * 1000L;
                continue;
            }
            if ("h".equals(label)) {
                total += value * 60L * 60L * 1000L;
                continue;
            }
            if ("m".equals(label)) {
                total += value * 60L * 1000L;
                continue;
            }
            if ("s".equals(label)) {
                total += value * 1000L;
                continue;
            }
            if (!"ms".equals(label)) continue;
            total += value;
        }
        return total;
    }

    void readWakelockDataset(BufferedReader br) throws IOException {
        String line;
        Pattern lockPattern = Pattern.compile("Wake lock (\\S+): (.+) partial");
        Pattern totalPattern = Pattern.compile("Total: (.+) uptime");
        double total = 0.0;
        boolean inCurrent = false;
        while ((line = br.readLine()) != null && !line.startsWith("DUMP OF SERVICE")) {
            if (line.startsWith("Current Battery Usage Statistics")) {
                inCurrent = true;
                continue;
            }
            if (!inCurrent) continue;
            Matcher m = lockPattern.matcher(line);
            if (m.find()) {
                double value = (double)SysinfoPanel.parseTimeMs(m.group(2)) / 1000.0;
                this.mDataset.setValue((Comparable)((Object)m.group(1)), value);
                total -= value;
                continue;
            }
            m = totalPattern.matcher(line);
            if (!m.find()) continue;
            total += (double)SysinfoPanel.parseTimeMs(m.group(1)) / 1000.0;
        }
        if (total > 0.0) {
            this.mDataset.setValue((Comparable)((Object)"Unlocked"), total);
        }
    }

    void readAlarmDataset(BufferedReader br) throws IOException {
        String line;
        Pattern pattern = Pattern.compile("(\\d+) alarms: Intent .*\\.([^. ]+) flags");
        while ((line = br.readLine()) != null && !line.startsWith("DUMP OF SERVICE")) {
            Matcher m = pattern.matcher(line);
            if (!m.find()) continue;
            long count = Long.parseLong(m.group(1));
            String name = m.group(2);
            this.mDataset.setValue((Comparable)((Object)name), (double)count);
        }
    }

    void readCpuDataset(BufferedReader br) throws IOException {
        String line;
        Pattern pattern = Pattern.compile("(\\S+): (\\S+)% = (.+)% user . (.+)% kernel");
        while ((line = br.readLine()) != null && !line.startsWith("DUMP OF SERVICE")) {
            if (line.startsWith("Load:")) {
                this.mLabel.setText(line);
                continue;
            }
            Matcher m = pattern.matcher(line);
            if (!m.find()) continue;
            String name = m.group(1);
            long both = Long.parseLong(m.group(2));
            long user = Long.parseLong(m.group(3));
            long kernel = Long.parseLong(m.group(4));
            if ("TOTAL".equals(name)) {
                if (both >= 100L) continue;
                this.mDataset.setValue((Comparable)((Object)"Idle"), (double)(100L - both));
                continue;
            }
            if (user > 0L) {
                this.mDataset.setValue((Comparable)((Object)(name + " (user)")), (double)user);
            }
            if (kernel > 0L) {
                this.mDataset.setValue((Comparable)((Object)(name + " (kernel)")), (double)(both - user));
            }
            if (user != 0L || kernel != 0L || both <= 0L) continue;
            this.mDataset.setValue((Comparable)((Object)name), (double)both);
        }
    }

    void readMeminfoDataset(BufferedReader br) throws IOException {
        Matcher m;
        String line;
        Pattern valuePattern = Pattern.compile("(\\d+) kB");
        long total = 0L;
        long other = 0L;
        this.mLabel.setText("PSS in kB");
        while ((line = br.readLine()) != null && (m = valuePattern.matcher(line)).find()) {
            long kb = Long.parseLong(m.group(1));
            if (line.startsWith("MemTotal")) {
                total = kb;
                continue;
            }
            if (line.startsWith("MemFree")) {
                this.mDataset.setValue((Comparable)((Object)"Free"), (double)kb);
                total -= kb;
                continue;
            }
            if (line.startsWith("Slab")) {
                this.mDataset.setValue((Comparable)((Object)"Slab"), (double)kb);
                total -= kb;
                continue;
            }
            if (line.startsWith("PageTables")) {
                this.mDataset.setValue((Comparable)((Object)"PageTables"), (double)kb);
                total -= kb;
                continue;
            }
            if (line.startsWith("Buffers") && kb > 0L) {
                this.mDataset.setValue((Comparable)((Object)"Buffers"), (double)kb);
                total -= kb;
                continue;
            }
            if (line.startsWith("Inactive")) {
                this.mDataset.setValue((Comparable)((Object)"Inactive"), (double)kb);
                total -= kb;
                continue;
            }
            if (!line.startsWith("MemFree")) continue;
            this.mDataset.setValue((Comparable)((Object)"Free"), (double)kb);
            total -= kb;
        }
        while ((line = br.readLine()) != null) {
            if (line.indexOf("PROCRANK") >= 0 || line.indexOf("PID") >= 0) continue;
            if (line.indexOf("----") >= 0) break;
            long pss = Long.parseLong(line.substring(23, 31).trim());
            String cmdline = line.substring(43).trim().replace("/system/bin/", "");
            if (pss > 2000L) {
                this.mDataset.setValue((Comparable)((Object)cmdline), (double)pss);
            } else {
                other += pss;
            }
            total -= pss;
        }
        this.mDataset.setValue((Comparable)((Object)"Other"), (double)other);
        this.mDataset.setValue((Comparable)((Object)"Unknown"), (double)total);
    }

    void readSyncDataset(BufferedReader br) throws IOException {
        String line;
        while ((line = br.readLine()) != null && !line.startsWith("DUMP OF SERVICE")) {
            long dur;
            if (!line.startsWith(" |") || line.length() <= 70) continue;
            String authority = line.substring(3, 18).trim();
            String duration = line.substring(61, 70).trim();
            String[] durParts = duration.split(":");
            if (durParts.length == 2) {
                dur = Long.parseLong(durParts[0]) * 60L + Long.parseLong(durParts[1]);
                this.mDataset.setValue((Comparable)((Object)authority), (double)dur);
                continue;
            }
            if (duration.length() != 3) continue;
            dur = Long.parseLong(durParts[0]) * 3600L + Long.parseLong(durParts[1]) * 60L + Long.parseLong(durParts[2]);
            this.mDataset.setValue((Comparable)((Object)authority), (double)dur);
        }
    }
}

