/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.util;

import com.android.hierarchyviewerlib.actions.ImageAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ActionButton
implements IPropertyChangeListener,
SelectionListener {
    private Button mButton;
    private Action mAction;

    public ActionButton(Composite parent, ImageAction action) {
        this.mAction = (Action)action;
        this.mButton = this.mAction.getStyle() == 2 ? new Button(parent, 32) : new Button(parent, 8);
        this.mButton.setText(action.getText());
        this.mButton.setImage(action.getImage());
        this.mAction.addPropertyChangeListener((IPropertyChangeListener)this);
        this.mButton.addSelectionListener((SelectionListener)this);
        this.mButton.setToolTipText(action.getToolTipText());
        this.mButton.setEnabled(this.mAction.isEnabled());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getProperty().toUpperCase().equals("ENABLED")) {
            this.mButton.setEnabled(((Boolean)e.getNewValue()).booleanValue());
        } else if (e.getProperty().toUpperCase().equals("CHECKED")) {
            this.mButton.setSelection(this.mAction.isChecked());
        }
    }

    public void setLayoutData(Object data) {
        this.mButton.setLayoutData(data);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.mAction.getStyle() == 2) {
            this.mAction.setChecked(this.mButton.getSelection());
        }
        this.mAction.run();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.mButton.addSelectionListener(listener);
    }
}

