/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;

public class TreeViewControls
extends Composite
implements TreeViewModel.ITreeChangeListener {
    private Text mFilterText;
    private Slider mZoomSlider;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            TreeViewModel.getModel().removeTreeChangeListener(TreeViewControls.this);
        }
    };
    private SelectionListener mZoomSliderSelectionListener = new SelectionListener(){
        private int oldValue;

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int newValue = TreeViewControls.this.mZoomSlider.getSelection();
            if (this.oldValue != newValue) {
                TreeViewModel.getModel().removeTreeChangeListener(TreeViewControls.this);
                TreeViewModel.getModel().setZoom((double)newValue / 10.0);
                TreeViewModel.getModel().addTreeChangeListener(TreeViewControls.this);
                this.oldValue = newValue;
            }
        }
    };
    private ModifyListener mFilterTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            HierarchyViewerDirector.getDirector().filterNodes(TreeViewControls.this.mFilterText.getText());
        }
    };

    public TreeViewControls(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout(5, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        this.setLayout((Layout)layout);
        Label filterLabel = new Label((Composite)this, 0);
        filterLabel.setText("Filter by class or id:");
        filterLabel.setLayoutData((Object)new GridData(1, 2, false, true));
        this.mFilterText = new Text((Composite)this, 16388);
        this.mFilterText.setLayoutData((Object)new GridData(768));
        this.mFilterText.addModifyListener(this.mFilterTextModifyListener);
        this.mFilterText.setText(HierarchyViewerDirector.getDirector().getFilterText());
        Label smallZoomLabel = new Label((Composite)this, 0);
        smallZoomLabel.setText(" 20%");
        smallZoomLabel.setLayoutData((Object)new GridData(1, 2, false, true));
        this.mZoomSlider = new Slider((Composite)this, 256);
        GridData zoomSliderGridData = new GridData(2, 2, false, false);
        zoomSliderGridData.widthHint = 190;
        this.mZoomSlider.setLayoutData((Object)zoomSliderGridData);
        this.mZoomSlider.setMinimum(2);
        this.mZoomSlider.setMaximum(21);
        this.mZoomSlider.setThumb(1);
        this.mZoomSlider.setSelection((int)Math.round(TreeViewModel.getModel().getZoom() * 10.0));
        this.mZoomSlider.addSelectionListener(this.mZoomSliderSelectionListener);
        Label largeZoomLabel = new Label((Composite)this, 0);
        largeZoomLabel.setLayoutData((Object)new GridData(1, 2, false, true));
        largeZoomLabel.setText("200%");
        this.addDisposeListener(this.mDisposeListener);
        TreeViewModel.getModel().addTreeChangeListener(this);
    }

    public void selectionChanged() {
    }

    public void treeChanged() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (TreeViewModel.getModel().getTree() != null) {
                    TreeViewControls.this.mZoomSlider.setSelection((int)Math.round(TreeViewModel.getModel().getZoom() * 10.0));
                }
                TreeViewControls.this.mFilterText.setText("");
            }
        });
    }

    public void viewportChanged() {
    }

    public void zoomChanged() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TreeViewControls.this.mZoomSlider.setSelection((int)Math.round(TreeViewModel.getModel().getZoom() * 10.0));
            }
        });
    }
}

