/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.models;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewerlib.device.ViewNode;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class PixelPerfectModel {
    public static final int MIN_ZOOM = 2;
    public static final int MAX_ZOOM = 24;
    public static final int DEFAULT_ZOOM = 8;
    public static final int DEFAULT_OVERLAY_TRANSPARENCY_PERCENTAGE = 50;
    private IDevice mDevice;
    private Image mImage;
    private Point mCrosshairLocation;
    private ViewNode mViewNode;
    private ViewNode mSelectedNode;
    private int mZoom;
    private final ArrayList<IImageChangeListener> mImageChangeListeners = new ArrayList();
    private Image mOverlayImage;
    private double mOverlayTransparency = 0.5;
    private static PixelPerfectModel sModel;

    public static PixelPerfectModel getModel() {
        if (sModel == null) {
            sModel = new PixelPerfectModel();
        }
        return sModel;
    }

    public void setData(final IDevice device, final Image image, final ViewNode viewNode) {
        final Image toDispose = this.mImage;
        final Image toDispose2 = this.mOverlayImage;
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PixelPerfectModel pixelPerfectModel = PixelPerfectModel.this;
                synchronized (pixelPerfectModel) {
                    PixelPerfectModel.this.mDevice = device;
                    PixelPerfectModel.this.mImage = image;
                    PixelPerfectModel.this.mViewNode = viewNode;
                    if (image != null) {
                        PixelPerfectModel.this.mCrosshairLocation = new Point(image.getBounds().width / 2, image.getBounds().height / 2);
                    } else {
                        PixelPerfectModel.this.mCrosshairLocation = null;
                    }
                    PixelPerfectModel.this.mOverlayImage = null;
                    PixelPerfectModel.this.mSelectedNode = null;
                    PixelPerfectModel.this.mZoom = 8;
                }
            }
        });
        this.notifyImageLoaded();
        if (toDispose != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    toDispose.dispose();
                }
            });
        }
        if (toDispose2 != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    toDispose2.dispose();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrosshairLocation(int x, int y) {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            this.mCrosshairLocation = new Point(x, y);
        }
        this.notifyCrosshairMoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(ViewNode selected) {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            this.mSelectedNode = selected;
        }
        this.notifySelectionChanged();
    }

    public void setTree(final ViewNode viewNode) {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PixelPerfectModel pixelPerfectModel = PixelPerfectModel.this;
                synchronized (pixelPerfectModel) {
                    PixelPerfectModel.this.mViewNode = viewNode;
                    PixelPerfectModel.this.mSelectedNode = null;
                }
            }
        });
        this.notifyTreeChanged();
    }

    public void setImage(final Image image) {
        final Image toDispose = this.mImage;
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PixelPerfectModel pixelPerfectModel = PixelPerfectModel.this;
                synchronized (pixelPerfectModel) {
                    PixelPerfectModel.this.mImage = image;
                }
            }
        });
        this.notifyImageChanged();
        if (toDispose != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    toDispose.dispose();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoom(int newZoom) {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            if (newZoom < 2) {
                newZoom = 2;
            }
            if (newZoom > 24) {
                newZoom = 24;
            }
            this.mZoom = newZoom;
        }
        this.notifyZoomChanged();
    }

    public void setOverlayImage(final Image overlayImage) {
        final Image toDispose = this.mOverlayImage;
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PixelPerfectModel pixelPerfectModel = PixelPerfectModel.this;
                synchronized (pixelPerfectModel) {
                    PixelPerfectModel.this.mOverlayImage = overlayImage;
                }
            }
        });
        this.notifyOverlayChanged();
        if (toDispose != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    toDispose.dispose();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverlayTransparency(double value) {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            value = Math.max(value, 0.0);
            this.mOverlayTransparency = value = Math.min(value, 1.0);
        }
        this.notifyOverlayTransparencyChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewNode getViewNode() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mViewNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getCrosshairLocation() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mCrosshairLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewNode getSelected() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mSelectedNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice getDevice() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getZoom() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mZoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getOverlayImage() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mOverlayImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getOverlayTransparency() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mOverlayTransparency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImageChangeListener[] getImageChangeListenerList() {
        IImageChangeListener[] listeners = null;
        ArrayList<IImageChangeListener> arrayList = this.mImageChangeListeners;
        synchronized (arrayList) {
            if (this.mImageChangeListeners.size() == 0) {
                return null;
            }
            listeners = this.mImageChangeListeners.toArray(new IImageChangeListener[this.mImageChangeListeners.size()]);
        }
        return listeners;
    }

    public void notifyImageLoaded() {
        IImageChangeListener[] listeners = this.getImageChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].imageLoaded();
            }
        }
    }

    public void notifyImageChanged() {
        IImageChangeListener[] listeners = this.getImageChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].imageChanged();
            }
        }
    }

    public void notifyCrosshairMoved() {
        IImageChangeListener[] listeners = this.getImageChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].crosshairMoved();
            }
        }
    }

    public void notifySelectionChanged() {
        IImageChangeListener[] listeners = this.getImageChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].selectionChanged();
            }
        }
    }

    public void notifyTreeChanged() {
        IImageChangeListener[] listeners = this.getImageChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].treeChanged();
            }
        }
    }

    public void notifyZoomChanged() {
        IImageChangeListener[] listeners = this.getImageChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].zoomChanged();
            }
        }
    }

    public void notifyOverlayChanged() {
        IImageChangeListener[] listeners = this.getImageChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].overlayChanged();
            }
        }
    }

    public void notifyOverlayTransparencyChanged() {
        IImageChangeListener[] listeners = this.getImageChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].overlayTransparencyChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageChangeListener(IImageChangeListener listener) {
        ArrayList<IImageChangeListener> arrayList = this.mImageChangeListeners;
        synchronized (arrayList) {
            this.mImageChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageChangeListener(IImageChangeListener listener) {
        ArrayList<IImageChangeListener> arrayList = this.mImageChangeListeners;
        synchronized (arrayList) {
            this.mImageChangeListeners.remove(listener);
        }
    }

    public static interface IImageChangeListener {
        public void imageLoaded();

        public void imageChanged();

        public void crosshairMoved();

        public void selectionChanged();

        public void treeChanged();

        public void zoomChanged();

        public void overlayChanged();

        public void overlayTransparencyChanged();
    }
}

