/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.device;

import com.android.hierarchyviewerlib.device.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.graphics.Image;

public class ViewNode {
    private static final double RED_THRESHOLD = 0.8;
    private static final double YELLOW_THRESHOLD = 0.5;
    public static final String MISCELLANIOUS = "miscellaneous";
    public String id;
    public String name;
    public String hashCode;
    public List<Property> properties = new ArrayList<Property>();
    public Map<String, Property> namedProperties = new HashMap<String, Property>();
    public ViewNode parent;
    public List<ViewNode> children = new ArrayList<ViewNode>();
    public int left;
    public int top;
    public int width;
    public int height;
    public int scrollX;
    public int scrollY;
    public int paddingLeft;
    public int paddingRight;
    public int paddingTop;
    public int paddingBottom;
    public int marginLeft;
    public int marginRight;
    public int marginTop;
    public int marginBottom;
    public int baseline;
    public boolean willNotDraw;
    public boolean hasMargins;
    public boolean hasFocus;
    public int index;
    public double measureTime;
    public double layoutTime;
    public double drawTime;
    public ProfileRating measureRating = ProfileRating.NONE;
    public ProfileRating layoutRating = ProfileRating.NONE;
    public ProfileRating drawRating = ProfileRating.NONE;
    public Set<String> categories = new TreeSet<String>();
    public Window window;
    public Image image;
    public int imageReferences = 1;
    public int viewCount;
    public boolean filtered;
    public int protocolVersion;

    public ViewNode(Window window, ViewNode parent, String data) {
        this.window = window;
        this.parent = parent;
        int n = this.index = this.parent == null ? 0 : this.parent.children.size();
        if (this.parent != null) {
            this.parent.children.add(this);
        }
        int delimIndex = data.indexOf(64);
        this.name = data.substring(0, delimIndex);
        data = data.substring(delimIndex + 1);
        delimIndex = data.indexOf(32);
        this.hashCode = data.substring(0, delimIndex);
        this.loadProperties(data.substring(delimIndex + 1).trim());
        this.measureTime = -1.0;
        this.layoutTime = -1.0;
        this.drawTime = -1.0;
    }

    public void dispose() {
        int N = this.children.size();
        for (int i = 0; i < N; ++i) {
            this.children.get(i).dispose();
        }
        this.dereferenceImage();
    }

    public void referenceImage() {
        ++this.imageReferences;
    }

    public void dereferenceImage() {
        --this.imageReferences;
        if (this.image != null && this.imageReferences == 0) {
            this.image.dispose();
        }
    }

    private void loadProperties(String data) {
        boolean stop;
        int start = 0;
        do {
            int index = data.indexOf(61, start);
            Property property = new Property();
            property.name = data.substring(start, index);
            int index2 = data.indexOf(44, index + 1);
            int length = Integer.parseInt(data.substring(index + 1, index2));
            start = index2 + 1 + length;
            property.value = data.substring(index2 + 1, index2 + 1 + length);
            this.properties.add(property);
            this.namedProperties.put(property.name, property);
            boolean bl = stop = start >= data.length();
            if (stop) continue;
            ++start;
        } while (!stop);
        Collections.sort(this.properties, new Comparator<Property>(){

            @Override
            public int compare(Property source, Property destination) {
                return source.name.compareTo(destination.name);
            }
        });
        this.id = this.namedProperties.get((Object)"mID").value;
        this.left = this.namedProperties.containsKey("mLeft") ? this.getInt("mLeft", 0) : this.getInt("layout:mLeft", 0);
        this.top = this.namedProperties.containsKey("mTop") ? this.getInt("mTop", 0) : this.getInt("layout:mTop", 0);
        this.width = this.namedProperties.containsKey("getWidth()") ? this.getInt("getWidth()", 0) : this.getInt("layout:getWidth()", 0);
        this.height = this.namedProperties.containsKey("getHeight()") ? this.getInt("getHeight()", 0) : this.getInt("layout:getHeight()", 0);
        this.scrollX = this.namedProperties.containsKey("mScrollX") ? this.getInt("mScrollX", 0) : this.getInt("scrolling:mScrollX", 0);
        this.scrollY = this.namedProperties.containsKey("mScrollY") ? this.getInt("mScrollY", 0) : this.getInt("scrolling:mScrollY", 0);
        this.paddingLeft = this.namedProperties.containsKey("mPaddingLeft") ? this.getInt("mPaddingLeft", 0) : this.getInt("padding:mPaddingLeft", 0);
        this.paddingRight = this.namedProperties.containsKey("mPaddingRight") ? this.getInt("mPaddingRight", 0) : this.getInt("padding:mPaddingRight", 0);
        this.paddingTop = this.namedProperties.containsKey("mPaddingTop") ? this.getInt("mPaddingTop", 0) : this.getInt("padding:mPaddingTop", 0);
        this.paddingBottom = this.namedProperties.containsKey("mPaddingBottom") ? this.getInt("mPaddingBottom", 0) : this.getInt("padding:mPaddingBottom", 0);
        this.marginLeft = this.namedProperties.containsKey("layout_leftMargin") ? this.getInt("layout_leftMargin", Integer.MIN_VALUE) : this.getInt("layout:layout_leftMargin", Integer.MIN_VALUE);
        this.marginRight = this.namedProperties.containsKey("layout_rightMargin") ? this.getInt("layout_rightMargin", Integer.MIN_VALUE) : this.getInt("layout:layout_rightMargin", Integer.MIN_VALUE);
        this.marginTop = this.namedProperties.containsKey("layout_topMargin") ? this.getInt("layout_topMargin", Integer.MIN_VALUE) : this.getInt("layout:layout_topMargin", Integer.MIN_VALUE);
        this.marginBottom = this.namedProperties.containsKey("layout_bottomMargin") ? this.getInt("layout_bottomMargin", Integer.MIN_VALUE) : this.getInt("layout:layout_bottomMargin", Integer.MIN_VALUE);
        this.baseline = this.namedProperties.containsKey("getBaseline()") ? this.getInt("getBaseline()", 0) : this.getInt("layout:getBaseline()", 0);
        this.willNotDraw = this.namedProperties.containsKey("willNotDraw()") ? this.getBoolean("willNotDraw()", false) : this.getBoolean("drawing:willNotDraw()", false);
        this.hasFocus = this.namedProperties.containsKey("hasFocus()") ? this.getBoolean("hasFocus()", false) : this.getBoolean("focus:hasFocus()", false);
        this.hasMargins = this.marginLeft != Integer.MIN_VALUE && this.marginRight != Integer.MIN_VALUE && this.marginTop != Integer.MIN_VALUE && this.marginBottom != Integer.MIN_VALUE;
        for (String name : this.namedProperties.keySet()) {
            int index = name.indexOf(58);
            if (index == -1) continue;
            this.categories.add(name.substring(0, index));
        }
        if (this.categories.size() != 0) {
            this.categories.add(MISCELLANIOUS);
        }
    }

    public void setProfileRatings() {
        int N = this.children.size();
        if (N > 1) {
            ViewNode child;
            int i;
            double totalMeasure = 0.0;
            double totalLayout = 0.0;
            double totalDraw = 0.0;
            for (i = 0; i < N; ++i) {
                child = this.children.get(i);
                totalMeasure += child.measureTime;
                totalLayout += child.layoutTime;
                totalDraw += child.drawTime;
            }
            for (i = 0; i < N; ++i) {
                child = this.children.get(i);
                child.measureRating = child.measureTime / totalMeasure >= 0.8 ? ProfileRating.RED : (child.measureTime / totalMeasure >= 0.5 ? ProfileRating.YELLOW : ProfileRating.GREEN);
                child.layoutRating = child.layoutTime / totalLayout >= 0.8 ? ProfileRating.RED : (child.layoutTime / totalLayout >= 0.5 ? ProfileRating.YELLOW : ProfileRating.GREEN);
                child.drawRating = child.drawTime / totalDraw >= 0.8 ? ProfileRating.RED : (child.drawTime / totalDraw >= 0.5 ? ProfileRating.YELLOW : ProfileRating.GREEN);
            }
        }
        for (int i = 0; i < N; ++i) {
            this.children.get(i).setProfileRatings();
        }
    }

    public void setViewCount() {
        this.viewCount = 1;
        int N = this.children.size();
        for (int i = 0; i < N; ++i) {
            ViewNode child = this.children.get(i);
            child.setViewCount();
            this.viewCount += child.viewCount;
        }
    }

    public void filter(String text) {
        int dotIndex = this.name.lastIndexOf(46);
        String shortName = dotIndex == -1 ? this.name : this.name.substring(dotIndex + 1);
        this.filtered = !text.equals("") && (shortName.toLowerCase().contains(text.toLowerCase()) || !this.id.equals("NO_ID") && this.id.toLowerCase().contains(text.toLowerCase()));
        int N = this.children.size();
        for (int i = 0; i < N; ++i) {
            this.children.get(i).filter(text);
        }
    }

    private boolean getBoolean(String name, boolean defaultValue) {
        Property p = this.namedProperties.get(name);
        if (p != null) {
            try {
                return Boolean.parseBoolean(p.value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private int getInt(String name, int defaultValue) {
        Property p = this.namedProperties.get(name);
        if (p != null) {
            try {
                return Integer.parseInt(p.value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String toString() {
        return this.name + "@" + this.hashCode;
    }

    public static class Property {
        public String name;
        public String value;

        public String toString() {
            return this.name + '=' + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProfileRating {
        RED,
        YELLOW,
        GREEN,
        NONE;

    }
}

