/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.actions;

import com.android.ddmlib.IDevice;
import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.actions.ImageAction;
import com.android.hierarchyviewerlib.device.Window;
import com.android.hierarchyviewerlib.models.DeviceSelectionModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class LoadViewHierarchyAction
extends Action
implements ImageAction,
DeviceSelectionModel.IWindowChangeListener {
    private static LoadViewHierarchyAction sAction;
    private Image mImage;

    private LoadViewHierarchyAction() {
        super("Load View &Hierarchy");
        this.setAccelerator(SWT.MOD1 + 72);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        this.mImage = imageLoader.loadImage("load-view-hierarchy.png", Display.getDefault());
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.mImage));
        this.setToolTipText("Load the view hierarchy into the tree view");
        this.setEnabled(DeviceSelectionModel.getModel().getSelectedWindow() != null);
        DeviceSelectionModel.getModel().addWindowChangeListener(this);
    }

    public static LoadViewHierarchyAction getAction() {
        if (sAction == null) {
            sAction = new LoadViewHierarchyAction();
        }
        return sAction;
    }

    public void run() {
        HierarchyViewerDirector.getDirector().loadViewHierarchy();
    }

    public Image getImage() {
        return this.mImage;
    }

    public void deviceChanged(IDevice device) {
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
    }

    public void focusChanged(IDevice device) {
    }

    public void selectionChanged(IDevice device, final Window window) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                LoadViewHierarchyAction.getAction().setEnabled(window != null);
            }
        });
    }
}

