/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutopt.uix.rules;

import com.android.layoutopt.uix.LayoutAnalysis;
import com.android.layoutopt.uix.groovy.LayoutAnalysisCategory;
import com.android.layoutopt.uix.rules.Rule;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.Script;
import groovy.xml.dom.DOMCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.w3c.dom.Node;

public class GroovyRule
implements Rule {
    private final String mName;
    private final Script mScript;
    private final Binding mBinding;
    private final Closure mClosure;
    private final List<Class> mCategories;

    public GroovyRule(String name, Script script) {
        this.mName = name;
        this.mScript = script;
        this.mBinding = new Binding();
        this.mScript.setBinding(this.mBinding);
        this.mClosure = new Closure(this){

            public Object call() {
                return GroovyRule.this.mScript.run();
            }
        };
        this.mCategories = new ArrayList<Class>();
        Collections.addAll(this.mCategories, DOMCategory.class, LayoutAnalysisCategory.class);
    }

    public String getName() {
        return this.mName;
    }

    public void run(LayoutAnalysis analysis, Node node) {
        this.mBinding.setVariable("analysis", (Object)analysis);
        this.mBinding.setVariable("node", (Object)node);
        GroovyCategorySupport.use(this.mCategories, (Closure)this.mClosure);
    }
}

