/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutopt.uix;

import com.android.layoutopt.uix.LayoutAnalysis;
import com.android.layoutopt.uix.rules.GroovyRule;
import com.android.layoutopt.uix.rules.Rule;
import com.android.layoutopt.uix.util.IOUtilities;
import com.android.layoutopt.uix.xml.XmlDocumentBuilder;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LayoutAnalyzer {
    private static final String RULES_PREFIX = "rules/";
    private final XmlDocumentBuilder mBuilder = new XmlDocumentBuilder();
    private final List<Rule> mRules = new ArrayList<Rule>();

    public LayoutAnalyzer() {
        this.loadRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRules() {
        ClassLoader parent = this.getClass().getClassLoader();
        GroovyClassLoader loader = new GroovyClassLoader(parent);
        GroovyShell shell = new GroovyShell((ClassLoader)loader);
        URL jar = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        ZipFile zip = null;
        try {
            zip = new ZipFile(new File(jar.toURI()));
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().startsWith(RULES_PREFIX)) continue;
                this.loadRule(shell, entry.getName(), zip.getInputStream(entry));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRule(GroovyShell shell, String name, InputStream stream) {
        try {
            Script script = shell.parse(stream);
            this.mRules.add(new GroovyRule(name, script));
        }
        catch (Exception e) {
            System.err.println("Could not load rule " + name + ":");
            e.printStackTrace();
        }
        finally {
            IOUtilities.close(stream);
        }
    }

    public void addRule(Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("A rule must be non-null");
        }
        this.mRules.add(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public LayoutAnalysis analyze(File file) {
        if (file != null && file.exists()) {
            LayoutAnalysis layoutAnalysis;
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                layoutAnalysis = this.analyze(file.getPath(), in);
            }
            catch (FileNotFoundException fileNotFoundException) {
                IOUtilities.close(in);
                catch (Throwable throwable) {
                    IOUtilities.close(in);
                    throw throwable;
                }
            }
            IOUtilities.close(in);
            return layoutAnalysis;
        }
        return LayoutAnalysis.ERROR;
    }

    public LayoutAnalysis analyze(InputStream stream) {
        return this.analyze("<unknown>", stream);
    }

    private LayoutAnalysis analyze(String name, InputStream stream) {
        try {
            Document document = this.mBuilder.parse(stream);
            return this.analyze(name, document);
        }
        catch (SAXException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return LayoutAnalysis.ERROR;
    }

    public LayoutAnalysis analyze(String content) {
        return this.analyze("<unknown>", content);
    }

    public LayoutAnalysis analyze(String name, String content) {
        try {
            Document document = this.mBuilder.parse(content);
            return this.analyze(name, document);
        }
        catch (SAXException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return LayoutAnalysis.ERROR;
    }

    public LayoutAnalysis analyze(Document document) {
        return this.analyze("<unknown>", document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutAnalysis analyze(String name, Document document) {
        LayoutAnalysis analysis = new LayoutAnalysis(name);
        try {
            Element root = document.getDocumentElement();
            this.analyze(analysis, root);
        }
        finally {
            analysis.validate();
        }
        return analysis;
    }

    private void analyze(LayoutAnalysis analysis, Node node) {
        NodeList list = node.getChildNodes();
        int count = list.getLength();
        this.applyRules(analysis, node);
        for (int i = 0; i < count; ++i) {
            Node child = list.item(i);
            if (child.getNodeType() != 1) continue;
            this.analyze(analysis, child);
        }
    }

    private void applyRules(LayoutAnalysis analysis, Node node) {
        analysis.setCurrentNode(node);
        for (Rule rule : this.mRules) {
            rule.run(analysis, node);
        }
    }
}

