/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.AddonsListFetcher;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.LocalSdkParser;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformToolPackage;
import com.android.sdklib.internal.repository.SdkAddonSource;
import com.android.sdklib.internal.repository.SdkRepoSource;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.SdkSourceCategory;
import com.android.sdklib.internal.repository.SdkSources;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdklib.repository.SdkRepoConstants;
import com.android.sdkuilib.internal.repository.AdbWrapper;
import com.android.sdkuilib.internal.repository.ArchiveInfo;
import com.android.sdkuilib.internal.repository.IUpdaterData;
import com.android.sdkuilib.internal.repository.LocalSdkAdapter;
import com.android.sdkuilib.internal.repository.RepoSourcesAdapter;
import com.android.sdkuilib.internal.repository.SettingsController;
import com.android.sdkuilib.internal.repository.UpdateChooserDialog;
import com.android.sdkuilib.internal.repository.UpdaterLogic;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.repository.UpdaterWindow;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdaterData
implements IUpdaterData {
    private String mOsSdkRoot;
    private final ISdkLog mSdkLog;
    private ITaskFactory mTaskFactory;
    private SdkManager mSdkManager;
    private AvdManager mAvdManager;
    private final LocalSdkParser mLocalSdkParser = new LocalSdkParser();
    private final SdkSources mSources = new SdkSources();
    private final LocalSdkAdapter mLocalSdkAdapter = new LocalSdkAdapter(this);
    private final RepoSourcesAdapter mSourcesAdapter = new RepoSourcesAdapter(this);
    private ImageFactory mImageFactory;
    private final SettingsController mSettingsController;
    private final ArrayList<UpdaterWindow.ISdkListener> mListeners = new ArrayList();
    private Shell mWindowShell;
    private AndroidLocation.AndroidLocationException mAvdManagerInitError;
    private int mStateFetchRemoteAddonsList;

    public UpdaterData(String osSdkRoot, ISdkLog sdkLog) {
        this.mOsSdkRoot = osSdkRoot;
        this.mSdkLog = sdkLog;
        this.mSettingsController = new SettingsController(this);
        this.initSdk();
    }

    public String getOsSdkRoot() {
        return this.mOsSdkRoot;
    }

    public void setTaskFactory(ITaskFactory taskFactory) {
        this.mTaskFactory = taskFactory;
    }

    @Override
    public ITaskFactory getTaskFactory() {
        return this.mTaskFactory;
    }

    public SdkSources getSources() {
        return this.mSources;
    }

    public RepoSourcesAdapter getSourcesAdapter() {
        return this.mSourcesAdapter;
    }

    public LocalSdkParser getLocalSdkParser() {
        return this.mLocalSdkParser;
    }

    public LocalSdkAdapter getLocalSdkAdapter() {
        return this.mLocalSdkAdapter;
    }

    @Override
    public ISdkLog getSdkLog() {
        return this.mSdkLog;
    }

    public void setImageFactory(ImageFactory imageFactory) {
        this.mImageFactory = imageFactory;
    }

    @Override
    public ImageFactory getImageFactory() {
        return this.mImageFactory;
    }

    @Override
    public SdkManager getSdkManager() {
        return this.mSdkManager;
    }

    @Override
    public AvdManager getAvdManager() {
        return this.mAvdManager;
    }

    @Override
    public SettingsController getSettingsController() {
        return this.mSettingsController;
    }

    public void addListeners(UpdaterWindow.ISdkListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(UpdaterWindow.ISdkListener listener) {
        this.mListeners.remove(listener);
    }

    public void setWindowShell(Shell windowShell) {
        this.mWindowShell = windowShell;
    }

    @Override
    public Shell getWindowShell() {
        return this.mWindowShell;
    }

    public boolean checkIfInitFailed() {
        if (this.mAvdManagerInitError != null) {
            String example = SdkConstants.currentPlatform() == 2 ? "%USERPROFILE%" : "~";
            String error = String.format("The AVD manager normally uses the user's profile directory to store AVD files. However it failed to find the default profile directory. \nTo fix this, please set the environment variable ANDROID_SDK_HOME to a valid path such as \"%s\".", example);
            if (this.mWindowShell != null) {
                MessageDialog.openError((Shell)this.mWindowShell, (String)"Android Virtual Devices Manager", (String)error);
            } else {
                this.mSdkLog.error(null, "%s", new Object[]{error});
            }
            return true;
        }
        return false;
    }

    private void initSdk() {
        this.mSdkManager = SdkManager.createManager((String)this.mOsSdkRoot, (ISdkLog)this.mSdkLog);
        try {
            this.mAvdManager = null;
            this.mAvdManager = new AvdManager(this.mSdkManager, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.mSdkLog.error((Throwable)e, "Unable to read AVDs: " + e.getMessage(), new Object[0]);
            this.mAvdManagerInitError = e;
        }
        this.notifyListeners(false);
    }

    public void reloadSdk() {
        this.mSdkManager.reloadSdk(this.mSdkLog);
        if (this.mAvdManager != null) {
            try {
                this.mAvdManager.reloadAvds(this.mSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                // empty catch block
            }
        }
        this.mLocalSdkParser.clearPackages();
        this.notifyListeners(false);
    }

    public void reloadAvds() {
        if (this.mAvdManager != null) {
            try {
                this.mAvdManager.reloadAvds(this.mSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                this.mSdkLog.error((Throwable)e, null, new Object[0]);
            }
        }
    }

    public void setupDefaultSources() {
        SdkSources sources = this.getSources();
        sources.add(SdkSourceCategory.ANDROID_REPO, (SdkSource)new SdkRepoSource("https://dl-ssl.google.com/android/repository/", SdkSourceCategory.ANDROID_REPO.getUiName()));
        sources.loadUserAddons(this.getSdkLog());
        String str = System.getenv("SDK_TEST_URLS");
        if (str != null) {
            String[] urls;
            for (String url : urls = str.split(";")) {
                SdkRepoSource s;
                String fullUrl;
                if (url == null) continue;
                if ((url = url.trim()).endsWith("/") || url.endsWith("repository.xml")) {
                    fullUrl = url;
                    if (fullUrl.endsWith("/")) {
                        fullUrl = fullUrl + "repository.xml";
                    }
                    if (!sources.hasSourceUrl((SdkSource)(s = new SdkRepoSource(fullUrl, null)))) {
                        sources.add(SdkSourceCategory.GETENV_REPOS, (SdkSource)s);
                    }
                }
                if (!url.endsWith("/") && !url.endsWith("addon.xml")) continue;
                fullUrl = url;
                if (fullUrl.endsWith("/")) {
                    fullUrl = fullUrl + "addon.xml";
                }
                if (sources.hasSourceUrl((SdkSource)(s = new SdkAddonSource(fullUrl, null)))) continue;
                sources.add(SdkSourceCategory.GETENV_ADDONS, (SdkSource)s);
            }
        }
    }

    public Package[] getInstalledPackage() {
        LocalSdkParser parser = this.getLocalSdkParser();
        Package[] packages = parser.getPackages();
        if (packages == null) {
            packages = parser.parseSdk(this.getOsSdkRoot(), this.getSdkManager(), this.getSdkLog());
        }
        return packages;
    }

    public void notifyListeners(final boolean init) {
        if (this.mWindowShell != null && this.mListeners.size() > 0) {
            this.mWindowShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    for (UpdaterWindow.ISdkListener listener : UpdaterData.this.mListeners) {
                        try {
                            listener.onSdkChange(init);
                        }
                        catch (Throwable t) {
                            UpdaterData.this.mSdkLog.error(t, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    public void installArchives(final ArrayList<ArchiveInfo> result) {
        if (this.mTaskFactory == null) {
            throw new IllegalArgumentException("Task Factory is null");
        }
        final boolean forceHttp = this.getSettingsController().getForceHttp();
        this.mTaskFactory.start("Installing Archives", new ITask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ITaskMonitor monitor) {
                int progressPerArchive = 200;
                monitor.setProgressMax(result.size() * 200);
                monitor.setDescription("Preparing to install archives", new Object[0]);
                boolean installedAddon = false;
                boolean installedTools = false;
                boolean installedPlatformTools = false;
                HashSet<Archive> installedArchives = new HashSet<Archive>();
                for (Package p : UpdaterData.this.getInstalledPackage()) {
                    for (Archive a : p.getArchives()) {
                        installedArchives.add(a);
                    }
                }
                int numInstalled = 0;
                block12: for (ArchiveInfo ai : result) {
                    Archive archive = ai.getNewArchive();
                    if (archive == null) continue;
                    int nextProgress = monitor.getProgress() + 200;
                    try {
                        if (monitor.isCancelRequested()) break;
                        ArchiveInfo[] adeps = ai.getDependsOn();
                        if (adeps != null) {
                            for (ArchiveInfo adep : adeps) {
                                Archive na = adep.getNewArchive();
                                if (na == null) {
                                    monitor.setResult("Skipping '%1$s'; it depends on a missing package.", new Object[]{archive.getParentPackage().getShortDescription()});
                                    continue block12;
                                }
                                if (installedArchives.contains(na)) continue;
                                monitor.setResult("Skipping '%1$s'; it depends on '%2$s' which was not installed.", new Object[]{archive.getParentPackage().getShortDescription(), adep.getShortDescription()});
                                continue block12;
                            }
                        }
                        if (!archive.install(UpdaterData.this.mOsSdkRoot, forceHttp, UpdaterData.this.mSdkManager, monitor)) continue;
                        installedArchives.add(archive);
                        ++numInstalled;
                        installedArchives.remove(ai.getReplaced());
                        if (archive.getParentPackage() instanceof AddonPackage) {
                            installedAddon = true;
                            continue;
                        }
                        if (archive.getParentPackage() instanceof ToolPackage) {
                            installedTools = true;
                            continue;
                        }
                        if (!(archive.getParentPackage() instanceof PlatformToolPackage)) continue;
                        installedPlatformTools = true;
                    }
                    catch (Throwable t) {
                        String msg = t.getMessage();
                        if (msg != null) {
                            msg = String.format("Unexpected Error installing '%1$s': %2$s: %3$s", archive.getParentPackage().getShortDescription(), t.getClass().getCanonicalName(), msg);
                        } else {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            t.printStackTrace(new PrintStream(baos));
                            msg = String.format("Unexpected Error installing '%1$s'\n%2$s", archive.getParentPackage().getShortDescription(), baos.toString());
                        }
                        monitor.setResult(msg, new Object[0]);
                        UpdaterData.this.mSdkLog.error(t, msg, new Object[0]);
                    }
                    finally {
                        monitor.incProgress(nextProgress - monitor.getProgress());
                    }
                }
                if (installedAddon) {
                    try {
                        UpdaterData.this.mSdkManager.updateAdb();
                        monitor.setResult("Updated ADB to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                    catch (Exception e) {
                        UpdaterData.this.mSdkLog.error((Throwable)e, "Update ADB failed", new Object[0]);
                        monitor.setResult("failed to update adb to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                }
                if (installedAddon || installedPlatformTools) {
                    UpdaterData.this.askForAdbRestart(monitor);
                }
                if (installedTools) {
                    UpdaterData.this.notifyToolsNeedsToBeRestarted();
                }
                if (numInstalled == 0) {
                    monitor.setDescription("Done. Nothing was installed.", new Object[0]);
                } else {
                    monitor.setDescription("Done. %1$d %2$s installed.", new Object[]{numInstalled, numInstalled == 1 ? "package" : "packages"});
                    UpdaterData.this.reloadSdk();
                }
            }
        });
    }

    private void askForAdbRestart(ITaskMonitor monitor) {
        final boolean[] canRestart = new boolean[]{true};
        if (this.getWindowShell() != null && this.getSettingsController().getAskBeforeAdbRestart()) {
            Display display = this.getWindowShell().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    canRestart[0] = MessageDialog.openQuestion((Shell)UpdaterData.this.getWindowShell(), (String)"ADB Restart", (String)"A package that depends on ADB has been updated. \nDo you want to restart ADB now?");
                }
            });
        }
        if (canRestart[0]) {
            AdbWrapper adb = new AdbWrapper(this.getOsSdkRoot(), monitor);
            adb.stopAdb();
            adb.startAdb();
        }
    }

    private void notifyToolsNeedsToBeRestarted() {
        if (this.getWindowShell() == null) {
            return;
        }
        Display display = this.getWindowShell().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)UpdaterData.this.getWindowShell(), (String)"Android Tools Updated", (String)"The Android SDK and AVD Manager that you are currently using has been updated. It is recommended that you now close the manager window and re-open it. If you started this window from Eclipse, please check if the Android plug-in needs to be updated.");
            }
        });
    }

    public void updateOrInstallAll_WithGUI(Collection<Archive> selectedArchives, boolean includeObsoletes) {
        UpdaterLogic ul = new UpdaterLogic(this);
        ArrayList<ArchiveInfo> archives = ul.computeUpdates(selectedArchives, this.getSources(), this.getLocalSdkParser().getPackages(), includeObsoletes);
        if (selectedArchives == null) {
            ul.addNewPlatforms(archives, this.getSources(), this.getLocalSdkParser().getPackages(), includeObsoletes);
        }
        Collections.sort(archives);
        UpdateChooserDialog dialog = new UpdateChooserDialog(this.getWindowShell(), this, archives);
        dialog.open();
        ArrayList<ArchiveInfo> result = dialog.getResult();
        if (result != null && result.size() > 0) {
            this.installArchives(result);
        }
    }

    public void updateOrInstallAll_NoGUI(Collection<String> pkgFilter, boolean includeObsoletes, boolean dryMode) {
        this.refreshSources(true);
        UpdaterLogic ul = new UpdaterLogic(this);
        ArrayList<ArchiveInfo> archives = ul.computeUpdates(null, this.getSources(), this.getLocalSdkParser().getPackages(), includeObsoletes);
        ul.addNewPlatforms(archives, this.getSources(), this.getLocalSdkParser().getPackages(), includeObsoletes);
        Collections.sort(archives);
        if (pkgFilter != null && pkgFilter.size() > 0 && archives != null && archives.size() > 0) {
            HashMap pkgMap = new HashMap();
            ClassLoader classLoader = this.getClass().getClassLoader();
            String basePackage = Package.class.getPackage().getName();
            block2: for (String node : SdkRepoConstants.NODES) {
                String name = node.substring(0, 1).toUpperCase() + node.substring(1);
                int dash = name.indexOf(45);
                if (dash > 0) {
                    name = name.replaceFirst("-", "");
                }
                for (int alternatives = 0; alternatives < 2; ++alternatives) {
                    String fqcn = basePackage + "." + name + "Package";
                    try {
                        Class<?> clazz = classLoader.loadClass(fqcn);
                        if (clazz != null) {
                            pkgMap.put(node, clazz);
                            continue;
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    if (alternatives != 0 || dash <= 0) continue block2;
                    name = name.substring(0, dash) + name.substring(dash, dash + 1).toUpperCase() + name.substring(dash + 1);
                }
            }
            if (SdkRepoConstants.NODES.length != pkgMap.size()) {
                this.mSdkLog.printf("*** Filter Mismatch! ***\n*** The package filter list has changed. Please report this.", new Object[0]);
            }
            HashSet allowedPkgSet = new HashSet();
            for (String type : pkgFilter) {
                if (pkgMap.containsKey(type)) {
                    allowedPkgSet.add(pkgMap.get(type));
                    continue;
                }
                this.mSdkLog.error(null, "Ignoring unknown package filter '%1$s'", new Object[]{type});
            }
            pkgMap = null;
            Iterator<ArchiveInfo> it = archives.iterator();
            while (it.hasNext()) {
                Package p;
                boolean keep = false;
                ArchiveInfo ai = it.next();
                Archive a = ai.getNewArchive();
                if (a != null && (p = a.getParentPackage()) != null && allowedPkgSet.contains(p.getClass())) {
                    keep = true;
                }
                if (keep) continue;
                it.remove();
            }
            if (archives.size() == 0) {
                this.mSdkLog.printf("The package filter removed all packages. There is nothing to install.\nPlease consider trying updating again without a package filter.\n", new Object[0]);
                return;
            }
        }
        if (archives != null && archives.size() > 0) {
            if (dryMode) {
                this.mSdkLog.printf("Packages selected for install:\n", new Object[0]);
                for (ArchiveInfo ai : archives) {
                    Package p;
                    Archive a = ai.getNewArchive();
                    if (a == null || (p = a.getParentPackage()) == null) continue;
                    this.mSdkLog.printf("- %1$s\n", new Object[]{p.getShortDescription()});
                }
                this.mSdkLog.printf("\nDry mode is on so nothing will actually be installed.\n", new Object[0]);
            } else {
                this.installArchives(archives);
            }
        } else {
            this.mSdkLog.printf("There is nothing to install or update.\n", new Object[0]);
        }
    }

    public void refreshSources(final boolean forceFetching) {
        assert (this.mTaskFactory != null);
        final boolean forceHttp = this.getSettingsController().getForceHttp();
        this.mTaskFactory.start("Refresh Sources", new ITask(){

            public void run(ITaskMonitor monitor) {
                if (UpdaterData.this.mStateFetchRemoteAddonsList <= 0) {
                    UpdaterData.this.loadRemoteAddonsListInTask(monitor);
                }
                SdkSource[] sources = UpdaterData.this.mSources.getAllSources();
                monitor.setProgressMax(monitor.getProgress() + sources.length);
                for (SdkSource source : sources) {
                    if (forceFetching || source.getPackages() != null || source.getFetchError() != null) {
                        source.load(monitor.createSubMonitor(1), forceHttp);
                    }
                    monitor.incProgress(1);
                }
            }
        });
    }

    public void loadRemoteAddonsList() {
        if (this.mStateFetchRemoteAddonsList != 0) {
            return;
        }
        this.mTaskFactory.start("Load Add-ons List", new ITask(){

            public void run(ITaskMonitor monitor) {
                UpdaterData.this.loadRemoteAddonsListInTask(monitor);
            }
        });
    }

    private void loadRemoteAddonsListInTask(ITaskMonitor monitor) {
        this.mStateFetchRemoteAddonsList = -1;
        String url = System.getenv("SDK_TEST_URLS");
        if (url == null) {
            url = "https://dl-ssl.google.com/android/repository/addons_list.xml";
        } else {
            String[] urls = url.split(";");
            url = null;
            for (String u : urls) {
                if ((u = u.trim()).endsWith("/")) {
                    url = u + "addons_list.xml";
                    break;
                }
                if (!u.endsWith("addons_list.xml")) continue;
                url = u;
                break;
            }
        }
        if (url != null) {
            AddonsListFetcher fetcher;
            AddonsListFetcher.Site[] sites;
            if (this.getSettingsController().getForceHttp()) {
                url = url.replaceAll("https://", "http://");
            }
            if ((sites = (fetcher = new AddonsListFetcher()).fetch(monitor, url)) != null) {
                this.mSources.removeAll(SdkSourceCategory.ADDONS_3RD_PARTY);
                for (AddonsListFetcher.Site s : sites) {
                    this.mSources.add(SdkSourceCategory.ADDONS_3RD_PARTY, (SdkSource)new SdkAddonSource(s.getUrl(), s.getUiName()));
                }
                this.mStateFetchRemoteAddonsList = 1;
            }
        }
    }
}

