/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.Package;
import com.android.sdkuilib.internal.repository.ArchiveInfo;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.ui.GridDialog;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UpdateChooserDialog
extends GridDialog {
    private static Point sLastSize;
    private boolean mLicenseAcceptAll;
    private boolean mInternalLicenseRadioUpdate;
    private SashForm mSashForm;
    private Composite mPackageRootComposite;
    private TableViewer mTableViewPackage;
    private Table mTablePackage;
    private TableColumn mTableColum;
    private StyledText mPackageText;
    private Button mLicenseRadioAccept;
    private Button mLicenseRadioReject;
    private Button mLicenseRadioAcceptAll;
    private Group mPackageTextGroup;
    private final UpdaterData mUpdaterData;
    private Group mTableGroup;
    private Label mErrorLabel;
    private final ArrayList<ArchiveInfo> mArchives;

    public UpdateChooserDialog(Shell parentShell, UpdaterData updaterData, ArrayList<ArchiveInfo> archives) {
        super(parentShell, 3, false);
        this.mUpdaterData = updaterData;
        this.mArchives = archives;
    }

    protected boolean isResizable() {
        return true;
    }

    public ArrayList<ArchiveInfo> getResult() {
        ArrayList<ArchiveInfo> ais = new ArrayList<ArchiveInfo>();
        if (this.getReturnCode() == 0) {
            for (ArchiveInfo ai : this.mArchives) {
                if (!ai.isAccepted()) continue;
                ais.add(ai);
            }
        }
        return ais;
    }

    @Override
    public void createDialogContent(Composite parent) {
        this.mSashForm = new SashForm(parent, 0);
        this.mSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.mTableGroup = new Group((Composite)this.mSashForm, 0);
        this.mTableGroup.setText("Packages");
        this.mTableGroup.setLayout((Layout)new GridLayout(1, false));
        this.mTableViewPackage = new TableViewer((Composite)this.mTableGroup, 2564);
        this.mTablePackage = this.mTableViewPackage.getTable();
        this.mTablePackage.setHeaderVisible(false);
        this.mTablePackage.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mTablePackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onPackageSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onPackageDoubleClick();
            }
        });
        this.mTableColum = new TableColumn(this.mTablePackage, 0);
        this.mTableColum.setWidth(100);
        this.mTableColum.setText("Packages");
        this.mPackageRootComposite = new Composite((Composite)this.mSashForm, 0);
        this.mPackageRootComposite.setLayout((Layout)new GridLayout(4, false));
        this.mPackageRootComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mPackageTextGroup = new Group(this.mPackageRootComposite, 0);
        this.mPackageTextGroup.setText("Package Description && License");
        this.mPackageTextGroup.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.mPackageTextGroup.setLayout((Layout)new GridLayout(1, false));
        this.mPackageText = new StyledText((Composite)this.mPackageTextGroup, 586);
        this.mPackageText.setBackground(this.getParentShell().getDisplay().getSystemColor(22));
        this.mPackageText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mLicenseRadioAccept = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioAccept.setText("Accept");
        this.mLicenseRadioAccept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onLicenseRadioSelected();
            }
        });
        this.mLicenseRadioReject = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioReject.setText("Reject");
        this.mLicenseRadioReject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onLicenseRadioSelected();
            }
        });
        Label placeholder = new Label(this.mPackageRootComposite, 0);
        placeholder.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.mLicenseRadioAcceptAll = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioAcceptAll.setText("Accept All");
        this.mLicenseRadioAcceptAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onLicenseRadioSelected();
            }
        });
        this.mSashForm.setWeights(new int[]{200, 300});
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false, 3, 1);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.mErrorLabel = new Label(composite, 0);
        this.mErrorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label.setText("[*] Something depends on this package");
        label.setEnabled(false);
        ++layout.numColumns;
        this.createButtonsForButtonBar(composite);
        Button button = this.getButton(0);
        button.setText("Install");
        return composite;
    }

    public void create() {
        super.create();
        this.getShell().setText("Choose Packages to Install");
        this.setWindowImage();
        for (ArchiveInfo ai : this.mArchives) {
            Archive a = ai.getNewArchive();
            if (a == null) continue;
            String license = a.getParentPackage().getLicense();
            ai.setAccepted(license == null || license.trim().length() == 0);
        }
        this.mTableViewPackage.setLabelProvider((IBaseLabelProvider)new NewArchivesLabelProvider());
        this.mTableViewPackage.setContentProvider((IContentProvider)new NewArchivesContentProvider());
        this.mTableViewPackage.setInput(this.mArchives);
        this.adjustColumnsWidth();
        this.mTablePackage.select(0);
        this.onPackageSelected();
    }

    private void setWindowImage() {
        ImageFactory imgFactory;
        String imageName = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            imageName = "android_icon_128.png";
        }
        if (this.mUpdaterData != null && (imgFactory = this.mUpdaterData.getImageFactory()) != null) {
            this.getShell().setImage(imgFactory.getImageByName(imageName));
        }
    }

    private void adjustColumnsWidth() {
        ControlAdapter resizer = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = UpdateChooserDialog.this.mTablePackage.getClientArea();
                UpdateChooserDialog.this.mTableColum.setWidth(r.width);
            }
        };
        this.mTablePackage.addControlListener((ControlListener)resizer);
        resizer.controlResized(null);
    }

    public boolean close() {
        sLastSize = this.getShell().getSize();
        return super.close();
    }

    protected Point getInitialSize() {
        if (sLastSize != null) {
            return sLastSize;
        }
        return new Point(740, 370);
    }

    private void onPackageSelected() {
        ArchiveInfo ai = this.getSelectedArchive();
        this.displayInformation(ai);
        this.displayMissingDependency(ai);
        this.updateLicenceRadios(ai);
    }

    private ArchiveInfo getSelectedArchive() {
        Object elem;
        ISelection sel = this.mTableViewPackage.getSelection();
        if (sel instanceof IStructuredSelection && (elem = ((IStructuredSelection)sel).getFirstElement()) instanceof ArchiveInfo) {
            return (ArchiveInfo)elem;
        }
        return null;
    }

    private void displayInformation(ArchiveInfo ai) {
        ArchiveInfo[] aDeps;
        if (ai == null) {
            this.mPackageText.setText("Please select a package.");
            return;
        }
        Archive aNew = ai.getNewArchive();
        if (aNew == null) {
            return;
        }
        Package pNew = aNew.getParentPackage();
        this.mPackageText.setText("");
        this.addSectionTitle("Package Description\n");
        this.addText(pNew.getLongDescription(), "\n\n");
        Archive aOld = ai.getReplaced();
        if (aOld != null) {
            AndroidVersion vNew;
            AndroidVersion vOld;
            Package pOld = aOld.getParentPackage();
            int rOld = pOld.getRevision();
            int rNew = pNew.getRevision();
            boolean showRev = true;
            if (pNew instanceof IPackageVersion && pOld instanceof IPackageVersion && !(vOld = ((IPackageVersion)pOld).getVersion()).equals((Object)(vNew = ((IPackageVersion)pNew).getVersion()))) {
                this.addText(String.format("This update will replace API %1$s revision %2$d with API %3$s revision %4$d.\n\n", vOld.getApiString(), rOld, vNew.getApiString(), rNew));
                showRev = false;
            }
            if (showRev) {
                this.addText(String.format("This update will replace revision %1$d with revision %2$d.\n\n", rOld, rNew));
            }
        }
        if ((aDeps = ai.getDependsOn()) != null && aDeps.length > 0 || ai.isDependencyFor()) {
            this.addSectionTitle("Dependencies\n");
            if (aDeps != null && aDeps.length > 0) {
                this.addText("Installing this package also requires installing:");
                for (ArchiveInfo aDep : aDeps) {
                    this.addText(String.format("\n- %1$s", aDep.getShortDescription()));
                }
                this.addText("\n\n");
            }
            if (ai.isDependencyFor()) {
                this.addText("This package is a dependency for:");
                for (ArchiveInfo ai2 : ai.getDependenciesFor()) {
                    this.addText(String.format("\n- %1$s", ai2.getShortDescription()));
                }
                this.addText("\n\n");
            }
        }
        this.addSectionTitle("Archive Description\n");
        this.addText(aNew.getLongDescription(), "\n\n");
        String license = pNew.getLicense();
        if (license != null) {
            this.addSectionTitle("License\n");
            this.addText(license.trim(), "\n\n");
        }
        this.addSectionTitle("Site\n");
        this.addText(pNew.getParentSource().getShortDescription());
    }

    /*
     * Exception decompiling
     */
    private void displayMissingDependency(ArchiveInfo ai) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[FORLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addText(String ... string) {
        for (String s : string) {
            this.mPackageText.append(s);
        }
    }

    private void addSectionTitle(String string) {
        String s = this.mPackageText.getText();
        int start = s == null ? 0 : s.length();
        this.mPackageText.append(string);
        StyleRange sr = new StyleRange();
        sr.start = start;
        sr.length = string.length();
        sr.fontStyle = 1;
        sr.underline = true;
        this.mPackageText.setStyleRange(sr);
    }

    private void updateLicenceRadios(ArchiveInfo ai) {
        boolean missing;
        if (this.mInternalLicenseRadioUpdate) {
            return;
        }
        this.mInternalLicenseRadioUpdate = true;
        boolean oneAccepted = false;
        if (this.mLicenseAcceptAll) {
            this.mLicenseRadioAcceptAll.setSelection(true);
            this.mLicenseRadioAccept.setEnabled(true);
            this.mLicenseRadioReject.setEnabled(true);
            this.mLicenseRadioAccept.setSelection(false);
            this.mLicenseRadioReject.setSelection(false);
        } else {
            this.mLicenseRadioAcceptAll.setSelection(false);
            oneAccepted = ai != null && ai.isAccepted();
            this.mLicenseRadioAccept.setEnabled(ai != null);
            this.mLicenseRadioReject.setEnabled(ai != null);
            this.mLicenseRadioAccept.setSelection(oneAccepted);
            this.mLicenseRadioReject.setSelection(ai != null && ai.isRejected());
        }
        boolean bl = missing = this.mErrorLabel.getText() != null && this.mErrorLabel.getText().length() > 0;
        if (!missing && !oneAccepted) {
            for (ArchiveInfo ai2 : this.mArchives) {
                if (!ai2.isAccepted()) continue;
                oneAccepted = true;
                break;
            }
        }
        this.getButton(0).setEnabled(!missing && oneAccepted);
        this.mInternalLicenseRadioUpdate = false;
    }

    private void onLicenseRadioSelected() {
        if (this.mInternalLicenseRadioUpdate) {
            return;
        }
        this.mInternalLicenseRadioUpdate = true;
        ArchiveInfo ai = this.getSelectedArchive();
        if (ai == null) {
            return;
        }
        boolean needUpdate = true;
        if (!this.mLicenseAcceptAll && this.mLicenseRadioAcceptAll.getSelection()) {
            this.mLicenseAcceptAll = true;
            for (ArchiveInfo ai2 : this.mArchives) {
                ai2.setAccepted(true);
                ai2.setRejected(false);
            }
        } else if (this.mLicenseRadioAccept.getSelection()) {
            this.mLicenseAcceptAll = false;
            ai.setAccepted(true);
            ai.setRejected(false);
        } else if (this.mLicenseRadioReject.getSelection()) {
            this.mLicenseAcceptAll = false;
            ai.setAccepted(false);
            ai.setRejected(true);
        } else {
            needUpdate = false;
        }
        this.mInternalLicenseRadioUpdate = false;
        if (needUpdate) {
            if (this.mLicenseAcceptAll) {
                this.mTableViewPackage.refresh();
            } else {
                this.mTableViewPackage.refresh((Object)ai);
            }
            this.displayMissingDependency(ai);
            this.updateLicenceRadios(ai);
        }
    }

    private void onPackageDoubleClick() {
        ArchiveInfo ai = this.getSelectedArchive();
        if (ai == null) {
            return;
        }
        boolean wasAccepted = ai.isAccepted();
        ai.setAccepted(!wasAccepted);
        ai.setRejected(wasAccepted);
        this.mLicenseAcceptAll = false;
        this.mTableViewPackage.refresh((Object)ai);
        this.displayMissingDependency(ai);
        this.updateLicenceRadios(ai);
    }

    private class NewArchivesContentProvider
    implements IStructuredContentProvider {
        private NewArchivesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return UpdateChooserDialog.this.mArchives.toArray();
        }
    }

    private class NewArchivesLabelProvider
    extends LabelProvider {
        private NewArchivesLabelProvider() {
        }

        public Image getImage(Object element) {
            assert (element instanceof ArchiveInfo);
            ArchiveInfo ai = (ArchiveInfo)element;
            ImageFactory imgFactory = UpdateChooserDialog.this.mUpdaterData.getImageFactory();
            if (imgFactory != null) {
                if (ai.isAccepted()) {
                    return imgFactory.getImageByName("accept_icon16.png");
                }
                if (ai.isRejected()) {
                    return imgFactory.getImageByName("reject_icon16.png");
                }
                return imgFactory.getImageByName("unknown_icon16.png");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            assert (element instanceof ArchiveInfo);
            ArchiveInfo ai = (ArchiveInfo)element;
            String desc = ai.getShortDescription();
            if (ai.isDependencyFor()) {
                desc = desc + " [*]";
            }
            return desc;
        }
    }
}

