/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.SdkConstants;
import com.android.sdklib.internal.repository.ITaskMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdbWrapper {
    private final String mAdbOsLocation;
    private final ITaskMonitor mMonitor;

    public AdbWrapper(String osSdkPath, ITaskMonitor monitor) {
        this.mMonitor = monitor;
        if (!osSdkPath.endsWith(File.separator)) {
            osSdkPath = osSdkPath + File.separator;
        }
        this.mAdbOsLocation = osSdkPath + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_ADB;
    }

    private void display(String format, Object ... args) {
        this.mMonitor.setResult(format, args);
    }

    public synchronized boolean startAdb() {
        if (this.mAdbOsLocation == null) {
            this.display("Error: missing path to ADB.", new Object[0]);
            return false;
        }
        int status = -1;
        try {
            String[] command = new String[]{this.mAdbOsLocation, "start-server"};
            Process proc = Runtime.getRuntime().exec(command);
            ArrayList<String> errorOutput = new ArrayList<String>();
            ArrayList<String> stdOutput = new ArrayList<String>();
            status = this.grabProcessOutput(proc, errorOutput, stdOutput, false);
        }
        catch (IOException ioe) {
            this.display("Unable to run 'adb': %1$s.", ioe.getMessage());
        }
        catch (InterruptedException ie) {
            this.display("Unable to run 'adb': %1$s.", ie.getMessage());
        }
        if (status != 0) {
            this.display("'adb start-server' failed.", new Object[0]);
            return false;
        }
        this.display("'adb start-server' succeeded.", new Object[0]);
        return true;
    }

    public synchronized boolean stopAdb() {
        if (this.mAdbOsLocation == null) {
            this.display("Error: missing path to ADB.", new Object[0]);
            return false;
        }
        int status = -1;
        try {
            String[] command = new String[]{this.mAdbOsLocation, "kill-server"};
            Process proc = Runtime.getRuntime().exec(command);
            status = proc.waitFor();
        }
        catch (IOException ioe) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (status != 0) {
            this.display("'adb kill-server' failed -- run manually if necessary.", new Object[0]);
            return false;
        }
        this.display("'adb kill-server' succeeded.", new Object[0]);
        return true;
    }

    private int grabProcessOutput(final Process process, final ArrayList<String> errorOutput, final ArrayList<String> stdOutput, boolean waitforReaders) throws InterruptedException {
        assert (errorOutput != null);
        assert (stdOutput != null);
        Thread t1 = new Thread(""){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream());
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        AdbWrapper.this.display("ADB Error: %1$s", new Object[]{line});
                        errorOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread t2 = new Thread(""){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream());
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        AdbWrapper.this.display("ADB: %1$s", new Object[]{line});
                        stdOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t1.start();
        t2.start();
        if (waitforReaders) {
            try {
                t1.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                t2.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return process.waitFor();
    }
}

