# Elefant CMS

[Elefant](https://www.elefantcms.com/) is a refreshingly simple PHP content management
system and web framework. Elefant is a fast, lean tool for building everything from
simple websites to complete web applications.

## Installation help & documentation

Elefant has extensive documentation including installation instructions, user manual,
designer guides, and developer tutorials here:

* https://www.elefantcms.com/docs

You can also find help on our community forum here:

* https://www.elefantcms.com/community

## Built for designers

**Compiled, ultra-fast templates**

Elefant compiles your templates into secure, readable PHP code, so rendering is as fast as
possible and also takes advantage of bytecode caching (e.g., APC).

**Dead simple, concise template tags**

[Familiar syntax](https://www.elefantcms.com/docs/2.2/designers/template-language) to other template
languages, with some added conveniences for dynamic embeds and internationalization.

**Clean, easy to use site editor for your users**

Elefant comes out of the box with a [full-featured CMS](https://www.elefantcms.com/docs/2.2/user-manual)
for your users. You can even [white label it](https://www.elefantcms.com/docs/2.2/designers/white-labelling-the-cms).

**Syntax highlighted template and CSS editor**

Sophisticated [in-browser editing](https://www.elefantcms.com/docs/2.2/designers)
with highlights and references at your finger tips.

**Live preview while editing templates and CSS**

Preview in real time as you make changes. Or if you prefer, edit files directly with
your editor of choice.

**Integrates with 960 grid system and jQuery**

Or any other CSS grid/layout system, giving you complete control over your designs. Theme builder also provides defaults for Twitter Bootstrap.

## Built for developers

**Quickly built custom apps**

With all the tools you need, and a very low learning curve, Elefant gets you writing
code quickly.

**Extensively documented**

Including full [API reference](https://www.elefantcms.com/visor),
[user manual](https://www.elefantcms.com/docs/2.2/user-manual),
[tutorials, and much more](https://www.elefantcms.com/docs/2.2/developers).

**Strong security by default**

[Flexible form building](https://www.elefantcms.com/docs/2.2/developers/form-handling),
[input validation](https://www.elefantcms.com/docs/2.2/developers/input-validation),
and automatic prevention of XSS, SQL injection, CSRF, and other types of attacks.

**Very fast and low memory**

Elefant uses less memory than any of the major frameworks, so you can serve more visitors with the same resources.
Benchmarks: [MVC layer](https://github.com/jbroadway/phpmark-elefant/blob/master/php-framework-benchmark-results.md),
[database access](https://github.com/jbroadway/php-dbal-bench), and [template rendering](https://github.com/jbroadway/template-bench).

**Solid debugging tools**

Debug mode prints full traces with highlighted source code and variable state to
help you fix bugs faster.

**Minimalist HMVC/Model2 architecture**

Elefant takes a [unique but proven approach](https://www.elefantcms.com/docs/2.2/developers/request-response-cycle)
that helps minimize boilerplate without sacrificing code organization as your project grows.

**Shared apps to save you time**

From blogs to user management, events to search, Elefant saves you time not reinventing
the wheel with [high quality shared apps](https://www.elefantcms.com/listings).

**Thoroughly unit-tested**

Elefant's core framework is covered by
[extensive unit tests](https://github.com/jbroadway/elefant/tree/master/tests),
ensuring a stable base to build on.

**Internationalization**

Elefant apps are automatically [i18n aware](https://www.elefantcms.com/docs/2.2/administration/multilingual-setup),
with built-in multilingual capabilities and locale awareness.

## More developer goodness

Elefant builds on over 12 years of PHP experience, and aims to simplify rapid PHP
development again. As such, Elefant takes into consideration all the little details
to help you work faster and better:

* Really simple, [automatic URL routing](https://www.elefantcms.com/docs/2.2/developers/mapping-your-routes) w/ friendly URLs
* [Minimal but secure and fast ORM](https://www.elefantcms.com/docs/2.2/developers/modelling-your-data) (based on PDO)
* Output filtering is turned *on by default*
* Tight [cache integration](https://www.elefantcms.com/docs/2.2/developers/caching) (supports APC/APCu, filesystem, Memcache, Redis, and XCache)
* Matching server- and client-side input validation
* Dead-simple [form handling](https://www.elefantcms.com/docs/2.2/developers/form-handling)
* Customizable [user authentication](https://www.elefantcms.com/docs/2.2/developers/users-and-access-control)
* [CLI tool](https://www.elefantcms.com/docs/2.2/developers/writing-command-line-scripts) for common tasks
* As little scaffolding as possible
* Gzip output compression
* [Assetic](https://github.com/jbroadway/assetic) integration

## Try it out

[Download the latest release here.](https://www.elefantcms.com/download)

* [Installation instructions](https://www.elefantcms.com/docs/2.2/getting-started)
* [Requirements](https://www.elefantcms.com/docs/2.2/getting-started/requirements)
* [Support forum](https://www.elefantcms.com/community)
* [Credits](https://www.elefantcms.com/credits)

## FAQ

**Q. Do you know you spelt Elephant wrong?**

A. This was my attempt at being hip and cool. No good?

**Q. Isn't Elefant a bit of an oxymoron for a slim framework?**

A. Why, yes. Yes it is.
