﻿KindEditor.plugin('filemanager',function(K){var self=this,name='filemanager',lang=self.lang(name+'.'),fileManagerJson=K.undef(self.fileManagerJson,''),imgPath=self.pluginsPath+name+'/images/';function makeFileTitle(filename,filesize,datetime){return filename+' ('+filesize+', '+datetime+')';}function bindTitle(el,data){el.attr('title',makeFileTitle(data.name,data.size,data.time));}self.plugin.filemanagerDialog=function(options){var width=K.undef(options.width,650),height=K.undef(options.height,530),pageSize=K.undef(options.pageSize,15),viewParam=K.undef(options.viewParam,''),viewType=K.undef(options.viewType,'VIEW').toUpperCase(),clickFn=options.clickFn;var html=['<div style="padding:10px 20px;">','<div class="ke-plugin-filemanager-header">','<div class="ke-left">','</div>','<div class="ke-right">',lang.viewType+' <select class="ke-inline-block" name="viewType">','<option value="VIEW">'+lang.viewImage+'</option>','<option value="LIST">'+lang.listImage+'</option>','</select> ',lang.orderType+' <select class="ke-inline-block" name="orderType">','<option value="time">'+lang.fileTime+'</option>','<option value="name">'+lang.fileName+'</option>','<option value="fileLength">'+lang.fileSize+'</option>','<option value="fileExte">'+lang.fileType+'</option>','</select>','</div>','<div class="ke-clearfix"></div>','</div>','<div class="ke-plugin-filemanager-body"></div>','<div class="ke-plugin-filemanager-header">','<div class="ke-left">'+lang.keyword+'','<input class="ke-input-text" type="text" name="keyword" size="10" />','<input type="hidden" name="pageNumber" value="0" /><input type="hidden" name="pageCount" value="0" />','<span class="ke-button-common ke-button-outer ke-dialog-no" title="'+lang.search+'"><input class="ke-button-common ke-button" type="button" name="search" value="'+lang.search+'" /></span>','</div>','<div class="ke-right ke-plugin-filemanager-page">',''+lang.pageInfo+'<b id="pageInfo"></b>&nbsp;&nbsp;','<a href="javascript:void(0);" id="pagePrev">'+lang.pagePrev+'</a>&nbsp;&nbsp;','<a href="javascript:void(0);" id="pageNext">'+lang.pageNext+'</a>&nbsp;&nbsp;','<input class="ke-input-text" type="text" name="page" size="2" />&nbsp;','<span class="ke-button-common ke-button-outer ke-dialog-no"><input class="ke-button-common ke-button" type="button" name="pageGo" value="Go" /></span>','</div>','<div class="ke-clearfix"></div>','</div>','</div>'].join('');var dialog=self.createDialog({name:name,width:width,height:height,title:self.lang(name),body:html}),div=dialog.div,bodyDiv=K('.ke-plugin-filemanager-body',div),pageDiv=K('.ke-plugin-filemanager-page',div),moveupImg=K('[name="moveupImg"]',div),moveupLink=K('[name="moveupLink"]',div),viewServerBtn=K('[name="viewServer"]',div),viewTypeBox=K('[name="viewType"]',div),orderTypeBox=K('[name="orderType"]',div);keywordBox=K('[name="keyword"]',div);pageNumberBox=K('[name="pageNumber"]',div);pageCountBox=K('[name="pageCount"]',div);searchBtn=K('[name="search"]',div);pageInfo=K('#pageInfo',pageDiv);pagePrev=K('#pagePrev',pageDiv);pageNext=K('#pageNext',pageDiv);pageBox=K('[name="page"]',pageDiv);pageGoBtn=K('[name="pageGo"]',pageDiv);function reloadPage(param,order,func){dialog.showLoading(self.lang('ajaxLoading'));K.ajax(K.addParam(fileManagerJson,param),function(data){dialog.hideLoading();if(data){if(data.status){if((data.store).length>0){func(data);getPager(data.pageNumber,data.pageCount);}else{bodyDiv.html(self.lang('noContent'));}}else{bodyDiv.html(data.message);}}else{bodyDiv.html(self.lang('networkError'));}},'POST',{'find':'name','keyword':keywordBox.val(),'orderBy':order,'order':'desc','pageSize':pageSize,'page':pageNumberBox.val()});}function getPager(page,pageCount){pageDiv.hide();if(pageCount>1){pageNumberBox.val(page);pageCountBox.val(pageCount);pageInfo.html('<font color="red">'+page+'</font>/'+pageCount+'');pageDiv.show();}}function getPageData(page){pageNumberBox.val(page);reloadPage(viewParam,orderTypeBox.val(),viewTypeBox.val()=='VIEW'?createView:createList);}pagePrev.click(function(){var page=parseInt(K.undef(pageNumberBox.val(),0));if(page>1)getPageData((page-1));return;});pageNext.click(function(){var page=parseInt(K.undef(pageNumberBox.val(),0)),count=parseInt(K.undef(pageCountBox.val(),0));if(page<count)getPageData((page+1));return;});pageGoBtn.click(function(){var page=parseInt(K.undef(pageBox.val(),0)),count=parseInt(K.undef(pageCountBox.val(),0));if(page>count){pageBox.val('');}else{getPageData(page);}return;});searchBtn.click(function(){pageNumberBox.val(0);reloadPage(viewParam,orderTypeBox.val(),viewTypeBox.val()=='VIEW'?createView:createList);});var elList=[];function bindEvent(el,result,data,createFunc){var fileUrl=K.formatUrl(data.url,'absolute');el.click(function(e){clickFn.call(this,fileUrl,data.name,data.exte,data.id);});elList.push(el);}function createCommon(result,createFunc){K.each(elList,function(){this.unbind();});moveupLink.unbind();viewTypeBox.unbind();orderTypeBox.unbind();function changeFunc(){reloadPage(viewParam,orderTypeBox.val(),viewTypeBox.val()=='VIEW'?createView:createList);}viewTypeBox.change(changeFunc);orderTypeBox.change(changeFunc);bodyDiv.html('');}function createList(result){createCommon(result,createList);var table=document.createElement('table');table.className='ke-table';table.cellPadding=0;table.cellSpacing=0;table.border=0;bodyDiv.append(table);var fileList=result.store;for(var i=0,len=fileList.length;i<len;i++){var data=fileList[i],row=K(table.insertRow(i));row.mouseover(function(e){K(this).addClass('ke-on');}).mouseout(function(e){K(this).removeClass('ke-on');});var iconUrl=imgPath+('file-16.gif'),img=K('<img src="'+iconUrl+'" width="16" height="16" alt="'+data.name+'" align="absmiddle" />'),cell0=K(row[0].insertCell(0)).addClass('ke-cell ke-name').append(img).append(document.createTextNode(' '+data.name));row.css('cursor','pointer');cell0.attr('title',data.name);bindEvent(cell0,result,data,createList);K(row[0].insertCell(1)).addClass('ke-cell ke-size').html(data.size);K(row[0].insertCell(2)).addClass('ke-cell ke-datetime').html(data.time);}}function createView(result){createCommon(result,createView);var fileList=result.store;for(var i=0,len=fileList.length;i<len;i++){var data=fileList[i],div=K('<div class="ke-inline-block ke-item"></div>');bodyDiv.append(div);var photoDiv=K('<div class="ke-inline-block ke-photo"></div>').mouseover(function(e){K(this).addClass('ke-on');}).mouseout(function(e){K(this).removeClass('ke-on');});div.append(photoDiv);var fileUrl=data.url,iconUrl=data.isImage==1?fileUrl:imgPath+'file-64.gif';var img=K('<img src="'+iconUrl+'" width="80" height="80" alt="'+data.name+'" />');photoDiv.css('cursor','pointer');bindTitle(photoDiv,data);bindEvent(photoDiv,result,data,createView);photoDiv.append(img);div.append('<div class="ke-name" title="'+data.name+'">'+data.name+'</div>');}}viewTypeBox.val(viewType);reloadPage(viewParam,orderTypeBox.val(),viewType=='VIEW'?createView:createList);return dialog;}});