-- ----------------------------
--  Table structure for `jspgen_ad`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_ad`;
CREATE TABLE `jspgen_ad` (
  `id` varchar(32) NOT NULL,
  `adarea_id` varchar(32) NOT NULL,
  `name` varchar(30) NOT NULL,
  `genre` varchar(20) default 'file',
  `file` varchar(100) default NULL,
  `code` varchar(255) default NULL,
  `url` varchar(100) default NULL,
  `status` int(1) default '0',
  `start_time` bigint(13) default NULL,
  `end_time` bigint(13) default NULL,
  `pv` int(10) default '0',
  `clicks` int(10) default '0',
  `sort` int(3) default '60',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_adarea`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_adarea`;
CREATE TABLE `jspgen_adarea` (
  `id` varchar(32) NOT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(255) default NULL,
  `width` int(5) default NULL,
  `height` int(5) default NULL,
  `template` varchar(100) default NULL,
  `status` int(1) default '0',
  `index` int(3) default '0',
  `posts` int(11) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_admin`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_admin`;
CREATE TABLE `jspgen_admin` (
  `id` varchar(32) NOT NULL,
  `role_id` varchar(32) NOT NULL,
  `department_id` varchar(32) default NULL,
  `name` varchar(50) NOT NULL,
  `is_disabled` int(1) default '0',
  `time` bigint(13) default NULL,
  `remark` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `role_id` (`role_id`),
  KEY `department_id` (`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_admin_role`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_admin_role`;
CREATE TABLE `jspgen_admin_role` (
  `id` varchar(32) NOT NULL,
  `name` varchar(50) NOT NULL,
  `sort` int(3) default '0',
  `is_default` int(1) default '0',
  `is_system` int(1) default '0',
  `purview` text,
  `remark` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_article`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_article`;
CREATE TABLE `jspgen_article` (
  `id` varchar(32) NOT NULL,
  `subtitle` varchar(120) default NULL,
  `author` varchar(50) default NULL,
  `content` longtext,
  `page_title` varchar(255) default NULL,
  `words_count` int(5) default '0',
  `payment_price` decimal(10,2) default '0.00',
  `payment` decimal(10,2) default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_attachment`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_attachment`;
CREATE TABLE `jspgen_attachment` (
  `id` varchar(32) NOT NULL,
  `app_id` varchar(20) default NULL,
  `folder_id` varchar(32) default NULL,
  `user_id` varchar(32) NOT NULL,
  `name` varchar(255) default NULL,
  `keywords` varchar(255) default NULL,
  `description` text,
  `is_open` int(1) default '0',
  `is_image` int(1) default '0',
  `config_name` varchar(50) default NULL,
  `psn_url` varchar(100) default NULL,
  `file_name` varchar(150) default NULL,
  `file_path` varchar(150) NOT NULL,
  `file_exte` varchar(10) NOT NULL,
  `file_length` bigint(13) default '0',
  `file_exif` text,
  `thumb_store` text,
  `water_store` text,
  `copy_store` text,
  `downloads` bigint(13) default '0',
  `ip` varchar(15) NOT NULL,
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`),
  KEY `app_id` (`app_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_attachment_folder`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_attachment_folder`;
CREATE TABLE `jspgen_attachment_folder` (
  `id` varchar(32) NOT NULL,
  `user_id` varchar(32) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` text,
  `sort` int(3) default '0',
  `is_lock` int(1) default '0',
  `password` varchar(32) NOT NULL,
  `time` bigint(13) default NULL,
  `last_time` bigint(13) default NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_commend`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_commend`;
CREATE TABLE `jspgen_commend` (
  `id` varchar(32) NOT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(255) default NULL,
  `template` varchar(100) default NULL,
  `posts` int(11) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_commend_data`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_commend_data`;
CREATE TABLE `jspgen_commend_data` (
  `id` varchar(32) NOT NULL,
  `commend_id` varchar(32) NOT NULL,
  `content_id` varchar(32) default NULL,
  `title` varchar(80) NOT NULL,
  `thumb` varchar(150) default NULL,
  `url` varchar(150) default NULL,
  `time` bigint(13) default NULL,
  `sort` int(3) default '0',
  PRIMARY KEY  (`id`),
  KEY `commend_id` (`commend_id`),
  KEY `content_id` (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_content`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_content`;
CREATE TABLE `jspgen_content` (
  `id` varchar(32) NOT NULL,
  `node_id` varchar(32) NOT NULL,
  `model_id` varchar(32) NOT NULL,
  `area_id` varchar(32) default NULL,
  `department_id` varchar(32) default NULL,
  `title` varchar(150) NOT NULL,
  `color` varchar(7) default NULL,
  `thumb` varchar(150) default NULL,
  `tags` varchar(60) default NULL,
  `source` varchar(100) default NULL,
  `editor` varchar(15) default NULL,
  `description` varchar(255) default NULL,
  `var` varchar(255) default NULL,
  `reference` varchar(32) default NULL,
  `link` varchar(100) default NULL,
  `url` varchar(100) default NULL,
  `sort` int(3) default '60',
  `status` int(1) NOT NULL default '6',
  `template` varchar(100) default NULL,
  `time` bigint(13) default NULL,
  `user_id` varchar(32) NOT NULL,
  `modify_time` bigint(13) default NULL,
  `publish_time` bigint(13) default NULL,
  `unpublish_time` bigint(13) default NULL,
  `is_html` int(1) default '0',
  `is_lock` int(1) default '0',
  `is_note` int(1) default '0',
  `workflow_step` int(1) default NULL,
  `workflow_role_id` varchar(32) default NULL,
  `pv` int(10) default '0',
  `agree` int(10) default '0',
  `disagree` int(10) default '0',
  `commend` int(10) default '0',
  `related` int(10) default '0',
  `is_more` int(1) default '0',
  `is_contribute` int(1) default '0',
  `is_comment` int(1) default '0',
  `comment` int(5) default '0',
  PRIMARY KEY  (`id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_content_log`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_content_log`;
CREATE TABLE `jspgen_content_log` (
  `id` varchar(32) NOT NULL,
  `content_id` varchar(32) NOT NULL,
  `action` varchar(10) NOT NULL,
  `info` varchar(255) default NULL,
  `ip` varchar(15) NOT NULL,
  `time` bigint(13) default NULL,
  `user_id` varchar(32) default NULL,
  PRIMARY KEY  (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_content_tag`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_content_tag`;
CREATE TABLE `jspgen_content_tag` (
  `id` varchar(32) NOT NULL,
  `content_id` varchar(32) default NULL,
  `tag_id` varchar(32) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `content_id` (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_department`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_department`;
CREATE TABLE `jspgen_department` (
  `id` varchar(32) NOT NULL,
  `parent_id` varchar(32) default NULL,
  `name` varchar(50) default NULL,
  `fullname` varchar(100) default NULL,
  `corporation` varchar(50) default NULL,
  `description` text,
  `url` varchar(150) default NULL,
  `tel` varchar(15) default NULL,
  `fax` varchar(15) default NULL,
  `email` varchar(50) default NULL,
  `address` varchar(150) default NULL,
  `sort` int(3) default '0',
  `is_parent` int(1) default '0',
  `is_hide` int(1) default '0',
  `level` int(11) default '0',
  `path` text,
  `childids` text,
  PRIMARY KEY  (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_dictionary`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_dictionary`;
CREATE TABLE `jspgen_dictionary` (
  `id` varchar(32) NOT NULL,
  `parent_id` varchar(32) default NULL,
  `name` varchar(20) NOT NULL,
  `value` varchar(50) default NULL,
  `remark` varchar(255) default NULL,
  `sort` int(3) default '0',
  `is_parent` int(1) default '0',
  `is_hide` int(1) default '0',
  `level` int(11) default '0',
  `path` text,
  `childids` text,
  PRIMARY KEY  (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_filterword`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_filterword`;
CREATE TABLE `jspgen_filterword` (
  `id` varchar(32) NOT NULL,
  `pattern` varchar(100) NOT NULL,
  `replacement` varchar(100) NOT NULL,
  `sort` int(11) default NULL,
  `time` bigint(13) default NULL,
  `user_id` varchar(32) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `pattern` (`pattern`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_guestbook`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_guestbook`;
CREATE TABLE `jspgen_guestbook` (
  `id` varchar(32) NOT NULL,
  `department_id` varchar(32) default NULL,
  `admin_id` varchar(32) default NULL,
  `category` varchar(20) default NULL,
  `subject` varchar(50) NOT NULL,
  `content` text,
  `is_public` int(1) default '0',
  `name` varchar(50) NOT NULL,
  `email` varchar(40) default NULL,
  `phone` varchar(11) default NULL,
  `ip` varchar(15) default NULL,
  `user_id` varchar(32) default NULL,
  `time` bigint(13) default NULL,
  `status` int(1) default '0',
  `reply` text,
  `reply_user_id` varchar(32) default NULL,
  `reply_time` bigint(13) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_id`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_id`;
CREATE TABLE `jspgen_id` (
  `id` bigint(13) NOT NULL,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY  (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_keyword`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_keyword`;
CREATE TABLE `jspgen_keyword` (
  `id` varchar(32) NOT NULL,
  `name` varchar(50) NOT NULL,
  `url` varchar(255) NOT NULL,
  `sort` int(3) default NULL,
  `time` bigint(13) default NULL,
  `user_id` varchar(32) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_log`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_log`;
CREATE TABLE `jspgen_log` (
  `id` varchar(32) NOT NULL,
  `user_id` varchar(32) default NULL,
  `operator` varchar(15) NOT NULL,
  `operation` varchar(50) default NULL,
  `info` text,
  `ip` varchar(15) NOT NULL,
  `time` bigint(13) default NULL,
  `remark` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `operator` (`operator`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_login_log`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_login_log`;
CREATE TABLE `jspgen_login_log` (
  `id` varchar(32) NOT NULL,
  `user_id` varchar(32) NOT NULL,
  `third_name` varchar(100) default NULL,
  `ip` varchar(15) NOT NULL,
  `time` bigint(13) default NULL,
  `status` int(1) default '0',
  `remark` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`),
  KEY `third_name` (`third_name`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_model`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_model`;
CREATE TABLE `jspgen_model` (
  `id` varchar(32) NOT NULL,
  `name` varchar(20) NOT NULL,
  `description` varchar(255) default NULL,
  `template` varchar(100) default NULL,
  `is_template` int(1) default '0',
  `is_disabled` int(1) default '0',
  `is_system` int(1) default '0',
  `time` bigint(13) default NULL,
  `release` bigint(13) default '0',
  `sort` int(2) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_node`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_node`;
CREATE TABLE `jspgen_node` (
  `id` varchar(32) NOT NULL,
  `parent_id` varchar(32) default NULL,
  `name` varchar(20) NOT NULL,
  `alias` varchar(20) NOT NULL,
  `is_parent` int(1) default '0',
  `level` int(11) default '0',
  `path` text,
  `childids` text,
  `thumb` varchar(150) default NULL,
  `tags` varchar(255) default NULL,
  `description` varchar(255) default NULL,
  `workflow_id` varchar(32) default NULL,
  `is_contribute` int(1) default '0',
  `is_comment` int(1) default '0',
  `is_hide` int(1) default '0',
  `model` text,
  `template` varchar(100) default NULL,
  `is_html` int(1) default '0',
  `url` varchar(100) default NULL,
  `psn` varchar(100) default NULL,
  `url_rule` varchar(100) default NULL,
  `url_rule_show` varchar(100) default NULL,
  `posts` int(10) default '0',
  `comments` int(10) default '0',
  `pv` int(10) default '0',
  `sort` int(3) default '0',
  PRIMARY KEY  (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_node_allow`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_node_allow`;
CREATE TABLE `jspgen_node_allow` (
  `id` varchar(32) NOT NULL,
  `name` varchar(50) NOT NULL,
  `remark` varchar(255) default NULL,
  `node_ids` text,
  `node_names` text,
  `show_review` int(1) default '0',
  `show_data` int(1) default '0',
  `time` bigint(13) default NULL,
  `user_id` varchar(32) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_note`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_note`;
CREATE TABLE `jspgen_note` (
  `id` varchar(32) NOT NULL,
  `user_id` varchar(32) NOT NULL,
  `subject` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_online`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_online`;
CREATE TABLE `jspgen_online` (
  `id` varchar(32) NOT NULL,
  `user_id` varchar(32) default NULL,
  `place` varchar(50) default NULL,
  `url` varchar(100) default NULL,
  `browser` varchar(50) default NULL,
  `ip` varchar(15) NOT NULL,
  `time` bigint(13) default NULL,
  `last_time` bigint(13) default NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_online_max`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_online_max`;
CREATE TABLE `jspgen_online_max` (
  `id` varchar(32) NOT NULL,
  `user_id` varchar(32) default NULL,
  `ip` varchar(15) NOT NULL,
  `count` bigint(13) default NULL,
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_purview`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_purview`;
CREATE TABLE `jspgen_purview` (
  `id` varchar(32) NOT NULL,
  `app_id` varchar(20) default NULL,
  `parent_id` varchar(32) default NULL,
  `name` varchar(20) NOT NULL,
  `sort` int(3) default '0',
  `is_parent` int(1) default '0',
  `is_hide` int(1) default '0',
  `url` varchar(100) default NULL,
  `target` varchar(10) default NULL,
  `type` varchar(20) default NULL,
  `level` int(11) default '0',
  `path` text,
  `childids` text,
  PRIMARY KEY  (`id`),
  KEY `app_id` (`app_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_related`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_related`;
CREATE TABLE `jspgen_related` (
  `id` varchar(32) NOT NULL,
  `related_content_id` varchar(32) NOT NULL,
  `content_id` varchar(32) default NULL,
  `title` varchar(80) NOT NULL,
  `thumb` varchar(100) default NULL,
  `url` varchar(255) default NULL,
  `time` bigint(13) default NULL,
  `sort` int(3) default '0',
  PRIMARY KEY  (`id`),
  KEY `related_content_id` (`related_content_id`),
  KEY `content_id` (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_searchword`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_searchword`;
CREATE TABLE `jspgen_searchword` (
  `id` varchar(32) NOT NULL,
  `genre` varchar(32) default NULL,
  `name` varchar(100) NOT NULL,
  `content` varchar(255) default NULL,
  `pv` int(10) default '0',
  `status` int(1) default '1',
  `sort` int(3) default '60',
  `time` bigint(13) default NULL,
  `user_id` varchar(32) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_source`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_source`;
CREATE TABLE `jspgen_source` (
  `id` varchar(32) NOT NULL,
  `name` char(40) NOT NULL,
  `logo` char(100) default NULL,
  `url` char(100) default NULL,
  `count` int(8) default '0',
  `sort` int(3) default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_sys_mail`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_sys_mail`;
CREATE TABLE `jspgen_sys_mail` (
  `id` varchar(32) NOT NULL,
  `admin_id` varchar(32) NOT NULL,
  `admin_name` varchar(50) default NULL,
  `to` varchar(32) default NULL,
  `subject` varchar(100) default NULL,
  `content` text,
  `status` int(1) default '0',
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`),
  KEY `admin_id` (`admin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_sys_sms`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_sys_sms`;
CREATE TABLE `jspgen_sys_sms` (
  `id` varchar(32) NOT NULL,
  `admin_id` varchar(32) NOT NULL,
  `admin_name` varchar(50) default NULL,
  `to` varchar(11) default NULL,
  `subject` varchar(100) default NULL,
  `content` text,
  `status` int(1) default '0',
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`),
  KEY `admin_id` (`admin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_sys_ums`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_sys_ums`;
CREATE TABLE `jspgen_sys_ums` (
  `id` varchar(32) NOT NULL,
  `admin_id` varchar(32) NOT NULL,
  `admin_name` varchar(50) default NULL,
  `group_id` varchar(32) default NULL,
  `group_name` varchar(50) default NULL,
  `role_id` varchar(32) default NULL,
  `role_name` varchar(50) default NULL,
  `subject` varchar(100) default NULL,
  `content` text,
  `url` varchar(200) default NULL,
  `stat` bigint(13) default '0',
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`),
  KEY `admin_id` (`admin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_sys_ums_user`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_sys_ums_user`;
CREATE TABLE `jspgen_sys_ums_user` (
  `id` varchar(32) NOT NULL,
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_tag`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_tag`;
CREATE TABLE `jspgen_tag` (
  `id` varchar(32) NOT NULL,
  `name` char(16) NOT NULL,
  `count` int(8) default '0',
  `time` bigint(13) default NULL,
  `pv` int(10) default '0',
  `sort` int(3) default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_ums`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_ums`;
CREATE TABLE `jspgen_ums` (
  `id` varchar(32) NOT NULL,
  `from_id` varchar(32) NOT NULL,
  `from_name` varchar(20) default NULL,
  `to_id` varchar(32) default NULL,
  `to_name` varchar(20) default NULL,
  `sys_id` varchar(32) default NULL,
  `top_id` varchar(32) default NULL,
  `subject` varchar(100) default NULL,
  `content` text,
  `url` varchar(200) default NULL,
  `is_read` int(1) default '0',
  `is_delete` int(1) default '0',
  `time` bigint(13) default NULL,
  `last_time` bigint(13) default NULL,
  PRIMARY KEY  (`id`),
  KEY `from_id` (`from_id`),
  KEY `to_id` (`to_id`),
  KEY `top_id` (`top_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_user`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_user`;
CREATE TABLE `jspgen_user` (
  `id` varchar(32) NOT NULL,
  `username` varchar(20) default NULL,
  `password` varchar(20) NOT NULL,
  `salt` varchar(6) default NULL,
  `email` varchar(40) default NULL,
  `email_verify` int(1) default '0',
  `mobile` varchar(11) default NULL,
  `mobile_verify` int(1) default '0',
  `avatar` varchar(100) default NULL,
  `group_id` varchar(32) default '000',
  `invite` varchar(32) default NULL,
  `reg_ip` varchar(15) NOT NULL,
  `reg_time` bigint(13) NOT NULL,
  `count` int(10) default '0',
  `last_ip` varchar(15) default NULL,
  `last_time` bigint(13) default NULL,
  `login_ip` varchar(15) default NULL,
  `login_time` bigint(13) default NULL,
  `wkt` longtext,
  `login_failure_count` int(5) default '0',
  `is_repeated` int(1) default '0',
  `is_lock` int(1) default '0',
  `lock_time` bigint(13) default NULL,
  `lock_expiry` int(10) default '0',
  PRIMARY KEY  (`id`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_user_detail`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_user_detail`;
CREATE TABLE `jspgen_user_detail` (
  `id` varchar(32) NOT NULL,
  `nickname` varchar(50) NOT NULL,
  `sign` varchar(100) default NULL,
  `keywords` varchar(255) default NULL,
  `description` varchar(255) default NULL,
  `credit` int(11) default '0',
  `score` int(11) default '0',
  `gold` int(11) default '0',
  `deposit` decimal(15,5) default NULL,
  `auth` varchar(32) default NULL,
  `remark` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_user_group`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_user_group`;
CREATE TABLE `jspgen_user_group` (
  `id` varchar(32) NOT NULL,
  `name` varchar(50) NOT NULL,
  `sort` int(3) default '0',
  `is_default` int(1) default '0',
  `is_system` int(1) default '0',
  `purview` text,
  `remark` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_user_token`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_user_token`;
CREATE TABLE `jspgen_user_token` (
  `id` varchar(32) NOT NULL,
  `name` varchar(50) NOT NULL,
  `purview` text,
  `token` varchar(200) default NULL,
  `token_time` bigint(13) default NULL,
  `token_expiry` int(10) default '0',
  `count` int(10) default '0',
  `stat` int(10) default '0',
  `status` int(3) default '0',
  `time` bigint(13) default NULL,
  `user_id` varchar(32) default NULL,
  `remark` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `token` (`id`,`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_wechat`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_wechat`;
CREATE TABLE `jspgen_wechat` (
  `id` varchar(32) NOT NULL,
  `name` varchar(150) default NULL,
  `appid` varchar(100) NOT NULL,
  `appsecret` varchar(150) default NULL,
  `token` varchar(300) default NULL,
  `tokenexpires` bigint(13) default NULL,
  `tokentime` bigint(13) default NULL,
  `ticket` varchar(300) default NULL,
  `ticketexpires` bigint(13) default NULL,
  `tickettime` bigint(13) default NULL,
  `fans` int(5) default '0',
  `fanslast` bigint(13) default NULL,
  `templast` bigint(13) default NULL,
  `openid` varchar(50) default NULL,
  `nickname` varchar(150) default NULL,
  `time` bigint(13) default NULL,
  `user_id` varchar(32) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_wechat_fans`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_wechat_fans`;
CREATE TABLE `jspgen_wechat_fans` (
  `id` varchar(32) NOT NULL,
  `appid` varchar(100) NOT NULL,
  `subs` int(1) default '0',
  `openid` varchar(100) NOT NULL,
  `nickname` varchar(150) default NULL,
  `sex` int(1) default '0',
  `country` varchar(100) default NULL,
  `province` varchar(100) default NULL,
  `city` varchar(100) default NULL,
  `lang` varchar(20) default 'zh_CN',
  `headurl` varchar(255) default NULL,
  `substime` bigint(13) default NULL,
  `unionid` varchar(32) default NULL,
  `remark` varchar(100) default NULL,
  `groupid` varchar(50) default NULL,
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_wechat_send`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_wechat_send`;
CREATE TABLE `jspgen_wechat_send` (
  `id` varchar(32) NOT NULL,
  `appid` varchar(100) NOT NULL,
  `tempid` varchar(100) NOT NULL,
  `title` varchar(150) default NULL,
  `color` varchar(50) default NULL,
  `url` varchar(150) default NULL,
  `data` text,
  `show` text,
  `status` int(1) default '0',
  `groupid` varchar(50) default NULL,
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_wechat_sendlog`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_wechat_sendlog`;
CREATE TABLE `jspgen_wechat_sendlog` (
  `id` varchar(32) NOT NULL,
  `appid` varchar(100) NOT NULL,
  `tempid` varchar(100) NOT NULL,
  `openid` varchar(100) NOT NULL,
  `nickname` varchar(150) default NULL,
  `status` int(1) default '0',
  `resp` text,
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `jspgen_wechat_temp`
-- ----------------------------
DROP TABLE IF EXISTS `jspgen_wechat_temp`;
CREATE TABLE `jspgen_wechat_temp` (
  `id` varchar(32) NOT NULL,
  `appid` varchar(100) NOT NULL,
  `tempid` varchar(100) NOT NULL,
  `title` varchar(150) default NULL,
  `prima` varchar(50) default NULL,
  `deput` varchar(50) default NULL,
  `content` text,
  `example` text,
  `time` bigint(13) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Records 
-- ----------------------------
INSERT INTO `jspgen_admin` VALUES ('1','1','1','JSPGen','0',NULL,NULL), ('2','2','1','管理员','0','1463218815328',NULL);
INSERT INTO `jspgen_admin_role` VALUES ('1','系统维护员','0','0','1',NULL,NULL), ('2','系统管理员','60','1','1','1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,170,19,20,21,22,23,24,25,36,37,38,39,40,41,42,49,50,51,52,53,54,55,56,57,67,68,69,70,71,72',NULL);
INSERT INTO `jspgen_department` VALUES ('1','0','总部',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'60','1','0','0','1','2,3'), ('2','1','陕西分部',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'60','0','0','1','1,2',NULL), ('3','1','上海分部',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'60','0','0','1','1,3',NULL);
INSERT INTO `jspgen_dictionary` VALUES ('1','0','留言板',NULL,NULL,'0','1','0','0','1','2,3'), ('2','1','默认','默认',NULL,'0','0','0','1','1,2',NULL), ('3','1','意见反馈','意见反馈',NULL,'0','0','0','1','1,3',NULL), ('4','0','搜索词',NULL,NULL,'0','1','0','0','4','5'), ('5','4','默认','默认',NULL,'0','0','0','1','4,5',NULL);
INSERT INTO `jspgen_id` VALUES ('173','purview');
INSERT INTO `jspgen_model` VALUES ('article','文章','文章','/model/article/show.jsp','1','0','0','0','0','0'), ('link','链接','链接','/model/link/show.jsp','0','0','0','0','0','1');
INSERT INTO `jspgen_purview` VALUES ('1','jspgen','0','我','0','1','0',NULL,NULL,'admin','0','1','2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18'), ('10','jspgen','1','消息回复','0','0','1','/admin/i_ums!reply.gen',NULL,NULL,'1','1,10',NULL), ('100','cms','83','搜索','0','0','0','/cms/admin/content!search.gen',NULL,NULL,'1','83,100',NULL), ('101','cms','83','转移','0','0','0','/cms/admin/content!movenode.gen',NULL,NULL,'1','83,101',NULL), ('102','cms','83','文章查看','0','0','1','/cms/admin/model/article!view.gen',NULL,NULL,'1','83,102',NULL), ('103','cms','83','文章添加','0','0','1','/cms/admin/model/article!add.gen',NULL,NULL,'1','83,103',NULL), ('104','cms','83','文章添加_提交','0','0','1','/cms/admin/model/article!save.gen',NULL,NULL,'1','83,104',NULL), ('105','cms','83','文章编辑','0','0','1','/cms/admin/model/article!edit.gen',NULL,NULL,'1','83,105',NULL), ('106','cms','83','文章编辑_提交','0','0','1','/cms/admin/model/article!update.gen',NULL,NULL,'1','83,106',NULL), ('107','cms','83','文章复制','0','0','1','/cms/admin/model/article!copy.gen',NULL,NULL,'1','83,107',NULL), ('108','cms','83','文章生成','0','0','1','/cms/admin/model/article!html.gen',NULL,NULL,'1','83,108',NULL), ('109','cms','83','文章删除','0','0','1','/cms/admin/model/article!delete.gen',NULL,NULL,'1','83,109',NULL), ('11','jspgen','1','我的便签','0','0','0','/admin/i_note!list.gen',NULL,NULL,'1','1,11',NULL), ('110','cms','83','推荐位','0','0','0','/cms/admin/commend!list.gen',NULL,NULL,'1','83,110',NULL), ('111','cms','83','推荐位删除','0','0','1','/cms/admin/commend!delete.gen',NULL,NULL,'1','83,111',NULL), ('112','cms','83','推荐位添加','0','0','1','/cms/admin/commend!add.gen',NULL,NULL,'1','83,112',NULL), ('113','cms','83','推荐位添加_提交','0','0','1','/cms/admin/commend!save.gen',NULL,NULL,'1','83,113',NULL), ('114','cms','83','推荐位编辑','0','0','1','/cms/admin/commend!edit.gen',NULL,NULL,'1','83,114',NULL), ('115','cms','83','推荐位编辑_提交','0','0','1','/cms/admin/commend!update.gen',NULL,NULL,'1','83,115',NULL), ('116','cms','83','广告位','0','0','0','/cms/admin/adarea!list.gen',NULL,NULL,'1','83,116',NULL), ('117','cms','83','广告位删除','0','0','1','/cms/admin/adarea!delete.gen',NULL,NULL,'1','83,117',NULL), ('118','cms','83','广告位添加','0','0','1','/cms/admin/adarea!add.gen',NULL,NULL,'1','83,118',NULL), ('119','cms','83','广告位添加_提交','0','0','1','/cms/admin/adarea!save.gen',NULL,NULL,'1','83,119',NULL), ('12','jspgen','1','便签查看','0','0','1','/admin/i_note!view.gen',NULL,NULL,'1','1,12',NULL), ('120','cms','83','广告位编辑','0','0','1','/cms/admin/adarea!edit.gen',NULL,NULL,'1','83,120',NULL), ('121','cms','83','广告位编辑_提交','0','0','1','/cms/admin/adarea!update.gen',NULL,NULL,'1','83,121',NULL), ('122','cms','83','上传文件','0','0','0','/cms/admin/upload!list.gen',NULL,NULL,'1','83,122',NULL), ('123','cms','83','上传选择 ','0','0','1','/cms/admin/upload!choose.gen',NULL,NULL,'1','83,123',NULL), ('124','cms','83','上传删除','0','0','1','/cms/admin/upload!delete.gen',NULL,NULL,'1','83,124',NULL), ('125','cms','83','上传文件','0','0','1','/cms/admin/upload!add.gen',NULL,NULL,'1','83,125',NULL), ('126','cms','83','上传文件_提交','0','0','1','/cms/admin/upload!save.gen',NULL,NULL,'1','83,126',NULL), ('127','cms','83','首页静态化','0','0','1','/cms/admin/html!indexdo.gen',NULL,NULL,'1','83,127',NULL), ('128','cms','83','节点静态化','0','0','1','/cms/admin/html!node.gen',NULL,NULL,'1','83,128',NULL), ('129','cms','83','内容静态化','0','0','1','/cms/admin/html!content.gen',NULL,NULL,'1','83,129',NULL), ('13','jspgen','1','便签删除','0','0','1','/admin/i_note!delete.gen',NULL,NULL,'1','1,13',NULL), ('130','cms','83','整站静态化','0','0','1','/cms/admin/html!site.gen',NULL,NULL,'1','83,130',NULL), ('131','cms','0','模板','3','1','0',NULL,NULL,'admin','0','131','132,133,134,135,136,137'), ('132','cms','131','模板管理','0','0','0','/cms/admin/template!list.gen',NULL,NULL,'1','131,132',NULL), ('133','cms','131','模板选择','0','0','1','/cms/admin/template!choose.gen',NULL,NULL,'1','131,133',NULL), ('134','cms','131','模板删除','0','0','1','/cms//admin/template!delete.gen',NULL,NULL,'1','131,134',NULL), ('135','cms','131','模板添加','0','0','1','/cms/admin/template!add.gen',NULL,NULL,'1','131,135',NULL), ('136','cms','131','模板编辑','0','0','1','/cms/admin/template!edit.gen',NULL,NULL,'1','131,136',NULL), ('137','cms','131','模板添加编辑_提交','0','0','1','/cms/admin/template!save.gen',NULL,NULL,'1','131,137',NULL), ('138','cms','0','设置','4','1','0',NULL,NULL,'admin','0','138','139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169'), ('139','cms','138','过滤词','0','0','0','/cms/admin/filterword!list.gen',NULL,NULL,'1','138,139',NULL), ('14','jspgen','1','便签添加','0','0','1','/admin/i_note!add.gen',NULL,NULL,'1','1,14',NULL), ('140','cms','138','过滤词删除','0','0','1','/cms/admin/filterword!delete.gen',NULL,NULL,'1','138,140',NULL), ('141','cms','138','过滤词添加','0','0','1','/cms/admin/filterword!add.gen',NULL,NULL,'1','138,141',NULL), ('142','cms','138','过滤词添加_提交','0','0','1','/cms/admin/filterword!save.gen',NULL,NULL,'1','138,142',NULL), ('143','cms','138','过滤词编辑','0','0','1','/cms/admin/filterword!edit.gen',NULL,NULL,'1','138,143',NULL), ('144','cms','138','过滤词编辑_提交','0','0','1','/cms/admin/filterword!update.gen',NULL,NULL,'1','138,144',NULL), ('145','cms','138','关键词','0','0','0','/cms/admin/keyword!list.gen',NULL,NULL,'1','138,145',NULL), ('146','cms','138','关键词删除','0','0','1','/cms/admin/keyword!delete.gen',NULL,NULL,'1','138,146',NULL), ('147','cms','138','关键词添加','0','0','1','/cms/admin/keyword!add.gen',NULL,NULL,'1','138,147',NULL), ('148','cms','138','关键词添加_提交','0','0','1','/cms/admin/keyword!save.gen',NULL,NULL,'1','138,148',NULL), ('149','cms','138','关键词编辑','0','0','1','/cms/admin/keyword!edit.gen',NULL,NULL,'1','138,149',NULL), ('15','jspgen','1','便签添加_提交','0','0','1','/admin/i_note!save.gen',NULL,NULL,'1','1,15',NULL), ('150','cms','138','关键词编辑_提交','0','0','1','/cms/admin/keyword!update.gen',NULL,NULL,'1','138,150',NULL), ('151','cms','138','内容标签','0','0','0','/cms/admin/tag!list.gen',NULL,NULL,'1','138,151',NULL), ('152','cms','138','内容标签删除','0','0','1','/cms/admin/tag!delete.gen',NULL,NULL,'1','138,152',NULL), ('153','cms','138','内容标签添加','0','0','1','/cms/admin/tag!add.gen',NULL,NULL,'1','138,153',NULL), ('154','cms','138','内容标签添加_提交','0','0','1','/cms/admin/tag!save.gen',NULL,NULL,'1','138,154',NULL), ('155','cms','138','内容标签编辑','0','0','1','/cms/admin/tag!edit.gen',NULL,NULL,'1','138,155',NULL), ('156','cms','138','内容标签编辑_提交','0','0','1','/cms/admin/tag!update.gen',NULL,NULL,'1','138,156',NULL), ('157','cms','138','内容来源','0','0','0','/cms/admin/source!list.gen',NULL,NULL,'1','138,157',NULL), ('158','cms','138','内容来源删除','0','0','1','/cms/admin/source!delete.gen',NULL,NULL,'1','138,158',NULL), ('159','cms','138','内容来源添加','0','0','1','/cms/admin/source!add.gen',NULL,NULL,'1','138,159',NULL), ('16','jspgen','1','便签修改','0','0','1','/admin/i_note!edit.gen',NULL,NULL,'1','1,16',NULL), ('160','cms','138','内容来源添加_提交','0','0','1','/cms/admin/source!save.gen',NULL,NULL,'1','138,160',NULL), ('161','cms','138','内容来源编辑','0','0','1','/cms/admin/source!edit.gen',NULL,NULL,'1','138,161',NULL), ('162','cms','138','内容来源编辑_提交','0','0','1','/cms/admin/source!update.gen',NULL,NULL,'1','138,162',NULL), ('163','cms','138','节点权限','60','0','0','/cms/admin/node_allow!list.gen',NULL,NULL,'1','138,163',NULL), ('164','cms','138','节点权限删除','60','0','1','/cms//admin/node_allow!delete.gen',NULL,NULL,'1','138,164',NULL), ('165','cms','138','节点权限添加','60','0','1','/cms/admin/node_allow!add.gen',NULL,NULL,'1','138,165',NULL), ('166','cms','138','节点权限添加_提交','60','0','1','/cms/admin/node_allow!save.gen',NULL,NULL,'1','138,166',NULL), ('167','cms','138','节点权限编辑','60','0','1','/cms/admin/node_allow!edit.gen',NULL,NULL,'1','138,167',NULL), ('168','cms','138','节点权限编辑_提交','60','0','1','/cms/admin/node_allow!update.gen',NULL,NULL,'1','138,168',NULL), ('169','cms','138','模型管理','60','0','0','/cms/admin/model!list.gen',NULL,NULL,'1','138,169',NULL), ('17','jspgen','1','便签修改_提交','0','0','1','/admin/i_note!update.gen',NULL,NULL,'1','1,17',NULL), ('170','cms','83','删除临时文件','60','0','0','/core!deleteTemp.gen',NULL,'admin','1','83,170',NULL), ('171','cms','138','用户令牌','60','0','0','/admin/user_token!list.gen',NULL,'admin','1','138,171',NULL), ('172','cms','138','微信公众号','60','0','0','/wechat/admin/wechat!list.gen',NULL,'admin','1','138,172',NULL), ('173','cms','138','搜索词','60','0','0','/cms/admin/searchword!list.gen',NULL,NULL,'1','138,173',NULL), ('18','jspgen','1','退出','0','0','1','/user!logout.gen',NULL,NULL,'1','1,18',NULL), ('19','jspgen','0','系统','60','1','0',NULL,NULL,'admin','0','19','20,36,42,74,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,37,38,39,40,41,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,75,76,77,78,79,80,81,82'), ('2','jspgen','1','欢迎页','0','0','1','/admin/index.gen',NULL,NULL,'1','1,2',NULL), ('20','jspgen','19','消息区','0','1','0',NULL,NULL,NULL,'1','19,20','21,22,23,24,25,26,27,28,29,30,31,32,33,34,35'), ('21','jspgen','20','系统消息','0','0','0','/admin/sys_ums!list.gen',NULL,NULL,'2','19,20,21',NULL), ('22','jspgen','20','系统消息查看','0','0','1','/admin/sys_ums!view.gen',NULL,NULL,'2','19,20,22',NULL), ('23','jspgen','20','系统消息删除','0','0','1','/admin/sys_ums!delete.gen',NULL,NULL,'2','19,20,23',NULL), ('24','jspgen','20','系统消息发送','0','0','1','/admin/sys_ums!add.gen',NULL,NULL,'2','19,20,24',NULL), ('25','jspgen','20','系统消息发送_提交','0','0','1','/admin/sys_ums!save.gen',NULL,NULL,'2','19,20,25',NULL), ('26','jspgen','20','系统邮件','0','0','0','/admin/sys_mail!list.gen',NULL,NULL,'2','19,20,26',NULL), ('27','jspgen','20','系统邮件查看','0','0','1','/admin/sys_mail!view.gen',NULL,NULL,'2','19,20,27',NULL), ('28','jspgen','20','系统邮件删除','0','0','1','/admin/sys_mail!delete.gen',NULL,NULL,'2','19,20,28',NULL), ('29','jspgen','20','系统邮件发送','0','0','1','/admin/sys_mail!post.gen',NULL,NULL,'2','19,20,29',NULL), ('3','jspgen','1','我的信息','0','0','0','/admin/i_user!view.gen',NULL,NULL,'1','1,3',NULL), ('30','jspgen','20','系统邮件发送_提交','0','0','1','/admin/sys_mail!save.gen',NULL,NULL,'2','19,20,30',NULL), ('31','jspgen','20','系统短信','0','0','0','/admin/sys_sms!list.gen',NULL,NULL,'2','19,20,31',NULL), ('32','jspgen','20','系统短信查看','0','0','1','/admin/sys_sms!view.gen',NULL,NULL,'2','19,20,32',NULL);
INSERT INTO `jspgen_purview` VALUES ('33','jspgen','20','系统短信删除','0','0','1','/admin/sys_sms!delete.gen',NULL,NULL,'2','19,20,33',NULL), ('34','jspgen','20','系统短信发送','0','0','1','/admin/sys_sms!post.gen',NULL,NULL,'2','19,20,34',NULL), ('35','jspgen','20','系统短信发送_提交','0','0','1','/admin/sys_sms!save.gen',NULL,NULL,'2','19,20,35',NULL), ('36','jspgen','19','留言区','0','1','0',NULL,NULL,NULL,'1','19,36','37,38,39,40,41'), ('37','jspgen','36','留言管理','0','0','0','/admin/guestbook!list.gen',NULL,NULL,'2','19,36,37',NULL), ('38','jspgen','36','留言删除','0','0','1','/admin/guestbook!delete.gen',NULL,NULL,'2','19,36,38',NULL), ('39','jspgen','36','留言清空','0','0','1','/admin/guestbook!clear.gen',NULL,NULL,'2','19,36,39',NULL), ('4','jspgen','1','密码修改','0','0','0','/admin/i_user!password.gen',NULL,NULL,'1','1,4',NULL), ('40','jspgen','36','留言查看/回复','0','0','1','/admin/guestbook!view.gen',NULL,NULL,'2','19,36,40',NULL), ('41','jspgen','36','留言回复_提交','0','0','1','/admin/guestbook!update.gen',NULL,NULL,'2','19,36,41',NULL), ('42','jspgen','19','事务区','0','1','0',NULL,NULL,NULL,'1','19,42','43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73'), ('43','jspgen','42','角色','0','0','0','/admin/admin_role!list.gen',NULL,NULL,'2','19,42,43',NULL), ('44','jspgen','42','角色删除','0','0','1','/admin/admin_role!delete.gen',NULL,NULL,'2','19,42,44',NULL), ('45','jspgen','42','角色添加','0','0','1','/admin/admin_role!add.gen',NULL,NULL,'2','19,42,45',NULL), ('46','jspgen','42','角色添加_提交','0','0','1','/admin/admin_role!save.gen',NULL,NULL,'2','19,42,46',NULL), ('47','jspgen','42','角色修改','0','0','1','/admin/admin_role!edit.gen',NULL,NULL,'2','19,42,47',NULL), ('48','jspgen','42','角色修改_提交','0','0','1','/admin/admin_role!update.gen',NULL,NULL,'2','19,42,48',NULL), ('49','jspgen','42','管理员','0','0','0','/admin/admin!list.gen',NULL,NULL,'2','19,42,49',NULL), ('5','jspgen','1','密码修改_提交','0','0','1','/admin/i_user!passwordUpdate.gen',NULL,NULL,'1','1,5',NULL), ('50','jspgen','42','管理员查看','0','0','1','/admin/admin!view.gen',NULL,NULL,'2','19,42,50',NULL), ('51','jspgen','42','管理员禁用','0','0','1','/admin/admin!disabled.gen',NULL,NULL,'2','19,42,51',NULL), ('52','jspgen','42','管理员启用','0','0','1','/admin/admin!undisabled.gen',NULL,NULL,'2','19,42,52',NULL), ('53','jspgen','42','管理员删除','0','0','1','/admin/admin!delete.gen',NULL,NULL,'2','19,42,53',NULL), ('54','jspgen','42','管理员添加','0','0','1','/admin/admin!add.gen',NULL,NULL,'2','19,42,54',NULL), ('55','jspgen','42','管理员添加_提交','0','0','1','/admin/admin!save.gen',NULL,NULL,'2','19,42,55',NULL), ('56','jspgen','42','管理员修改','0','0','1','/admin/admin!edit.gen',NULL,NULL,'2','19,42,56',NULL), ('57','jspgen','42','管理员修改_提交','0','0','1','/admin/admin!update.gen',NULL,NULL,'2','19,42,57',NULL), ('58','jspgen','42','访问权限','0','0','0','/admin/purview!input.gen',NULL,NULL,'2','19,42,58',NULL), ('59','jspgen','42','权限拖拽','0','0','1','/admin/purview!dropJSON.gen',NULL,NULL,'2','19,42,59',NULL), ('6','jspgen','1','我的消息','0','0','0','/admin/i_ums!list.gen',NULL,NULL,'1','1,6',NULL), ('60','jspgen','42','权限删除','0','0','1','/admin/purview!delete.gen',NULL,NULL,'2','19,42,60',NULL), ('61','jspgen','42','权限更新_提交','0','0','1','/admin/purview!updateJSON.gen',NULL,NULL,'2','19,42,61',NULL), ('62','jspgen','42','权限导入','0','0','1','/admin/purview!importXML.gen',NULL,NULL,'2','19,42,62',NULL), ('63','jspgen','42','权限导出','0','0','1','/admin/purview!exportXML.gen',NULL,NULL,'2','19,42,63',NULL), ('64','jspgen','42','操作日志','0','0','0','/admin/log!list.gen',NULL,NULL,'2','19,42,64',NULL), ('65','jspgen','42','操作日志删除','0','0','1','/admin/log!delete.gen',NULL,NULL,'2','19,42,65',NULL), ('66','jspgen','42','操作日志清空','0','0','1','/admin/log!clear.gen',NULL,NULL,'2','19,42,66',NULL), ('67','jspgen','42','用户查看','0','0','1','/admin/user!view.gen',NULL,NULL,'2','19,42,67',NULL), ('68','jspgen','42','用户密码修改','0','0','1','/admin/user!password.gen',NULL,NULL,'2','19,42,68',NULL), ('69','jspgen','42','用户密码修改_提交','0','0','1','/admin/user!passwordUpdate.gen',NULL,NULL,'2','19,42,69',NULL), ('7','jspgen','1','消息查看','0','0','1','/admin/i_ums!view.gen',NULL,NULL,'1','1,7',NULL), ('70','jspgen','42','登录日志','0','0','0','/admin/login_log!list.gen',NULL,NULL,'2','19,42,70',NULL), ('71','jspgen','42','登录日志删除','0','0','1','/admin/login_log!delete.gen',NULL,NULL,'2','19,42,71',NULL), ('72','jspgen','42','登录日志清空','0','0','1','/admin/login_log!clear.gen',NULL,NULL,'2','19,42,72',NULL), ('73','jspgen','42','在线列表','0','0','0','/admin/online!list.gen',NULL,NULL,'2','19,42,73',NULL), ('74','jspgen','19','配置区','0','1','0',NULL,NULL,NULL,'1','19,74','75,76,77,78,79,80,81,82'), ('75','jspgen','74','字典','0','0','0','/admin/dictionary!input.gen',NULL,NULL,'2','19,74,75',NULL), ('76','jspgen','74','字典拖拽','0','0','1','/admin/dictionary!dropJSON.gen',NULL,NULL,'2','19,74,76',NULL), ('77','jspgen','74','字典删除','0','0','1','/admin/dictionary!delete.gen',NULL,NULL,'2','19,74,77',NULL), ('78','jspgen','74','字典更新_提交','0','0','1','/admin/dictionary!updateJSON.gen',NULL,NULL,'2','19,74,78',NULL), ('79','jspgen','74','部门','60','0','0','/admin/department!list.gen',NULL,NULL,'2','19,74,79',NULL), ('8','jspgen','1','消息删除','0','0','1','/admin/i_ums!delete.gen',NULL,NULL,'1','1,8',NULL), ('80','jspgen','74','部门拖拽','60','0','1','/admin/department!dropJSON.gen',NULL,NULL,'2','19,74,80',NULL), ('81','jspgen','74','部门删除','60','0','1','/admin/department!delete.gen',NULL,NULL,'2','19,74,81',NULL), ('82','jspgen','74','部门更新_提交','60','0','1','/admin/department!updateJSON.gen',NULL,NULL,'2','19,74,82',NULL), ('83','cms','0','内容','1','1','0',NULL,NULL,'admin','0','83','84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,170'), ('84','cms','83','节点','0','0','0','/cms/admin/node!list.gen',NULL,NULL,'1','83,84',NULL), ('85','cms','83','节点拖拽','0','0','1','/cms/admin/node!dropJSON.gen',NULL,NULL,'1','83,85',NULL), ('86','cms','83','节点删除','0','0','1','/cms/admin/node!delete.gen',NULL,NULL,'1','83,86',NULL), ('87','cms','83','节点添加','0','0','1','/cms/admin/node!add.gen',NULL,NULL,'1','83,87',NULL), ('88','cms','83','节点添加_提交','0','0','1','/cms/admin/node!save.gen',NULL,NULL,'1','83,88',NULL), ('89','cms','83','节点编辑','0','0','1','/cms/admin/node!edit.gen',NULL,NULL,'1','83,89',NULL), ('9','jspgen','1','消息清空','0','0','1','/admin/i_ums!clear.gen',NULL,NULL,'1','1,9',NULL), ('90','cms','83','节点编辑_提交','0','0','1','/cms/admin/node!update.gen',NULL,NULL,'1','83,90',NULL), ('91','cms','83','内容','0','0','0','/cms/admin/content!index.gen',NULL,NULL,'1','83,91',NULL), ('92','cms','83','内容列表','0','0','1','/cms/admin/content!list.gen',NULL,NULL,'1','83,92',NULL), ('93','cms','83','内容发布','0','0','1','/cms/admin/content!publish.gen',NULL,NULL,'1','83,93',NULL), ('94','cms','83','内容还原','0','0','1','/cms/admin/content!restore.gen',NULL,NULL,'1','83,94',NULL), ('95','cms','83','内容锁定','0','0','1','/cms/admin/content!lock.gen',NULL,NULL,'1','83,95',NULL), ('96','cms','83','内容解锁','0','0','1','/cms/admin/content!unlock.gen',NULL,NULL,'1','83,96',NULL), ('97','cms','83','内容移动','0','0','1','/cms/admin/content!move.gen',NULL,NULL,'1','83,97',NULL), ('98','cms','83','内容引用','0','0','1','/cms/admin/content!link.gen',NULL,NULL,'1','83,98',NULL), ('99','cms','83','内容推荐','0','0','1','/cms/admin/content!commend.gen',NULL,NULL,'1','83,99',NULL);
INSERT INTO `jspgen_sys_ums_user` VALUES ('1','1568635878234');
INSERT INTO `jspgen_user` VALUES ('1','jspgen','7A186167D7B633D0D5BF','QIWLC4','858503861@qq.com','1','15909155151','0',NULL,'1','0','127.0.0.1','1386168944125','1',NULL,NULL,'127.0.0.1','1568635815359',NULL,'0','0','0',NULL,'0'), ('2','admin','2C654111614748F68721','OASIZ3','858503861@qq.com','1','15909155151','1',NULL,'1','1','127.0.0.1','1463218815328','0',NULL,NULL,NULL,NULL,NULL,'0','1','0',NULL,'0');
INSERT INTO `jspgen_user_detail` VALUES ('1','JSPGen',NULL,NULL,NULL,'0','0','0','0.00000',NULL,NULL), ('2','管理员',NULL,NULL,NULL,'0','0','0','0.00000',NULL,NULL);
INSERT INTO `jspgen_user_group` VALUES ('1','管理员','0','0','1',NULL,NULL), ('2','游客','0','0','1',NULL,NULL), ('3','待验证','0','0','1',NULL,NULL), ('4','待审核','0','0','1',NULL,NULL), ('5','注册用户','0','1','1',NULL,NULL);
