﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>微信公众号</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><i><gen:if test='${empty param.id}'>添加<gen:else />编辑</gen:if>微信公众号</i></h2>
    <div class="area-content">
      <form id="form" name="form" method="post" action="<gen:if test='${empty param.id}'>wechat!save.gen<gen:else />wechat!update.gen</gen:if>">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right"><span class="red">*</span>&nbsp;名称：</td>
            <td><input id="name" name="name" type="text" class="text small" value="${wechat.name}" size="20" />
              <label for="name" generated="true" class="tip normal" tip=""></label></td>
          </tr>
          <tr class="border-top">
            <td align="right"><span class="red">*</span>&nbsp;AppId：</td>
            <td><input name="appid" type="text" class="text small" id="appid" value="${wechat.appid}" size="30" /></td>
          </tr>
          <tr class="border-top">
            <td align="right" valign="top"><span class="red">*</span>&nbsp;AppSecret：</td>
            <td><textarea name="appsecret" class="text small textarea general ignore" id="appsecret">${wechat.appsecret}</textarea></td>
          </tr>
          <tr class="border-top">
            <td align="right">管理员OpenId：</td>
            <td><span class="field"><input name="openid" type="text" class="text small" id="openid" value="${wechat.openid}" size="30" />&nbsp;&nbsp;
            昵称：<input name="nickname" type="text" class="text small" id="nickname" value="${wechat.nickname}" size="15" />
            </span></td>
          </tr>
          <gen:if test='${not empty param.id && not empty wechat.token}'>
          <tr class="border-top">
            <td align="right" valign="top">AccessToken：</td>
            <td><span class="field">${wechat.token}<br />有效时限：${wechat.tokenexpires} 秒，于 ${gen:dateTime(wechat.tokenexpiresTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)} 过期<br />获取时间：${gen:dateTime(wechat.tokentime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</span></td>
          </tr>
          </gen:if>
          <gen:if test='${not empty param.id && not empty wechat.ticket}'>
          <tr class="border-top">
            <td align="right" valign="top">JSAPI Ticket：</td>
            <td><span class="field">${wechat.ticket}<br />有效时限：${wechat.ticketexpires} 秒，于 ${gen:dateTime(wechat.ticketexpiresTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)} 过期<br />获取时间：${gen:dateTime(wechat.tickettime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</span></td>
          </tr>
          </gen:if>
          <tr class="border-top">
            <td colspan="2" class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
              <input type="hidden" name="id" value="${wechat.id}" />
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 表单验证插件 -->
<script type="text/javascript" src="${config.statie}js/validate/jquery.validate.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/validate.expand.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/messages_zh.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->
<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 表单验证
	var $form = $('#form'), $reset = $('input:reset');
	var validate = $form.validate({
		rules: {
			name: {
				required: true
			},
			appid: {
				required: true
			},
			appsecret: {
				required: true
			}
		},
		messages: {
			name: {
				required: "名称不允许为空"
			},
			appid: {
				required: "公众号Id不允许为空"
			},
			appsecret: {
				required: "公众号秘钥不允许为空"
			}
		},
		submitHandler: function(form) {
			$(form).ajaxSubmit($.extend({
				success: function(result) {
					// {'status':false,'message':'message', 'store':{'id':'id'}}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								refleshFromTab(); removeTab();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			}, formOptions));
			
			// 阻止表单默认提交
			return false;
		}
	});
	$reset.bind('click', function () {
		validate.resetForm();
	});
});
</script>
</body>
</html>