﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>模板</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="left"><a href="javascript:void(0);" class="button orange tiny add"><i></i>添加</a>&nbsp;<a href="javascript:void(0);" class="button blue tiny copy"><i></i>复制</a></td>
        <td align="right"><gen:if test="${not empty param.parent}"><a href="javascript:void(0);" class="button green tiny prev" uri="${param.parent}"><i></i>上一级</a></gen:if>&nbsp;<a href="javascript:void(0);" class="button green tiny" onclick="reflesh();"><i></i>刷新</a></td>
      </tr>
    </table>
  </div>
  <div class="area">
    <h2>
      <i>${empty param.mobile ? '':'移动端'}模板管理</i>
    </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="55%" class="border-left">名称</th>
          <th width="10%" class="border-left">大小</th>
          <th width="10%" class="border-left">扩展名</th>
          <th width="20%" class="border-left">最后修改时间</th>
        </tr>
        <gen:if test="${not empty pager.results}">
        <c:forEach items="${pager.results}" var="map">
        <tr class="border-top" id="${map.name}">
          <td align="center"><input type="checkbox" name="ids" value="${map.name}"></td>
          <td class="border-left">&nbsp;<gen:if test="${map.exte == 'dir'}"><a href="javascript:void(0);" class="view" uri="${param.parent}${map.name}/" title="进入">${map.name}</a><gen:else /><a href="javascript:void(0);" class="edit" title="编辑">${map.name}</a><gen:if test="${not empty map.comment}">&nbsp;【${map.comment}】</gen:if></gen:if></td>
          <td align="center" class="border-left">&nbsp;<gen:if test="${map.exte != 'dir'}">${map.size}</gen:if></td>
          <td align="center" class="border-left" title="${map.type}">&nbsp;<gen:if test="${map.exte == 'dir'}">目录<gen:else />${map.exte}</gen:if></td>
          <td align="center" class="border-left">${gen:dateTime(map.lastTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
        </tr>
        </c:forEach>
        <gen:else />
        <tr class="border-top">
        	<td colspan="5" align="center" class="ignore">暂无数据</td>
        </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="5"><div class="th-left"><a href="javascript:void(0);" class="button gray tiny blue-hover delete"><i></i>批量删除</a></div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <form name="search" method="post"><input name="mobile" type="hidden" value="${param.mobile}" /><input name="parent" type="hidden" value="${param.parent}" /><input name="" type="submit" value="" style="display:none;" /></form>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 变量
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	
	var $add = $('.push a.add');
	var $copy = $('.push a.copy');
	var $prev = $('.push a.prev');
	var $view = $('.table a.view');
	var $edit = $('.table a.edit');
	var $delete = $('.table a.delete');
	var $clear = $('.table a.clear');
	var $clearTd = $('.table td:not(.ignore)');
	var $pages = $('.table .pages');
	
	// 全选/反选
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 添加
	$add.bind('click', function () {
		return addTab('添加模板', 'template!add.gen?mobile=${param.mobile}&parent=${param.parent}', 'template_add');
	});
	
	// 编辑
	$edit.bind('click', function () {
		var id = $(this).closest('tr').attr('id'), idn = 'template_edit_'+id.replace('.', '-'); // 采用jQuery定位，不能出现定位符号
		return addTab($(this).attr('title'), 'template!edit.gen?mobile=${param.mobile}&parent=${param.parent}&filename='+id, idn);
	});
	
	// 目录上一级
	$prev.bind('click', function () {
		var uri = $(this).attr('uri');
		uri = uri.substring(0, uri.lastIndexOf('/', uri.lastIndexOf('/')-1)+1);
		window.location = '?mobile=${param.mobile}&parent='+uri;
	});
	
	// 目录进入
	$view.bind('click', function () {
		var uri = $(this).attr('uri');
		window.location = '?mobile=${param.mobile}&parent='+uri;
	});
	
	// 复制
	$copy.bind('click', function () {
		//var uri = $(this).attr('uri'); grapes.copyText(uri);
		var ids = $(this).closest('tr').attr('id');
		if(grapes.isEmpty(ids)){
			ids = grapes.values($check.attr('for'), ',');
			if(grapes.isNotEmpty(ids)){
				if(ids.split(',').length > 1) {
					$dialog.alert('一次只能复制一条数据…'); return false;
				}
			}
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('需要先选择一条数据…'); return false;
		}
		$.dialog.promptCopy('新文件名称：<br /><input value="'+ids+'" style="width:15em;padding:4px 2px;" />', function(newname) {
			$.ajax({
				url: 'template!copy.gen?mobile=${param.mobile}&parent=${param.parent}',
				data: {name:ids, newname:newname},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								reflesh();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		});
	});
	
	// 删除
	$delete.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定删除名为 <b class="red">'+ids+'</b> 的文件吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定删除选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'template!delete.gen?mobile=${param.mobile}&parent=${param.parent}',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
});

// 复制弹窗
$.dialog.promptCopy = function(content, yes, parent){
	var input;
	return $.dialog({
		id: 'PromptCopy', title: '复制',
		content: ['<div style="margin-bottom:5px;line-height:30px;font-size:14px">'+content+'</div>'].join(''),
		init: function(){
			input = this.DOM.content[0].getElementsByTagName('input')[0];
			input.select(); input.focus();
		},
		button: [{
			id:'okBtn', name: '确定', focus: false,
        	callback: function (here) {
				return yes && yes.call(this, input.value, here);
			}
		}]
	});
};
</script>
</body>
</html>
