﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>模板</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><i><gen:if test='${empty template}'>添加<gen:else />编辑</gen:if>模板</i></h2>
    <div class="area-content">
      <form action="template!save.gen" method="post" name="form" id="form">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <gen:if test='${empty template}'>
          <tr>
            <td width="15%" align="right">模板文件名：</td>
            <td><input id="filename" name="filename" type="text" class="text small" value="${template.name}" size="25" /></td>
          </tr>
          <gen:else />
          <tr>
            <td width="15%" align="right">模板文件名：</td>
            <td><input type="hidden" name="filename" value="${template.name}" />${template.name}&nbsp;&nbsp;【${template.comment}】</td>
          </tr>
          <tr class="border-top">
            <td align="right">上次修改时间：</td>
            <td>${gen:dateTime(template.lastTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}&nbsp;&nbsp;
            <label>
            <input name="isbak" type="checkbox" id="isbak" value="true" />
            备份原内容</label></td>
          </tr>
          </gen:if>
          <tr class="border-top">
          	<td colspan="2" align="right" valign="top"><textarea name="content" id="content" style="width:100%; height:500px;">${template.content}</textarea></td>
          </tr>
          <tr class="border-top">
            <td colspan="2" class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
              <input name="mobile" type="hidden" id="mobile" value="${param.mobile}" />
              <input name="parent" type="hidden" id="parent" value="${param.parent}" />
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 表单验证插件 -->
<script type="text/javascript" src="${config.statie}js/validate/jquery.validate.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/validate.expand.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/messages_zh.js"></script>
<script type="text/javascript" src="${config.statie}js/editArea/edit_area_full.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){	
	var $form = $('#form'), $reset = $('input:reset');
	
	// 表单验证
	var validate = $form.validate({
		rules: {
			filename: {
				required: true
			}
		},
		messages: {
			filename: {
				required: "请输入文件名！"
			}
		},
		submitHandler: function(form) {
			$('#content').text(editAreaLoader.getValue('content'));
			$(form).ajaxSubmit($.extend({
				success: function(result) {
					// {'status':false,'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								removeTab();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			}, formOptions));
			
			// 阻止表单默认提交
			return false;
		}
	});
	$reset.bind('click', function () {
		validate.resetForm();
	});
	
	// 初始化编辑器
	editAreaLoader.init({
		id: 'content'
		,start_highlight: false // 默认高亮关闭,代码过多会导致浏览器反映迟钝
		,font_size: '12'
		,font_family: 'Consolas,Courier,monospace'
		,allow_resize: 'no'
		,allow_toggle: false
		,word_wrap: true
		,language: 'zh'
		,syntax: 'html'	
		,toolbar: 'undo,redo,|,search,highlight,word_wrap,|,fullscreen'
		,show_line_colors: true
		,replace_tab_by_spaces: 4
		,min_height: 500
	});
});
</script>
</body>
</html>