﻿<%@page pageEncoding="UTF-8"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>报表</title>
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <form name="search" id="search" method="GET" action="?">
    <div class="area">
      <h2><i>查询</i></h2>
      <div class="area-content">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <!--<tr>
            <td width="35%" align="right">机构：</td>
            <td><input name="departmentId" type="hidden" value="" /><input name="departmentName" to="departmentId" type="text" class="text small" value="" size="20" readonly="readonly" /><label for="departmentName" generated="true" class="tip normal"></label>&nbsp;
              <label><input name="ischild" type="checkbox" value="1" ${not empty param.ischild ? 'checked':''}/>
              包含下级机构</label>
              <input name="departmentId" type="hidden" value="" /><input name="departmentName" to="departmentId" type="text" class="text small" value="" size="20" readonly="readonly" /><label for="departmentName" generated="true" class="tip normal"></label></td>
          </tr>-->
          <tr>
            <td width="35%" align="right">时间段：</td>
            <td><input name="startDate" type="text" class="text small" value="${startDate}" size="20" onfocus="WdatePicker({maxDate:'%y-%M-%d'});" />
              &nbsp;至&nbsp;
              <input name="endDate" type="text" class="text small" value="${endDate}" size="20" onfocus="WdatePicker({maxDate:'%y-%M-%d'});" /></td>
          </tr>
          <tr class="border-top">
            <td align="right">排序：</td>
            <td><select name="order">
                <option value="count desc" ${param.order == 'count desc' ? 'selected':''}>按总数</option>
                <option value="status6 desc" ${param.order == 'status6 desc' ? 'selected':''}>按已发布数</option>
                <option value="status3 desc" ${param.order == 'status3 desc' ? 'selected':''}>按待审数</option>
              </select>&nbsp;降序排序</td>
          </tr>
          <tr class="border-top">
            <th colspan="2" class="push txt-c"> <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input id="reset" name="reset" class="button gray small" type="reset" value="取 消" />
              </td>
          </tr>
        </table>
      </div>
    </div>
    <div class="area printArea">
      <h2><i>内容报表</i>&nbsp;<c:if test="${not empty startDate && not empty endDate}"><a href="javascript:void(0);">时间段：${startDate}&nbsp;至&nbsp;${endDate}</a></c:if>&nbsp;</h2>
      <div class="area-content">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <th height="30" align="center">机构名称</th>
            <th align="center" class="border-bottom border-left">总数</th>
            <th align="center" class="border-bottom border-left">已发布数</th>
            <th align="center" class="border-bottom border-left">待审数</th>
          </tr>
          <gen:if test="${not empty listMap}">
            <c:forEach items="${listMap}" var="map">
              <tr class="border-top">
                <td height="30" align="left">&nbsp;${map.name}<!--（${map.fullname}）--></td>
                <td align="center" class="border-left">${map.count}</td>
                <td align="center" class="border-left">${map.status6}</td>
                <td align="center" class="border-left">${map.status3}</td>
              </tr>
            </c:forEach>
            <gen:else />
            <tr class="border-top">
              <td colspan="4" align="center" class="ignore">暂无数据</td>
            </tr>
          </gen:if>
        </table>
      </div>
    </div>
  </form>
  <div style="line-height:50px; text-align:center;">
    <input id="excel" name="excel" class="button blue small" type="button" value="导 出" />
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
    <input id="print" name="print" class="button blue small" type="button" value="打 印" />
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<script type="text/javascript" src="${config.statie}ui/admin/js/tree.js"></script>
<!-- 当前页面 -->
<script type="text/javascript" src="${config.statie}js/jquery.printArea.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.table2excel.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
	// 打印、导出
	$('body').delegate('#print', 'click', function() {$('.printArea').printArea();});
	$('body').delegate('#excel', 'click', function() {$('.printArea').table2excel({filename: '内容报表_${startDate}_${endDate}', exclude_img: false,exclude_links: true,exclude_inputs: true});});
	$('body').delegate('#reset', 'click', function() {$('input[name="startday"]').attr('value', ''); $('input[name="endday"]').attr('value', '');});
});
</script>
</body>
</html>