﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>密码</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><i>修改密码</i></h2>
    <div class="area-content">
      <form id="form" name="form" method="post" action="user!passwordUpdate.gen">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right"> 用户名：</td>
            <td>${user.username}</td>
          </tr>
          <tr class="border-top">
            <td align="right">新密码：</td>
            <td><input name="password" type="password" class="text small" id="password" size="30" />
              <label for="password" generated="true" class="tip normal" tip="新密码至少需要 6 个字符！"></label></td>
          </tr>
          <tr class="border-top">
            <td align="right">密码强度：</td>
            <td><div class="passwords"><span class="safe0">弱</span><span class="safe1">中</span><span class="safe2">强</span></div></td>
          </tr>
          <tr class="border-top">
            <td align="right">确认密码：</td>
            <td><input name="repassword" type="password" class="text small" id="repassword" size="30" />
              <label for="repassword" generated="true" class="tip normal" tip="与新密码保持一致！"></label></td>
          </tr>
          <tr class="border-top">
            <td colspan="2" class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
            	<input type="hidden" name="id" value="${user.id}" />
            	<input name="submit" class="button blue small" type="submit" value="确 定" />
                &nbsp;&nbsp;&nbsp;&nbsp;
                <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.passwords.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 表单验证插件 -->
<script type="text/javascript" src="${config.statie}js/validate/jquery.validate.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/validate.expand.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/messages_zh.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 变量
	var $form = $('#form');
	var $reset = $('input:reset');
		
	// 表单验证
	var validate = $form.validate({
		rules:{
			password: {
				required: true,
				rangelength: [6, 20]
			}
			,repassword: {
				required: true,
				equalTo: "#password"
			}
		}
		,messages:{
			password: {
				required: '请输入新密码！',
				rangelength: $.format('新密码长度需要保持在{0}-{1}之间！')
			}
			,repassword: {
				required: '请输入确认密码！',
				equalTo: '两次密码输入不一致！'
			}
		},
		submitHandler: function(form) {
			$(form).ajaxSubmit($.extend({
				success: function(result) {
					// {'status':false,'message':'message', 'store':{'id':'id'}}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								refleshFromTab(); removeTab();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			}, formOptions));
			
			// 阻止表单默认提交
			return false;
		}
	});
	$reset.bind('click', function () {
		$('.passwords').removeClass().addClass('passwords');
		validate.resetForm();
	});
});
</script>
</body>
</html>