﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>用户</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><ul class="area-genre">
        <li id="regInfo" class="hover">注册信息</li>
        <li id="loginLog">登录日志</li>
      </ul>
      <i>我的信息</i></h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <td width="20%" align="right"> 用户名：</td>
          <td width="30%"  class="border-right">&nbsp;${user.username}</td>
          <td width="20%" align="right">用户组：</td>
          <td width="30%">&nbsp;${user.userGroup.name}</td>
        </tr>
        <tr class="border-top">
          <td align="right">注册邮箱：</td>
          <td class="border-right">&nbsp;<gen:if test='${user.emailVerify == 1}'><span class="green">${user.email}</span><gen:else />${user.email}</gen:if></td>
          <td align="right">注册手机：</td>
          <td><gen:if test='${user.mobileVerify == 1}'><span class="green">${user.mobile}</span><gen:else />${user.mobile}</gen:if></td>
        </tr>
        <tr class="border-top">
          <td align="right">注册时间：</td>
          <td class="border-right">&nbsp;${gen:dateTime(user.regTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
          <td align="right">注册IP：</td>
          <td>${user.regIp}</td>
        </tr>
        <tr class="border-top">
          <td align="right">最后登录时间：</td>
          <td class="border-right">&nbsp;${gen:dateTime(user.loginTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
          <td align="right">最后登录IP：</td>
          <td>${user.loginIp}</td>
        </tr>
        <gen:if test="${not empty userDetail}">
        <tr class="border-top">
          <td align="right">用户昵称：</td>
          <td class="border-right">&nbsp;${user.userDetail.nickname}</td>
          <td align="right">个性签名：</td>
          <td>${user.userDetail.sign}</td>
        </tr>
        <tr class="border-top">
          <td align="right">用户标签：</td>
          <td class="border-right">&nbsp;${user.userDetail.keywords}</td>
          <td align="right">用户描述：</td>
          <td>${user.userDetail.description}</td>
        </tr>
        </gen:if>
        <gen:if test="${not empty admin}">
        <tr class="border-top">
          <td align="right">管理姓名：</td>
          <td class="border-right">&nbsp;${admin.name}</td>
          <td align="right">管理角色：</td>
          <td>${admin.adminRole.name}</td>
        </tr>
        <tr class="border-top">
          <td align="right">加入时间：</td>
          <td class="border-right">&nbsp;${gen:dateTime(admin.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
          <td align="right">禁用：</td>
          <td><gen:if test="${admin.isDisabled == 1}"><span class="red">是</span><gen:else />否</gen:if></td>
        </tr>
        </gen:if>
      </table>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 变量
	var $regInfo = $('#regInfo');
	var $loginLog = $('#loginLog');
	
	// 注册信息
	$regInfo.bind('click', function () {
		location.href = 'i_user!view.gen';
	});
	// 登录日志
	$loginLog.bind('click', function () {
		location.href = 'i_user!list.gen';
	});
});
</script>
</body>
</html>
